<?php

use ODE\Model\GenerateurReferentielModel;

class OPS_generateur_referentiel extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_generateur_referentiel';
    public $object_name = 'OPS_generateur_referentiel';
    public $table_name = 'ops_generateur_referentiel';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $libelle;
    public $type;
    public $obligatoire;
    public $ineditable;
    public $defaut;
    public $aide;
    public $modifiable;
    public $params;

    public function bean_implements($interface)
    {
        switch ($interface) {
            case 'ACL':
                return true;
        }

        return false;
    }

    /**
     * @access public
     * @name getListReferentiel()
     * Fonction qui retourne la liste des champs dans le réferentiel sinon false
     *
     *  @return array|boolean               - $champs_referentiel : liste des champs ou false
     */
    public static function getListReferentiel()
    {

        $referentiel = new OPS_generateur_referentiel;
        $referentiels = $referentiel->get_full_list("libelle");

        foreach ($referentiels as $referentiel) {
            $champs_referentiel[] = array(
                'id' => $referentiel->id,
                'name' => $referentiel->name,
                'libelle' => $referentiel->libelle,
                'type' => $referentiel->type,
                'description' => $referentiel->description,
                'params' => $referentiel->params,
                'conditions' => "", //$referentiel->conditions,
                'obligatoire' => $referentiel->obligatoire,
                'ineditable' => $referentiel->ineditable,
                'defaut' => $referentiel->defaut,
                'aide' => $referentiel->aide,
                'modifiable' => $referentiel->modifiable,
            );
        }

        return (is_array($champs_referentiel) && count($champs_referentiel) > 0) ? $champs_referentiel : false;
    }

    /**
     * @access public
     * @name createReferentiel()
     * Fonction qui crée l'objet OPS_generateur_referentiel
     * 
     *  @param array                    $champ : tableau des données necessaire pour la création d'un champ
     *  @return string|boolean          $id : l'id de l'object crée sinon un tableau d'erreur 
     */
    public function createReferentiel($champ)
    {

        $erreurs = array();

        //  $GLOBALS['log']->fatal(" -----createReferentiel----- champ=" . print_r($champ, true));

        // $verification_champ = $this->isChampValid( $champ ) ;
        $verification_champ["statut"] = "ok";

        if ($verification_champ['statut'] == "ok") {

            $obj_referentiel = BeanFactory::newBean('OPS_generateur_referentiel');
            $obj_referentiel->type        = $champ['type'];

            // A mastered and complete dashed slugify | Implementation by Sebounet (Lanteas)
            $field_id = strtoupper($champ['name']);
            if (class_exists('Transliterator')) {
                try {
                    $field_id =  \Transliterator::create('NFD; [:Nonspacing Mark:] Remove; NFC')->transliterate($field_id);
                } catch (Exception $e) {
                    if (class_exists('Normalizer')) {
                        try {
                            $field_id = Normalizer::normalize($field_id, Normalizer::NFD);
                        } catch (Exception $e) {
                            $field_id = preg_replace('@[^\0-\x80]@u', "", $field_id);
                        }
                    }
                }
            }
            $field_id = trim($field_id);
            $field_id = preg_replace('/[-.]|(\s)/', "",  $field_id);
            $field_id = preg_replace('/[\']/', "",  $field_id);
            $field_id = preg_replace('/[^a-zA-Z0-9_]/', "_",  $field_id);
            $field_id = preg_replace('/([_]+)/', "_",  $field_id);
            $field_id = preg_replace('/(^[_]|[_]$)/', "",  $field_id);
            $field_id = strtolower($field_id);
            $obj_referentiel->name        = $field_id;

            $obj_referentiel->libelle     = (!empty($champ['libelle'])) ? $champ['libelle'] : $champ['name'];
            $obj_referentiel->obligatoire = (!empty($champ['obligatoire']) && $champ['obligatoire'] == 1) ? 1 : 0;
            $obj_referentiel->ineditable  = (!empty($champ['ineditable']) && $champ['obligatoire'] == 1) ? 1 : 0;
            $obj_referentiel->aide        = (!empty($champ['aide'])) ? $champ['aide'] : "";
            $obj_referentiel->defaut      = (!empty($champ['defaut'])) ? $champ['defaut'] : "";
            $obj_referentiel->description = "custom";
            $obj_referentiel->modifiable  = 1;
            $obj_referentiel->params      = (!empty($champ['params'])) ? $champ['params'] : "";
            $obj_referentiel->conditions      = (!empty($champ['conditions'])) ? $champ['conditions'] : "";
        } else {
            $erreurs[] = $verification_champ['data'];
        }

        if (is_array($erreurs) && count($erreurs) == 0) {
            if ($obj_referentiel->save()) {
                return $obj_referentiel->id;
            } else {
                $erreurs[] = "Echec de la création du champ ";
                return $erreurs;
            }
        } else {
            return $erreurs;
        }
    }

    /**
     * @access public
     * @name isChampValid()
     * Fonction qui vérifie si le champ est valid 
     * 
     *  @param array                    $champ : tableau des données necessaire pour la création d'un champ
     *  @return array                   $data [ statut , data ]
     */
    public static function isChampValid($name)
    {

        do {

            if (empty($name)) {
                return ["statut" => "err", "data" => "Le nom du champ est obligatoire pour la création."];
            }

            if (OPS_generateur_referentiel::isChampNameExist($name) === true) {
                return ["statut" => "err", "data" => "Un champ portant le meme nom existe deja en base de donnée."];
            }
        } while (0);

        return ["statut" => "ok", "data" => ""];
    }

    /**
     * @access private
     * @name isChampNameExist()
     * Fonction qui vérifie si le nom du champ n'est pas deja utilisé
     * 
     *  @param array                    $nom : Le nom du champ qu'on souhaite créer
     *  @return boolean                 $is_valid : true ou false
     */
    
    private static function isChampNameExist($nom)
    {

        $exist = false;
        $champs_referentiel = GenerateurReferentielModel::getListeGenerateur();
        foreach ($champs_referentiel as $champ_referentiel) {
            if ($champ_referentiel["nom"] === $nom) {
                $exist = true;
                break;
            }
        }
        return $exist;
    }
}
