
<?php

use ODE\Helper\OdeArrayHelper;
use ODE\Generateur\Factory\OdeFormFactory;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


class OPS_generateur_formulaireController extends SugarController
{


    /**
     * @access public
     * action_sauvegarder()
     * Fonction qui sauvegarde les modifications du formulaire
     *
     * @return json     $data
     */
    function action_sauvegarder()
    {

        $count_erreur = 0;
        $libelle_erreur = '';

        $champs = array(
            "json" => true,
        );

        // Vérification des champs recu dans $_REQUEST
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $data = $data_verified["data"]["json_array"];
            $cles = array_keys($data);
            $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $cles[0]);

            if (!empty($obj_vue->id)) {
                $obj_vue->update($data[$cles[0]]);
            }

            if($data['historique_version']){

                $objHistorique = BeanFactory::newBean('OPS_generateur_version');
                $objHistorique->name = $data['historique_version'];
                $objHistorique->description = $data['historique_commentaire'];
                $objHistorique->vue_json = base64_encode(json_encode($data));
                $objHistorique->save();

                $objFormulaire = BeanFactory::getBean('OPS_generateur_formulaire',$data['generateur_formulaire_id']);
                $objFormulaire->load_relationship('ops_generateur_version_ops_generateur_formulaire');
                $objFormulaire->ops_generateur_version_ops_generateur_formulaire->add($objHistorique);
            }
        } else {
            // On retourne les erreurs de vérification
            $libelle_erreur = $data_verified['data'];
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = ($count_erreur == 0) ? array('statut' => 'ok', 'data' => $data_verified['data']) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

      /*************************************************** Export / Import des formulaires  ***************************************************/

    /**
     * @access public
     * action_initFormulaireExport()
     * Fonction qui renvoie les parametres necessaires à l'initialisation de la modal export formulaire
     *
     */
    function action_initFormulaireExport()
    {

        $libelle_erreur = '';
        $resultat = array();
        $nb = 0 ; 

        // Vérification + récupération des modèles de dossiers à exporter 
        $data_verified = $this->getFormulaires($_REQUEST);

        if ($data_verified['statut'] == 'ok') {

            $formulaires = $data_verified['data'];
            if (is_array($formulaires) && count($formulaires) > 0) {
                foreach ($formulaires as $formulaire_id) {
                    // On récupere le formulaire
                    $formulaire = BeanFactory::getBean('OPS_generateur_formulaire', $formulaire_id);
                    if (!empty($formulaire->id)) {
                        // A ce stade aucune vérification 
                        $resultat[$formulaire->id]['statut'] = "ok";
                        $resultat[$formulaire->id]['erreur'] = "";
                        $resultat[$formulaire->id]['name'] = trim($formulaire->name);
                    }
                }
                $nb = count($formulaires);
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }


        if( empty($libelle_erreur)){
            $tab_json = $this->createJsonFormulaire($resultat);

            if( $tab_json['statut'] == "err" ){
                $libelle_erreur = $tab_json['data'];
            }
            else{
                $tab_modeles = $tab_json['data'];
            }
        }

        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => array('formulaires' => $resultat, 'nb' => $nb, 'download' => base64_encode(json_encode( $tab_modeles ) ) )) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access private
     * createJsonFormulaire()
     * Fonction pour créer le json du formulaire
     *
     * @return json     $data
     */
    private function createJsonFormulaire( $tab_modeles )
    {

        // la vérification des données se fait en amont donc on récupère les modèles directement
        $modeles = array(); 
        $modeles['type_document'] = array();

        foreach ($tab_modeles as $id => $infos) {

            // On récupere le contenu du modele de dossier 
            $obj_formulaire = BeanFactory::getBean('OPS_generateur_formulaire', $id);

            if (!empty($obj_formulaire->id)) {

                $modeles[$id]['name'] = $obj_formulaire->name;
                $modeles[$id]['couverture'] = $obj_formulaire->couverture;
                $modeles[$id]['description'] = base64_encode( $obj_formulaire->description );

                //Récupération de la vue agent si non vide 
                if( !empty( $obj_formulaire->agent_vue_id )){
                    $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $obj_formulaire->agent_vue_id );
                    if (!empty($obj_vue->id)) {
                        $modeles[$id][$obj_vue->id] = trim($obj_vue->name);
                        $modeles[$id][$obj_vue->id] = $obj_vue->getArrayFormat();
                        if(!empty($modeles[$id][$obj_vue->id]['type_document'])){
                            $modeles['type_document'] = array_merge($modeles['type_document'],$modeles[$id][$obj_vue->id]['type_document']);
                            unset($modeles[$id][$obj_vue->id]['type_document']);
                        }
                    }
                }
                
                //Récupération de la vue usager si non vide 
                if( !empty( $obj_formulaire->usager_vue_id )){
                    $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $obj_formulaire->usager_vue_id );
                    if (!empty($obj_vue->id)) {
                        $modeles[$id][$obj_vue->id] = trim($obj_vue->name);
                        $modeles[$id][$obj_vue->id] = $obj_vue->getArrayFormat();
                        if(!empty($modeles[$id][$obj_vue->id]['type_document'])){
                            $modeles['type_document'] = array_merge($modeles['type_document'],$modeles[$id][$obj_vue->id]['type_document']);
                            unset($modeles[$id][$obj_vue->id]['type_document']);
                        }
                    }
                }
            }
            else{
                $libelle_erreur = 'Impossible de récupérer le formulaire - '.$infos['name'];
            }
        }
        return (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $modeles ) : array('statut' => 'err', 'data' => $libelle_erreur);
    }


    /** 
     * @access private
     * getFormulaires()
     * Fonction qui vérifie les données avant traitement
     *
     */
    private function getFormulaires()
    {

        global $db;
        $libelle_erreur = '';
        $formulaires = [];

        do {

            $data_verified = OdeArrayHelper::isDataValid($_REQUEST, ["json" => true]);
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = 'Aucun formulaire n\'a été récupéré';
                break;
            }

            $data = $data_verified["data"]["json_array"];

            if (!empty($data['formulaires']) && is_array($data['formulaires']) && count($data['formulaires']) > 0) {
                $formulaires = $data['formulaires'];
                break;
            }
            if (!empty($data['filtres'])) {
                // Ce traitement est utilisé dans le cas ou l'utilisateur sélectionne l'intégralité des formulaires + filtres
                $mass = new MassUpdate();
                $mass->generateSearchWhere('OPS_generateur_formulaire', $data['filtres']);
                $where_clause = $mass->where_clauses;
                $obj_formulaire = new OPS_generateur_formulaire();
                $query = $obj_formulaire->create_export_query("", $where_clause);
                $result = $db->query($query);
                while ($formulaire = $db->fetchByAssoc($result)) {
                    $formulaires[] = $formulaire['id'];
                }
            }

            if (!is_array($formulaires) || count($formulaires) === 0) {
                $libelle_erreur = 'Aucun formulaire n\'a été récupéré';
                break;
            }
        } while (0);

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $formulaires) : array('statut' => 'err', 'data' => $libelle_erreur);

        return $data;
    }



    /**
     * @access public
     * action_importerJson()
     * Fonction pour importer des formulaires
     *
     * @return json     $data
     */
    function action_importerJson()
    {

        $libelle_erreur = "";
        $resultat_creation = array();
        $statut = false;

        // Liste des champs à vérifier, true si c'est obligatoire
        $champs = array("json" => true);

        // Vérification des données recus dans  $_REQUEST
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $formulaires = $data_verified['data']['json_array'];
            $typeDocuementList = array();
            // On parcours les guides d'instruction 
            if(!empty($formulaires['type_document'])){
                foreach ($formulaires['type_document'] as $key => $type_document) {
                    $typeDocumentObj = BeanFactory::newBean('OPS_type_document');
                    $where = 'ops_type_document.name = "'. html_entity_decode($type_document['name']) .'"';

                    $typeDocumentList = $typeDocumentObj->get_full_list('name',$where);
                    if(empty($typeDocumentList)){
                        $typeDocumentObj->name = $type_document['name'];
                        $typeDocumentObj->statut = $type_document['statut'];
                        $typeDocumentObj->objet = (empty($type_document['objet']))?"dossier":$type_document['objet'];
                        $typeDocumentObj->taille_limite = $type_document['taille_limite'];
                        $typeDocumentObj->multi_fichier = $type_document['multi_fichier'];
                        $typeDocumentObj->format = (empty($type_document['format_multiselect'])) ? "^image/jpeg^,^application/pdf^,^image/png^" : $type_document['format_multiselect'];

                        $typeDocumentObj->identifiant = $type_document['identifiant'];
                        $typeDocuementList[$key] = $typeDocumentObj->save();
                    }
                    else
                    {
                        $typeDocuementList[$key] = $typeDocumentList[0]->id;
                    }
                }
            }
            unset($formulaires['type_document']);
            foreach ($formulaires as $formulaire_id => $formulaire) {
                do {

                    $resultat_formulaire = array('name' => '', 'statut' => 'err', 'erreur' => '');
                    // Vérification du nom du formulaire
                    if (empty($formulaire['name'])) {
                        $resultat_formulaire['name'] = "Sans nom";
                        $resultat_formulaire['erreur'] = "Le nom du formulaire est vide. ";
                        $resultat_creation[$formulaire_id] = $resultat_formulaire;
                        break;
                    } else {
                        $resultat_formulaire['name'] = ($this->isNameFormulaireExist($formulaire['name']) === true) ? $this->getNameFormulaire($formulaire['name']) : $formulaire['name'];
                    }
                    if (!empty($formulaire['erreur'])) {
                        $resultat_formulaire['erreur'] = $formulaire['erreur'];
                        $resultat_creation[$formulaire_id] = $resultat_formulaire;
                        break;
                    }
                    $new_formulaire = BeanFactory::newBean('OPS_generateur_formulaire');
                    $new_formulaire->name = $resultat_formulaire['name'] ;
                    $new_formulaire->couverture = $formulaire['couverture'];
                    $new_formulaire->description = base64_decode($formulaire['description']);

                    $type_vue = 0 ; 

                    unset($formulaire['name']);
                    unset($formulaire['couverture']);
                    unset($formulaire['description']);
                    foreach ($formulaire as $key => $value) {

                        // On crée le formulaire 
                        // Vérification du nom de la vue
                        if (empty($value['name'])) {
                            $resultat_formulaire['name'] = "Sans nom";
                            $resultat_formulaire['erreur'] = "Le nom de la vue est vide. ";
                            $resultat_creation[$formulaire_id] = $resultat_formulaire;
                            break;
                        } else {
                            $nom_vue = ($this->getNameVue($value['name']) === true) ? $this->getNameVue($value['name']) : $value['name'];
                        }
                        $new_vue = BeanFactory::newBean('OPS_generateur_vue');
                        $new_vue->name = $nom_vue;
                        $new_vue->cle = $value['cle'];
                        $id_vue = $new_vue->save();

                        if ($type_vue == 0) {
                            $new_formulaire->agent_vue_id = $id_vue;
                        } elseif ($type_vue == 1) {
                            $new_formulaire->usager_vue_id = $id_vue;
                        } else {
                            $new_formulaire->partenaire_vue_id = $id_vue;
                        }

                        $type_vue++;

                        // On crée les onglets 
                        foreach ($value['onglets'] as $onglet) {
                            $new_onglet = BeanFactory::newBean('OPS_generateur_onglet');
                            $new_onglet->name = $onglet['name'];
                            $new_onglet->libelle = $onglet['libelle'];
                            $new_onglet->cle = $onglet['cle'];
                            $new_onglet->ordre = $onglet['ordre'];
                            $new_onglet->conditions = $onglet['conditions'];
                            $new_onglet->save();
                            // On crée la relation formulaire <-> onglet
                            $new_vue->load_relationship('ops_generateur_vue_ops_generateur_onglet');
                            $new_vue->ops_generateur_vue_ops_generateur_onglet->add($new_onglet);

                            // On crée les champs des onglets
                            foreach ($onglet['champs'] as $num_ligne => $ligne){
                                $num_ordre = 0 ; 

                                foreach ($ligne as $ordre => $champ) {

                                    if($champ['type'] == 'file'){
                                        $params = json_decode(base64_decode($champ['params']),true);
                                        if(!empty($params['attache']) && !empty($typeDocuementList[$params['attache']])){
                                            $params['attache'] = $typeDocuementList[$params['attache']];
                                            $champ['params'] = base64_encode(json_encode($params));
                                        }
                                    }

                                    // Vérification d'existance dans le référentiel
                                    $this->verif_existance_referentiel($champ);
                                    $new_champ = BeanFactory::newBean('OPS_generateur_champ');
                                    $new_champ->name = $champ['nom'];
                                    $new_champ->libelle = $champ['libelle'];
                                    $new_champ->obligatoire = $champ['obligatoire'];
                                    $new_champ->type = $champ['type'];
                                    $new_champ->cle = $champ['cle'];
                                    $new_champ->ineditable = $champ['ineditable'];
                                    $new_champ->aide = $champ['aide'];
                                    $new_champ->defaut = $champ['defaut'];
                                    $new_champ->description = $champ['description'];
                                    $new_champ->params = $champ['params'];
                                    $new_champ->modifiable = $champ['modifiable'];
                                    $new_champ->conditions = $champ['conditions'];
                                    $new_champ->ordre = $num_ordre;
                                    $new_champ->ligne = $num_ligne;
                                    $new_champ->save();
                                    // On crée la relation onglet <-> champ
                                    $new_onglet->load_relationship('ops_generateur_onglet_ops_generateur_champ');
                                    $new_onglet->ops_generateur_onglet_ops_generateur_champ->add($new_champ);
                                    if( $num_ordre == 0 ){
                                        $num_ordre = 1 ; 
                                    }
                                    else{
                                        $num_ordre = 0 ; 

                                    }
                                }
                            }
                        }
                        $new_formulaire->save();

                        $resultat_formulaire['statut'] = 'ok';
                        $resultat_creation[$new_formulaire->id] = $resultat_formulaire;
                    }
                } while (0);
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si les formulaires ont bien été crées on retourne le résultat de l'opération
        $data = (is_array($resultat_creation) && count($resultat_creation) > 0) ? array('statut' => 'ok', 'data' => array('formulaires' => $resultat_creation)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    private function verif_existance_referentiel( $new_champ ){

        $exist = false;
        $obj_referentiel = BeanFactory::newBean('OPS_generateur_referentiel');
        $liste_champs = $obj_referentiel->get_full_list('name','ops_generateur_referentiel.name="'.$new_champ['nom'].'"');

        if ($new_champ['nom'] === $liste_champs[0]->name) $exist = true;
        // Si le champ n'existe pas dans le référentiel, on le créé
        if( !$exist ){
            $obj_referentiel = new OPS_generateur_referentiel;
            $obj_referentiel->name = $new_champ['nom'] ;
            $obj_referentiel->description = $new_champ['description'];
            $obj_referentiel->libelle = $new_champ['libelle'];
            $obj_referentiel->type = $new_champ['type'];
            $obj_referentiel->params = $new_champ['params'];
            $obj_referentiel->conditions = $new_champ['conditions'];
            $obj_referentiel->obligatoire = $new_champ['obligatoire'];
            $obj_referentiel->ineditable = $new_champ['ineditable'];
            $obj_referentiel->defaut = $new_champ['defaut'];
            $obj_referentiel->aide = $new_champ['aide'];
            $obj_referentiel->modifiable = $new_champ['modifiable'];
            $obj_referentiel->save();
        }

    }


    /**
     * @access private
     * isNameFormulaireExist()
     * Fonction qui vérifie si le champs du formulaire existe deja en BDD
     * 
     * @param string                  $formulaire_name: le nom du formulaire
     * @return boolean                $exist: true ou false
     */
    private function isNameFormulaireExist($formulaire_name)
    {
        $exist = false;
        $obj_referentiel = BeanFactory::newBean('OPS_generateur_formulaire');
        $liste_formulaires = $obj_referentiel->get_full_list('name','ops_generateur_formulaire.name="'.$formulaire_name.'"');

        if ($formulaire_name === $liste_formulaires[0]->name) $exist = true;

        return $exist;
    }

    /**
     * @access private
     * formateNameFormulaire()
     * Fonction qui retourne le nom du formulaire formaté 
     * 
     * @param string                  $formulaire_name: le nom du formulaire
     * @return boolean                $exist: true ou false
     */
    function formateNameFormulaire($formulaire_name)
    {
        if (strpos($formulaire_name, "(") !== false) {
            $formulaire_name = explode("(",  $formulaire_name)[0];
        }
        return strtolower(str_replace(" ", "", trim($formulaire_name)));
    }

    /**
     * @access private
     * getNameFormulaire()
     * Fonction qui retourne le nom du formulaire avec incrémentation si il existe
     * 
     * @param string                  $formulaire_name: le nom du formulaire
     * @return boolean                $new_formulaire_name: le nouveau nom du formulaire
     */
    private function getNameFormulaire($formulaire_name)
    {

        $name_result = "";
        $formulaire_names = array();
        $obj_formulaire = new OPS_generateur_formulaire;
        $liste_formulaires = $obj_formulaire->get_full_list();
        foreach ($liste_formulaires as $formulaire) {
            $name_formated = $this->formateNameFormulaire($formulaire->name);
            if (array_key_exists($name_formated, $formulaire_names)) {
                $formulaire_names[$name_formated]++;
            } else {
                $formulaire_names[$name_formated] = 1;
            }
        }

        if (array_key_exists($this->formateNameFormulaire($formulaire_name), $formulaire_names)) {
            $name_without_bracket = (strpos($formulaire_name, "(") !== false) ? explode("(",  $formulaire_name)[0] : $formulaire_name;
            $name_result = $name_without_bracket . " (" . $formulaire_names[$this->formateNameFormulaire($formulaire_name)] . ")";
        }

        return (!empty($name_result)) ? $name_result : $formulaire_name;
    }

    private function getNameVue($formulaire_name)
    {

        $name_result = "";
        $formulaire_names = array();
        $obj_formulaire = new OPS_generateur_vue;
        $liste_formulaires = $obj_formulaire->get_full_list();
        foreach ($liste_formulaires as $formulaire) {
            $name_formated = $this->formateNameFormulaire($formulaire->name);
            if (array_key_exists($name_formated, $formulaire_names)) {
                $formulaire_names[$name_formated]++;
            } else {
                $formulaire_names[$name_formated] = 1;
            }
        }

        if (array_key_exists($this->formateNameFormulaire($formulaire_name), $formulaire_names)) {
            $name_without_bracket = (strpos($formulaire_name, "(") !== false) ? explode("(",  $formulaire_name)[0] : $formulaire_name;
            $name_result = $name_without_bracket . " (" . $formulaire_names[$this->formateNameFormulaire($formulaire_name)] . ")";
        }

        return (!empty($name_result)) ? $name_result : $formulaire_name;
    }
}
