$(document).ready(function() {

	$('[role=section_title]').each(function() {
        $(this).closest('.edit-view-row-item').find('> .label').hide();
        $(this).text( $(this).closest('.edit-view-row-item').find('> .label').text().replaceAll(':', '') );
        $(this).show();
    });

    $('#phone_mobile').inputmask({"mask": "99 99 99 99 99"});
    $('#phone_home').inputmask({"mask": "99 99 99 99 99"});
    $('#phone_work').inputmask({"mask": "99 99 99 99 99"});
    $('#phone_other').inputmask({"mask": "99 99 99 99 99"});

    $('#phone_mobile').blur(function(){
        verif_tel("phone_mobile");
    });
    $('#phone_home').blur(function(){
        verif_tel("phone_home");
    });
    $('#phone_work').blur(function(){
        verif_tel("phone_work");
    });
    $('#phone_other').blur(function(){
        verif_tel("phone_other");
    });

    //Autocomplétion du code postal
    $('#primary_address_postalcode').autocomplete({
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?postcode=" + $(self.element).val() + "&limit=25",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var villes = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.city, villes) == -1){
                            villes.push(item.properties.city);
                            var ville = item.properties.city;
                            var villeReg = ville.replace(/\s\d*[e]\sArrondissement/,'');
                            return {label: item.properties.postcode + " " + item.properties.city,
                                    city: villeReg,
                                    value: item.properties.postcode
                                };
                        }
                    }));
                }
            });
        },
        select: function(event,ui)
        {
            $(event.target).val(ui.item.city);
        }
    });

    //Autocomplétion de la ville
    $('#primary_address_city').autocomplete({
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?q=" + $(self.element).val() + "&type=municipality&limit=20&autocomplete=1",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var villes = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.city, villes == -1)){
                            villes.push(item.properties.city);
                            var ville = item.properties.city;
                            var villeReg = ville.replace(/\s\d*[e]\sArrondissement/,'');
                            return {label: item.properties.postcode + " " + item.properties.city,
                                    postcode: item.properties.postcode,
                                    value: villeReg
                                };
                        }
                    }));
                }
            });
        },
        select: function(event,ui)
        {
            $(event.target).val(ui.item.postcode);
        }
    });

    //Autocomplétion de la voie
    $('#primary_address_street').autocomplete({
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?q=" + $(self.element).val() + "&type=street&limit=10&autocomplete=1",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var voies = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.name, voies) == -1){
                            voies.push(item.properties.name);
                            return {label: item.properties.name,
                                    value: item.properties.name
                                };
                        }
                    }));
                }
            });
        }
    });


	function verif_tel( type ){

	    var estValide;
	    var tel = document.getElementById(type).value ;
	    
	    tel = tel.replace(/ /gi , "");

	    var valide=/^0[1-6]\d{8}$/;

	    if( !valide.test(tel)){
	        
	        estValide = false;
	  
	    }
	   

	    if( estValide == false ){

	        document.getElementById(type).style.backgroundColor = "red";

	    }
	    else{

	        document.getElementById(type).style.backgroundColor = "#c3e7fd";

	    }   

	}

});