<?php
class Filtre_ThematiqueViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);
    }

    private function setData(){

        global $db, $app_list_strings;
        $thematiques = $app_list_strings['ops_thematique_list'] ?? [];

        $options = [];
        foreach($thematiques as $value => $libelle){
            if($value == "") continue;
            $options[$value] = $libelle;
        }

        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['thematique'] ?? array();
        $valeur = isset($infosFiltre['valeurs']) ? $infosFiltre['valeurs'] : "";

        $this->smarty->assign("NOM_LISTE", "Thématique"); // Le nom du menu deroulant
        $this->smarty->assign("ICON", "fas fa-tag"); // l'icone souhaité
        $this->smarty->assign("NOM_CHAMP", "thematique"); // le nom du champ en bdd
        $this->smarty->assign("VALEURS_SELECT", strval($valeur)); // la valeur déjà selectionné (après recherche)
        $this->smarty->assign("NOM_TABLE", "ops_dossier"); // nom de la table
        $this->smarty->assign("TYPE_CHAMPS", $this->type); // type de champ (ici basique)
        $this->smarty->assign("OPTIONS", $options); // les differentes options du menu déroulant
        
    }

    public function getOrdre(){
        return 2;
    }
}