<?php
class Filtre_ComissionViewUtils {

    private $smarty;
    private $template;
    private $type = "relation";


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);
    }

    private function setData(){
        global $db;
        

        $query = "SELECT distinct id, name 
                    FROM ops_commission 
                    where statut_commission = 1 and deleted = 0";
        $query = $db->query($query);
        

        $options = [];

        while($row = $db->fetchRow($query)){
            $options[$row['id']] = $row['name'];
        }
        $this->smarty->assign("OPTIONS", $options);
            
        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples_relation']['commission'] ?? array();
        $valeur = $infosFiltre['valeurs'] ?? "";

        $this->smarty->assign("NOM_LISTE", "Commission"); // nom de la liste
        $this->smarty->assign("ICON", "fas fa-users"); // icone
        $this->smarty->assign("VALEURS_SELECT", $valeur); // valeur selectionné
        $this->smarty->assign("RELATE_TABLE", "ops_commission_ops_dossier"); // table de relation
        $this->smarty->assign("NOM_FILTRE", "commission"); // nom du filtre pour la div
        $this->smarty->assign("CHAMPS1_R", "ops_dossier_id"); // champ 1 de la relation 
        $this->smarty->assign("CHAMPS2_R", "ops_commission_id"); // champ 2 de la relation
        $this->smarty->assign("NOM_CHAMP", "id"); // id du champs dans sa table cible
        $this->smarty->assign("NOM_TABLE", "ops_dossier"); // nom de la table source
        $this->smarty->assign("NOM_TABLE2", "ops_commission"); // nom de la table cible
        $this->smarty->assign("TYPE_CHAMPS", $this->type); // type du champ (ici relation)

        
        
    }

    public function getOrdre(){
        return 2;
    }
}