<?php

$dictionary['OPS_dossier'] = array(
    'table' => 'ops_dossier',
    'delete' => false,
    'audited' => false,
    'inline_edit' => false,
    'duplicate_merge' => false,
    'fields' => array(
        'cloture' => array(
            'required' => false,
            'name' => 'cloture',
            'vname' => 'LBL_CLOTURE',
            'type' => 'bool',
            'massupdate' => '1',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'assigned_user_id' => array(
            'name' => 'assigned_user_id',
            'rname' => 'user_name',
            'id_name' => 'assigned_user_id',
            'vname' => 'LBL_ASSIGNED_TO_ID',
            'group' => 'assigned_user_name',
            'massupdate' => '0',
            'type' => 'relate',
            'table' => 'users',
            'module' => 'Users',
            'reportable' => true,
            'isnull' => 'false',
            'dbType' => 'id',
            'audited' => true,
            'comment' => 'User ID assigned to record',
            'duplicate_merge' => 'disabled'
        ),
        'canal' => array(
            'required' => false,
            'name' => 'canal',
            'vname' => 'LBL_CANAL',
            'type' => 'enum',
            'massupdate' => 0,
            'default' => 'crm',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_canal_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'soutien_elus' => array(
            'required' => false,
            'name' => 'soutien_elus',
            'vname' => 'LBL_SOUTIEN_ELUS',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'elus' => array(
            'required' => false,
            'name' => 'elus',
            'vname' => 'LBL_ELUS',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => false,
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible'
        ),
        'reunions' => array(
            'required' => false,
            'name' => 'reunions',
            'vname' => 'LBL_REUNIONS',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => false,
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible'
        ),
        'sous_territoires' => array(
            'required' => false,
            'name' => 'sous_territoires',
            'vname' => 'LBL_SOUS_TERRITOIRES',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => false,
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible'
        ),
        'decision_commission' => array(
            'required' => false,
            'name' => 'decision_commission',
            'vname' => 'LBL_DECISION_COMMISSION',
            'type' => 'enum',
            'massupdate' => '1',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_decision_commission_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'commissions' => array(
            'required' => false,
            'name' => 'commissions',
            'vname' => 'LBL_COMMISSIONS',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => false,
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'commentaire_decision' => array(
            'required' => false,
            'name' => 'commentaire_decision',
            'vname' => 'LBL_COMMENTAIRE_DECISION',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'motif_decision' => array(
            'required' => false,
            'name' => 'motif_decision',
            'vname' => 'LBL_MOTIF_DECISION',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'ops_etape_id' => array(
            'name' => 'ops_etape_id',
            'vname' => 'LBL_ETAPE_OPS_ETAPE_ID',
            'type' => 'id',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'comment' => ''
        ),
        'etape' => array(
            'required' => false,
            'name' => 'etape',
            'rname' => 'name',
            'id_name' => 'ops_etape_id',
            'vname' => 'LBL_ETAPE',
            'type' => 'relate',
            'isnull' => 'true',
            'module' => 'OPS_etape',
            'table' => 'ops_etape',
            'massupdate' => false,
            'source' => 'non-db',
            'len' => 36,
            'link' => 'ops_etape_link',
            'unified_search' => true,
            'importable' => 'true',
            'studio' => 'visible'
        ),
        'ops_etape_link' => array(
            'name' => 'ops_etape_link',
            'type' => 'link',
            'relationship' => 'etape_relationship',
            'module' => 'OPS_etape',
            'bean_name' => 'ops_etape',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_etape',
            'side' => 'right'
        ),
        'ops_statut_id' => array(
            'name' => 'ops_statut_id',
            'vname' => 'LBL_STATUT_OPS_STATUT_ID',
            'type' => 'id',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'comment' => ''
        ),
        'statut' => array(
            'required' => false,
            'name' => 'statut',
            'rname' => 'name',
            'id_name' => 'ops_statut_id',
            'vname' => 'LBL_STATUT',
            'type' => 'relate',
            'isnull' => 'true',
            'module' => 'OPS_statut',
            'table' => 'ops_statut',
            'massupdate' => false,
            'source' => 'non-db',
            'len' => 36,
            'link' => 'ops_statut_link',
            'unified_search' => true,
            'importable' => 'true',
            'studio' => 'visible'
        ),
        'ops_statut_link' => array(
            'name' => 'ops_statut_link',
            'type' => 'link',
            'relationship' => 'statut_relationship',
            'module' => 'OPS_statut',
            'bean_name' => 'ops_statut',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_STATUT',
            'side' => 'right'
        ),
        'date_avancement' => array(
            'required' => false,
            'name' => 'date_avancement',
            'vname' => 'LBL_DATE_AVANCEMENT',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'demandeur' => array(
            'required' => false,
            'name' => 'demandeur',
            'vname' => 'LBL_DEMANDEUR',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'type_tiers' => array(
            'required' => false,
            'name' => 'type_tiers',
            'vname' => 'LBL_TYPE_TIERS',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'num_dossier' => array(
            'required' => false,
            'name' => 'num_dossier',
            'vname' => 'LBL_NUM_DOSSIER',
            'type' => 'int',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'enable_range_search' => false,
            'disable_num_format' => '1',
            'auto_increment' => true,
            'min' => 0,
            'max' => false,
            'validation' => array(
                'type' => 'range',
                'min' => 0,
                'max' => false
            )
        ),
        'date_are' => array(
            'required' => false,
            'name' => 'date_are',
            'vname' => 'LBL_DATE_ARE',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'date_demande' => array(
            'required' => false,
            'name' => 'date_demande',
            'vname' => 'LBL_DATE_DEMANDE',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'date_notification' => array(
            'required' => false,
            'name' => 'date_notification',
            'vname' => 'LBL_DATE_NOTIFICATION',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'libelle_dossier' => array(
            'required' => false,
            'name' => 'libelle_dossier',
            'vname' => 'LBL_LIBELLE_DOSSIER',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'libelle_compl' => array(
            'required' => false,
            'name' => 'libelle_compl',
            'vname' => 'LBL_LIBELLE_COMPL',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'thematique' => array(
            'required' => false,
            'name' => 'thematique',
            'vname' => 'LBL_THEMATIQUE',
            'type' => 'enum',
            'massupdate' => '1',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_thematique_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'libelle_dossier' => array(
            'required' => false,
            'name' => 'libelle_dossier',
            'vname' => 'LBL_LIBELLE_DOSSIER',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'champs_custom' => array(
            'required' => false,
            'name' => 'champs_custom',
            'vname' => 'LBL_CHAMPS_CUSTOM',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'dbtype' => 'longblob',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '200',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'latitude' => array(
            'required' => false,
            'name' => 'latitude',
            'vname' => 'LBL_LATITUDE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '200',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'longitude' => array(
            'required' => false,
            'name' => 'longitude',
            'vname' => 'LBL_LONGITUDE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '200',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'statut_geoloc' => array(
            'required' => false,
            'name' => 'statut_geoloc',
            'vname' => 'LBL_STATUT_GEOLOC',
            'type' => 'enum',
            'massupdate' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'false',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_statut_geoloc_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'citycode' => array(
            'required' => false,
            'name' => 'citycode',
            'vname' => 'LBL_CITYCODE',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '200',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'brouillon' => array(
            'required' => false,
            'name' => 'brouillon',
            'vname' => 'LBL_BROUILLON',
            'type' => 'enum',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_brouillon_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'ordre_onglet' => array(
            'required' => false,
            'name' => 'ordre_onglet',
            'vname' => 'LBL_ORDRE_ONGLET',
            'type' => 'int',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'enable_range_search' => false,
            'disable_num_format' => '',
            'min' => false,
            'max' => false
        ),
        'doublon' => array(
            'required' => false,
            'name' => 'doublon',
            'vname' => 'LBL_DOUBLON',
            'type' => 'enum',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_doublon_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'email' => array(
            'required' => false,
            'name' => 'email',
            'vname' => 'LBL_LIBELLE_EMAIL',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'email_cc' => array(
            'required' => false,
            'name' => 'email_cc',
            'vname' => 'LBL_EMAIL_CC',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'email_cci' => array(
            'required' => false,
            'name' => 'email_cci',
            'vname' => 'LBL_EMAIL_CCI',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'ops_personne_morale' => array(
            'required' => false,
            'name' => 'ops_personne_morale',
            'vname' => 'LBL_OPS_PERSONNE_MORALE',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => true,
            'inline_edit' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'personne_morale' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'personne_morale',
            'vname' => 'LBL_OPS_PERSONNE_MORALE',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_personne_morale',
            'ext2' => 'OPS_personne_morale',
            'module' => 'OPS_personne_morale',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'beneficiaire_id' => array(
            'required' => false,
            'name' => 'beneficiaire_id',
            'vname' => 'LBL_BENEFICIAIRE_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => true,
            'inline_edit' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'beneficiaire' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'beneficiaire',
            'vname' => 'LBL_BENEFICIAIRE',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'beneficiaire_id',
            'ext2' => 'OPS_individu',
            'module' => 'OPS_individu',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'incomplet' => array(
            'required' => false,
            'name' => 'incomplet',
            'vname' => 'LBL_INCOMPLET',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'justificatif_incomplet' => array(
            'required' => false,
            'name' => 'justificatif_incomplet',
            'vname' => 'LBL_JUSTIFICATIF_INCOMPLET',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'date_transmission' => array(
            'required' => false,
            'name' => 'date_transmission',
            'vname' => 'LBL_DATE_TRASMISSION',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'lien_demande_cde' => array(
            'required' => false,
            'name' => 'lien_demande_cde',
            'vname' => 'LBL_LIEN_DEMANDE_CDE',
            'type' => 'url',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'false',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'dbType' => 'varchar',
            'gen' => '',
            'link_target' => '_blank'
        ),
        'commentaire' => array(
            'required' => false,
            'name' => 'commentaire',
            'vname' => 'LBL_COMMENTAIRE',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'date_import' => array(
            'required' => false,
            'name' => 'date_import',
            'vname' => 'LBL_DATE_IMPORT',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'motif_rejet' => array(
            'required' => false,
            'name' => 'motif_rejet',
            'vname' => 'LBL_MOTIF_REJET',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '4',
            'cols' => '20'
        ),
        'duplication_id' => array(
            'required' => false,
            'name' => 'duplication_id',
            'vname' => 'LBL_DUPLICATION_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => true,
            'inline_edit' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'duplication' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'duplication',
            'vname' => 'LBL_DUPLICATION',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'duplication_id',
            'ext2' => 'OPS_dossier',
            'module' => 'OPS_dossier',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'flag_suppression' => array(
            'required' => false,
            'name' => 'flag_suppression',
            'vname' => 'LBL_FLAG_SUPPRESSION',
            'type' => 'bool',
            'massupdate' => '0',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'flag_justificatif_etude' => array(
            'required' => false,
            'name' => 'flag_justificatif_etude',
            'vname' => 'LBL_FLAG_JUSTIFICATIF_ETUDE',
            'type' => 'bool',
            'massupdate' => '0',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'flag_justificatif_reetude' => array(
            'required' => false,
            'name' => 'flag_justificatif_reetude',
            'vname' => 'LBL_FLAG_JUSTIFICATIF_REETUDE',
            'type' => 'bool',
            'massupdate' => '0',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'code_suivi' => array(
            'required' => false,
            'name' => 'code_suivi',
            'vname' => 'LBL_CODE_SUIVI',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'code_validation' => array(
            'required' => false,
            'name' => 'code_validation',
            'vname' => 'LBL_CODE_VALIDATION',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'date_expiration_code_validation' => array(
            'required' => false,
            'name' => 'date_expiration_code_validation',
            'vname' => 'LBL_DATE_EXPIRATION_CODE_VALIDATION',
            'type' => 'datetime',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        //Ajout pour AOS_PDF_Templates
        'ops_individu_template_id' => array(
            'required' => false,
            'name' => 'ops_individu_template_id',
            'vname' => 'LBL_INDIVIDU_TEMLPLATE_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => true,
            'inline_edit' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'dossier_personne_individu_fonction' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'dossier_personne_individu_fonction',
            'vname' => 'LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_individu_template_id',
            'ext2' => 'OPS_individu',
            'module' => 'OPS_individu',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'flag_partenaire' => array(
            'required' => false,
            'name' => 'flag_partenaire',
            'vname' => 'LBL_FLAG_PARTENAIRE',
            'type' => 'bool',
            'massupdate' => '0',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'dossier_prioritaire' => array(
            'required' => false,
            'name' => 'dossier_prioritaire',
            'vname' => 'LBL_DOSSIER_PRIORITAIRE',
            'type' => 'bool',
            'massupdate' => '1',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'dossier_urgent' => array(
            'required' => false,
            'name' => 'dossier_urgent',
            'vname' => 'LBL_DOSSIER_URGENT',
            'type' => 'bool',
            'massupdate' => '1',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'dossier_signale' => array(
            'required' => false,
            'name' => 'dossier_signale',
            'vname' => 'LBL_DOSSIER_SIGNALE',
            'type' => 'bool',
            'massupdate' => '1',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'flag_anonymise' => array(
            'required' => false,
            'name' => 'flag_anonymise',
            'vname' => 'LBL_FLAG_ANONYMISE',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'conversation_statut' => array (
            'required' => false,
            'name' => 'conversation_statut',
            'vname' => 'LBL_CONVERSATION_STATUT',
            'type' => 'enum',
            'options' => 'conversation_statut_list',
            'massupdate' => 1,
            'value' => 'fermee',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'studio' => 'visible',
            'dependency' => false,
        ),
        'conversation_origin' => array (
            'required' => false,
            'name' => 'conversation_origin',
            'vname' => 'LBL_CONVERSATION_ORIGIN',
            'type' => 'enum',
            'options' => 'conversation_origin_list',
            'massupdate' => 0,
            'no_default' => false,
            'value' => '',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 10,
            'size' => '20',
            'studio' => 'visible',
            'dependency' => false,
        ),
        'delai' => array(
            'required' => false,
            'name' => 'delai',
            'vname' => 'LBL_DELAI',
            'type' => 'enum',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_delai_list',
            'studio' => 'visible',
            'dependency' => false
        ),
    ),
    'indices' => array(
        'id' => array('name' => strtolower($module) . 'pk', 'type' => 'primary', 'fields' => array('id')),
        array('name' => 'idx_' . strtolower($module) . '_id_del', 'type' => 'index', 'fields' => array('id', 'deleted')),
        array('name' => 'idx_' . strtolower($module) . '_name_del', 'type' => 'index', 'fields' => array('name', 'deleted')),
        array('name' => 'idx_' . strtolower($module) . '_num_dossier', 'type' => 'index', 'fields' => array('num_dossier')),
    ),
    'relationships' => array(
        'statut_relationship' => array(
            'lhs_module' => 'OPS_statut',
            'lhs_table' => 'ops_statut',
            'lhs_key' => 'id',
            'rhs_module' => 'OPS_dossier',
            'rhs_table' => 'ops_dossier',
            'rhs_key' => 'ops_statut_id',
            'relationship_type' => 'one-to-many'
        ),
        'etape_relationship' => array(
            'lhs_module' => 'OPS_etape',
            'lhs_table' => 'ops_etape',
            'lhs_key' => 'id',
            'rhs_module' => 'OPS_dossier',
            'rhs_table' => 'ops_dossier',
            'rhs_key' => 'ops_etape_id',
            'relationship_type' => 'one-to-many'
        )
    ),
    'optimistic_locking' => true,
    'unified_search' => true
);
if (!class_exists('VardefManager')) {
    require_once('include/SugarObjects/VardefManager.php');
}
VardefManager::createVardef(
    'OPS_dossier',
    'OPS_dossier',
    array(
        'basic',
        'assignable',
        'security_groups'
    )
);