<?php

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;

class hook_dossier
{

	function init_demandeur($bean, $event, $arguments = null)
	{
		if ($event != 'process_record') {
			return;
		}

		$demandeur = ["id" => "", "name" => "", "type" => ""];

		// On récupere le dossier => la variable bean ne contient pas le champ type_tiers ... 
		$obj_dossier = BeanFactory::getBean('OPS_dossier', $bean->id);

		// On récupere le demandeur 
		if (!empty($obj_dossier->type_tiers)) {

			$demandeur["type"] = $obj_dossier->type_tiers;

			if (trim($obj_dossier->type_tiers) == "OPS_individu") {
				$demandeurs = $obj_dossier->get_linked_beans("ops_individu_ops_dossier", "OPS_individu");
				$demandeur["name"] =  (is_array($demandeurs) && count($demandeurs) == 1) ? $demandeurs[0]->name : "";
				$demandeur["id"] = (is_array($demandeurs) && count($demandeurs) == 1) ? $demandeurs[0]->id : "";
			}

		}

		if (!empty($demandeur["id"]) && !empty($demandeur["name"])) {
			$demandeur_html =   '<a href="/index.php?module=' . $demandeur["type"] . '&action=DetailView&record=' . $demandeur["id"] . '">
									<span class="sugar_field"> ' . $demandeur["name"] . '	</span>
								</a>';
		}

		$bean->demandeur = (!empty($demandeur_html)) ? $demandeur_html : "";
	}

	function init_dossier_lie($bean, $event, $arguments = null)
	{
		if ($event != 'process_record' || $_REQUEST['module'] != 'Home') {
			return;
		}

		global $db;

		$dossiers = array();
		$sql = " SELECT `ops_dossier_id` FROM `ops_dossier_ops_dossier` WHERE `ops_dossier_id2` = '" . $bean->id . "' AND `deleted` = '0' ";
		$result = $db->query($sql);
		while ($row = $db->fetchByAssoc($result)) {
			$dossiers[] = $row['ops_dossier_id'];
		}
		
		if(count($dossiers) == 1){
			$beanDossier = BeanFactory::getBean('OPS_dossier',$dossiers[0]);
			$field_value = "<a target='_blank' href='/index.php?module=OPS_dossier&action=DetailView&record=" . $beanDossier->id . "'>
							<span class='sugar_field'>" . $beanDossier->name . "</span></a>";
		}else{
			$field_value = "";
		}

		$bean->ops_dossier_ops_dossier_name = $field_value;
	}


	function init_statut($bean, $event, $arguments = null)
	{
		if ($event != 'process_record') {
			return;
		}

		// On récupere le dossier => la variable bean ne contient pas le champ type_tiers ... 
		$obj_dossier = BeanFactory::getBean('OPS_dossier', $bean->id);

		// On vérifie si c'est bien un brouillon
		$statut_id = (isset($obj_dossier->ops_statut_id) && !empty($obj_dossier->ops_statut_id)) ? $obj_dossier->ops_statut_id : "";

		$obj_statut = BeanFactory::getBean('OPS_statut', $statut_id);
		if (!empty($obj_statut->code_couleur)) {
			$bean->statut = '<span class="badge" style="background: ' . $obj_statut->code_couleur . ';">'.$obj_statut->name.'</span>';
		}

	}

	/**
	 * @access public
	 * @name set_lng_lat()
	 * Fonction qui initialise la longitude et la latitude du dossier à partir de l'adresse du demandeur
	 * 
	 *  @return void
	 */
	function set_lng_lat(&$bean, $event, $arguments = null)
	{

		if ($event != 'before_save') {
			return;
		}




		if (empty($bean->statut_geoloc) || $bean->statut_geoloc === "empty") {

			// Le 'type_tiers' du demandeur associé au dossier doit être unique.
			if (in_array(trim($bean->type_tiers), array('OPS_individu', 'OPS_personne_morale'))) {

				// Recup de la liste de demandeurs...
				switch (trim($bean->type_tiers)) {

					case 'OPS_individu':
						$demandeurs = $bean->get_linked_beans("ops_individu_ops_dossier", "OPS_individu");
						$address_prefix = 'primary';
						break;

					/*case 'OPS_personne_morale': TO DO A REVOIR
						$demandeurs = $bean->get_linked_beans("ops_personne_morale_ops_dossier", "OPS_personne_morale");
						$address_prefix = 'billing';
						break;*/
				}

				// Un seul demandeur possible sinon rien !
				$demandeur = (is_array($demandeurs) && count($demandeurs) == 1) ? $demandeurs[0] : false;

				if (!$demandeur) {
					// On trace l'erreur...
					//$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Aucun demandeur associé !");
				} else {

					/* 
						On récupère les informations d'adresse postale, reformate pour une requête API Adresse
						REST API : https://geo.api.gouv.fr/adresse
					*/
					$adresse_demandeur = array(
						'street'	 => $demandeur->{$address_prefix . '_address_street'},
						'city'	   => $demandeur->{$address_prefix . '_address_city'},
						'state'	  => $demandeur->{$address_prefix . '_address_state'},
						'postalcode' => $demandeur->{$address_prefix . '_address_postalcode'},
						'country'	=> $demandeur->{$address_prefix . '_address_country'}
					);

					// On s'assure que le demandeur dispose bien d'une adresse postale !
					// A minima une rue et un code postal pour que l'API BAM fonctionne et ne retourne pas une erreur « Missing query »
					if (!empty($adresse_demandeur['street']) && !empty($adresse_demandeur['postalcode'])) {

						// On crée un translitérateur via PECL intl


						// On va formatter l'adresse et la ville le plus proprement possible afin d'être le plus approchant de la saisie administrative.
						$_query_street = strtoupper(trim($adresse_demandeur['street']));
						$_query_street = preg_replace('/[°]/', "",  $_query_street);  // Convertit les degrés en espaces.
						$_query_street = preg_replace('/([\s]+)/', " ",  $_query_street);  // Convertit les espaces consécutifs en espaces simple.
						$_query_street = trim($_query_street);


						$_query_city = strtoupper(trim($adresse_demandeur['city']));
						$_query_city = preg_replace('/[°]/', "",  $_query_city);  // Convertit les degrés en espaces.
						$_query_city = preg_replace('/[.]/', " ",  $_query_city);  // Convertit les points en espaces.
						$_query_city = preg_replace('/[_]/', " ",  $_query_city);  // Convertit les underscores en espaces.
						$_query_city = preg_replace('/[0-9]/', " ",  $_query_city);  // Convertit les nombres en espaces.
						$_query_city = preg_replace('/([\s]+)/', " ",  $_query_city);  // Convertit les espaces consécutifs en espaces simple.
						$_query_city = trim($_query_city);


						$_query_postal = strtoupper(trim($adresse_demandeur['postalcode']));
						$_query_postal = substr(intval(trim($_query_postal)), 0, 5);


						$_query_context = (intval($_query_postal) > 95500) ? substr(intval(trim($_query_postal)), 0, 3) : '';


						$_query_country = strtoupper(trim($adresse_demandeur['country']));
						$_query_country = preg_replace('/[°]/', "",  $_query_country);  // Convertit les degrés en espaces.
						$_query_country = preg_replace('/[.]/', " ",  $_query_country);  // Convertit les points en espaces.
						$_query_country = preg_replace('/[_]/', " ",  $_query_country);  // Convertit les underscores en espaces.
						$_query_country = preg_replace('/[0-9]/', " ",  $_query_country);  // Convertit les nombres en espaces.
						$_query_country = preg_replace('/([\s]+)/', " ",  $_query_country);  // Convertit les espaces consécutifs en espaces simple.
						$_query_country = trim($_query_country);


						$_query  = "";
						$_query .= urlencode($_query_street . ' ' .  $_query_postal . ' ' .  $_query_city . ' ' . $_query_country);
						$_query .= '&type=housenumber&autocomplete=0&postcode=' . $_query_postal;
						$_query .= '&limit=10';


						// On requete sur le connecteur d'API...
						$json_url = 'https://api-adresse.data.gouv.fr/search/?q=' . $_query;
						$result   = @file_get_contents($json_url, true);

						$data	  = json_decode($result, true);

						/** /
						$GLOBALS['log']->fatal("[3] hook_dossier :: set_lng_lat => Liste des termes par adresse = ".print_r( array(
							'_query'   => $_query,
							'json_url' => $json_url,
							'data'     => $data,
						) , true ));
					/**/

						if (is_array($data)) {

							# On vérifie l'approximation et l'exactitude du résultat..
							/*
								L'approche est de comparer le ou les termes les plus parlants contenus dans l'adresse fournie et celle retournée.
								L'approximation du résultat peut engendrer des différences sur une adresse inconue ou invalide.
								L'exactitude se confirme par correspondance et existance du ou des termes longs qui sont représentatifs dans une adresse postale.

								On formate tous les caractères de chaines en majuscule, et on fait une translittération afin de 
								retirer tout caractère accentué ou autre signe diacritique. (procédé bancaire sur la reconnaissance des noms de porteur).

								Transformations : http://userguide.icu-project.org/transforms/general
								Normalisation : http://unicode.org/reports/tr15/
							*/

							$transliterator = Transliterator::createFromRules(':: Any-Latin; :: Latin-ASCII; :: NFD; :: [:Nonspacing Mark:] Remove; :: Lower(); :: NFC;', Transliterator::FORWARD);

							$geoloc_tl_street_provided = preg_split("/[\s,-.']+/", strtoupper($transliterator->transliterate($_query_street)));
							$geoloc_tl_street_received = preg_split("/[\s,-.']+/", strtoupper($transliterator->transliterate($data['features'][0]['properties']['name'])));
							unset($transliterator);

							/** /
							$GLOBALS['log']->fatal("[4] hook_dossier :: set_lng_lat => Liste des termes par adresse = ".print_r( array(
								'Provided TL' => $geoloc_tl_street_provided,
								'Received TL' => $geoloc_tl_street_received
							) , true ));
						/**/

							// Longueur des éléments
							$tl_provided_lengths = array_map('strlen', $geoloc_tl_street_provided);
							$tl_received_lengths = array_map('strlen', $geoloc_tl_street_received);

							// Moy des longueurs de termes...
							$avg_provided = floor(array_sum(array_values($tl_provided_lengths)) / sizeof($tl_provided_lengths));
							$avg_received = floor(array_sum(array_values($tl_received_lengths)) / sizeof($tl_received_lengths));

							// UPDATE : 10/09/2020
							// L'API BAM a été légèrement modifiée, une adaptation rapide est faite sur le calcul de la moy. des lettres par terme.
							// Ce discriminant ne doit pas écarter les termes de plus de 2 caractères. On la fixe manuellement à 2.
							$avg_provided = 2;
							$avg_received = 2;


							/** /
							$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Adresse = ".print_r( array(
								'tl_provided_lengths TL' => $tl_provided_lengths,
								'avg_provided TL' => $avg_provided,

								'tl_received_lengths TL' => $tl_received_lengths,
								'avg_received TL' => $avg_received
							) , true ));
						/**/

							// Récupère seulement les termes de longueur supèrieure à « avg_ »
							// On crée une fonction anonyme dans le array_map pour traiter et controler la longueur du terme.
							$tl_provided_matrix = array_map(function ($term) use ($avg_provided) {
								if (strlen($term) > $avg_provided) {
									return $term;
								} else {
									return false;
								}
							}, $geoloc_tl_street_provided);
							$tl_provided_matrix = array_filter($tl_provided_matrix); // Filter empty values

							$tl_received_matrix = array_map(function ($term) use ($avg_received) {
								if (strlen($term) > $avg_received) {
									return $term;
								} else {
									return false;
								}
							}, $geoloc_tl_street_received);
							$tl_received_matrix = array_filter($tl_received_matrix); // Filter empty values

							/** /
							$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Preserved Matrix = ".print_r( array(
								'tl_provided_matrix' => $tl_provided_matrix,
								'tl_received_matrix' => $tl_received_matrix
							) , true ));
						/**/


							// On récupère tous les termes qui matches présents à la fois dans les termes de l'adresse fournie, et celle retournée
							$geo_terms_matches = array_intersect($tl_provided_matrix, $tl_received_matrix);
							// $GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Geo Terme qui matches = ".print_r( $geo_terms_matches , true ));

							// On vérifie l'exactitude / !incertitude via le nombre de termes trouvés (% sur le nombre total) vs l'indice de scoring.
							//
							// Scoring à égaler|dépasser ...
							$integrity_base_scoring = floor(100 * $data['features'][0]['properties']['score']);

							// Nombre de termes minima comparé à ceux trouvés, en pourcentage...
							$min_terms_allowed =  min(sizeof($tl_provided_matrix), sizeof($tl_received_matrix));
							$ratio_matching = (100 * sizeof($geo_terms_matches)) / $min_terms_allowed;

							/** /
							$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Ration = ".print_r( array(
								'tl_provided_matrix' => $tl_provided_matrix,
								'tl_received_matrix' => $tl_received_matrix
							) , true ));
						/**/

							// Le ratio de vérification est-il supèrieur ou égal au score d'intégrité retourné par le connecteur API ?
							// Si oui, cette adresse semble potentiellement vraiment correpondre avec un taux d'incertitude minimal :)
							if ($ratio_matching >= $integrity_base_scoring) {

								$geo_coord		     = $data['features'][0]['geometry']['coordinates'];
								$bean->longitude	 = $geo_coord[0]; // Lng.
								$bean->latitude	     = $geo_coord[1]; // Lat.
								$bean->statut_geoloc = "valid";
								$bean->citycode	     = $data['features'][0]['properties']['citycode']; // Code INSEE.

								//	$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Coordonnées GPS trouvés (méthode d'approximation) = ".print_r( $data , true ));
							} else {
								// On ne met rien à jour car l'adresse semble être trop incertaine ! Ou alors on fixe 0
								$bean->longitude	 = '0'; // Lng.
								$bean->latitude	     = '0'; // Lat.
								$bean->statut_geoloc = "erreur";
								$bean->citycode	     = ''; // Code INSEE à vide car adresse incorrecte, invalide.

								//	$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Coordonnées GPS non correct (addresse peu crédible) = ".print_r( $data , true ));
							}


							//	$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Adresse Geometry = ".print_r( $data['features'][0]['properties'] , true ));

						} else {

							$bean->statut_geoloc = "erreur";
							$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Coordonnées GPS non trouvées. " . print_r($geo_coord, true));
						}
					} else {

						$bean->statut_geoloc = "empty";
						$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Adresse manquante !");
					}
				}
			} else {

				// Erreur. Type tier indefini !
				$GLOBALS['log']->fatal(" hook_dossier :: set_lng_lat => Erreur le type tiers est  indefini  ( type_tiers = " . $bean->type_tiers . " )");
			}
		}
	}



	// Méthode du hook « Cleanup »
	function delete_related_relations($bean, $event, $arguments = null)
	{
		if ($event != 'before_delete') {
			return;
		}

		global $sugar_config;

		$is_erreur = false;

		// On récupere le dossier 
		$obj_bean = (!empty($bean->id)) ? BeanFactory::getBean('OPS_dossier', $bean->id) : false;


		# On vérifie de disposer véritablement d'un dossier.
		if ($obj_bean === false) {

			$is_erreur = true;

			$GLOBALS['log']->fatal(" hook_dossier :: delete_related_relations => Récupération impossible du Bean Dossier !");
			return;
		}

		# On collecte l'ensemble des éléments liés...

		$linked_elements = array();
		$linked_elements['ops_journal']       = $bean->get_linked_beans("ops_dossier_ops_journal", "OPS_dossier");
		$linked_elements['ops_appairage']     = $bean->get_linked_beans("ops_dossier_ops_appairage", "OPS_dossier");
		$linked_elements['ops_tasks']         = $bean->get_linked_beans("ops_dossier_activities_tasks", "OPS_dossier");
		$linked_elements['ops_notes']         = $bean->get_linked_beans("ops_dossier_notes", "OPS_dossier");
		$linked_elements['ops_historisation'] = $bean->get_linked_beans("ops_historisation_ops_dossier", "OPS_dossier");
		$linked_elements['ops_documents']     = $bean->get_linked_beans("ops_dossier_documents", "OPS_dossier");
		$linked_elements['ops_justificatif']  = $bean->get_linked_beans("ops_dossier_ops_justificatif", "OPS_justificatif");

		foreach (array_keys($linked_elements) as $i => $relationship) {

			// Reme relationships between OPD_dossier and OPS_{$relationship}
			foreach ($linked_elements[$relationship] as $relation) {
				$relation->mark_deleted($relation->id);
			}
		}
		$dir = $sugar_config['ops_justificatif']['chemin']."/".$bean->id;

		$objects = scandir($dir);
	    foreach ($objects as $object) { 
	    	if ($object != "." && $object != "..") { 
	        	if (is_dir($dir. DIRECTORY_SEPARATOR .$object) && !is_link($dir."/".$object)){
	        		rmdir($dir. DIRECTORY_SEPARATOR .$object);

	        	}
	        else{

	    		unlink($dir. DIRECTORY_SEPARATOR .$object); 
	        }
	       } 
	     }
	     rmdir($dir);
	}

	//Envoi d'une notification lors de la suppression d'un brouillon
	function notification_suppression_brouillon($bean, $event, $arguments = null)
	{
		if ($event != 'before_delete') {
			return;
		}

		// Pour les dossiers temporaires, on bypass l'envoi de mail
		if ($bean->name == 'TEMP' || $bean->brouillon == 'non') {
			return;
		}

		$configuratorObj = new Configurator();
		$configuratorObj->loadConfig();

		if(!empty($configuratorObj->config['opensocle']['notif_usager_dossier_suppression'])){
			$objDemendeur = BeanFactory::getBean('OPS_individu',$bean->ops_individu_id);
			$mailer = new OdeMailer();
			$ode_email = new OdeEmail([
	            'bean_source_id' => $bean->id,
	            'bean_source_name' => 'OPS_dossier',
	            'bean_historisation_id' => $objDemendeur->id,
	            'bean_historisation_name' => 'OPS_individu',
	            'email_template_id' => $configuratorObj->config['opensocle']['notif_usager_dossier_suppression'],
	            'dest_to' => $objDemendeur->email1,
	            'dest_cc' => '',
	            'dest_cci ' => '',
	            'genere_dossier_pdf' => false,
	        ]);

	        $mailer->send($ode_email);
		}
	}

	function execute_action_statut(&$bean, $event, $arguments = null)
	{
		if ($event != 'before_save') {
			return;
		}

		if($_REQUEST['action'] == 'Save' && $bean->fetched_row['ops_statut_id'] != $_REQUEST['ops_statut_id']){
			$obj_statut = BeanFactory::getBean('OPS_statut', $_REQUEST['ops_statut_id']);
			$obj_statut->action_statut($bean);
		}
	}

	function set_reunions(&$bean, $event, $arguments = null)
	{
		if ($event != 'before_save' || $_REQUEST['action'] != 'updateDossier' || $_REQUEST['module'] != 'OPS_dossier' || !isset($_REQUEST['json'])) {
			return;
		}

		$json_decoded = json_decode(base64_decode($_REQUEST['json']));

		if(isset($json_decoded->reunions))
		{
			$name = '';
			if(!empty($json_decoded->reunions))
			{
				$obj_reunion = BeanFactory::getBean('OPS_reunion', $json_decoded->reunions);
				if(!empty($obj_reunion->id))
				{
					$name = $obj_reunion->name;
				}
			}
			$bean->reunions = $name;
		}
	}

	public function set_relation_sous_territoire_dossier(&$bean, $event, $arguments = null) 
    {   
        if($event != 'before_relationship_add' || $arguments['related_module'] != 'OPS_sous_territoire')
            return;

        $related_module = $arguments['related_bean'];

        if(!empty($related_module->id))
        {
			if(!empty($bean->sous_territoires))
			{
				$sous_territoires = explode("\n", $bean->sous_territoires);

				if(!in_array($related_module->name, $sous_territoires))
				{
					$bean->sous_territoires .= $related_module->name . "\n";
				}
			}
			else
			{
				$bean->sous_territoires = $related_module->name . "\n";
			}
        }
    }

	public function unset_relation_sous_territoire_dossier(&$bean, $event, $arguments = null) 
    {   
        if($event != 'before_relationship_delete' || $arguments['related_module'] != 'OPS_sous_territoire')
            return;

        $related_module = $arguments['related_bean'];

        if(!empty($related_module->id))
        {
			if(!empty($bean->sous_territoires))
			{
				$sous_territoires = explode("\n", $bean->sous_territoires);

				$key = array_search($related_module->name, $sous_territoires);
				if ($key !== false) {
					unset($sous_territoires[$key]);
				}

				global $db;

				$query = 'UPDATE ops_dossier SET ops_dossier.sous_territoires = "' . implode("\n", $sous_territoires) . '" WHERE ops_dossier.id = "' . $bean->id . '"';

				$db->query($query);
			}
        }
    }

	// méthode pour enregistrer le dossier dans le registre des suppressions apres la suppression d'un dossier
	public function sauvegarder_registre_suppression($bean, $event, $arguments = null)
	{
		if ($event != 'before_delete') {
			return;
		}

		$registre = BeanFactory::newBean("OPS_registre_suppression_dossier");
		$registre->name = $bean->name;
		$registre->ops_personne_morale = $bean->ops_personne_morale;
		$registre->beneficiaire_id = $bean->beneficiaire_id;
		$registre->demandeur_id = $bean->ops_individu_id;
		$registre->ops_dispositif = $bean->ops_dispositif_id;
		// quand la suppression provient d'un traitement la request est vide
		$registre->origine_suppression = (is_array($_REQUEST) && empty($_REQUEST)) ? "traitement" : "agent";
		$registre->date_creation = $bean->date_entered;
		
		$registre->save();
	}

	// méthode pour afficher le délai dans la list view des dossiers
	public function process_delai($bean, $event){
		if ($event != 'process_record') {
			return;
		}
		
		$configuratorObj = new Configurator();
		$configuratorObj->loadConfig();

		// recuperation de la config par defaut ou du parametrage
		$codeCouleur = $configuratorObj->config['opensocle']['custom_couleur_delai_0'] ? array(
			$configuratorObj->config['opensocle']['custom_couleur_delai_0'],
			$configuratorObj->config['opensocle']['custom_couleur_delai_1'],
			$configuratorObj->config['opensocle']['custom_couleur_delai_2'],
			$configuratorObj->config['opensocle']['custom_couleur_delai_3']
			) : translate('LIST_DEFAULT_COLOR_DELAI', 'OPS_dossier');

		if($bean->delai === "") return;
		
		$display = "<i class='fa-regular fa-clock' style='font-size:20px;color:". ($codeCouleur[$bean->delai] ?? $codeCouleur[0]) ."'></i>";
		$bean->delai = $display;
	}


}
