<?php


if (!class_exists('OPS_dossier')) {
	require_once('modules/OPS_dossier/OPS_dossier.php');
}



/**
 * Classe GeoDossier s'étend de OPS_Dossier.
 * @uses module/OPS_dossier/OPS_dossier.php
 * (Class builder for Geo Filters)
 *
 * Il ajoute une surcharge concernant la gestion des filtres dynamiques et leurs données cartographioques.
**/
class OPS_dossier_geo extends OPS_dossier
{


   /**
    * @param string, property label of the filter
    * @param string, property name of the combo filter
    * @param object JSON filter_data_node, represent the pointer of the node (scope)
    * @param string, javascript callback called on value change.
    * @param string, list of rendering class

    * @return string HTMLElement, a Combo dropdown to apply filter effect.
    */
   //Like as                          ('Dispositif', 'dispositif', 'name', '_action_select_filter', 'class:"custom-css-class"')
    public function addGeoSelectFilter($filter_label, $filter_property, $filter_data_node, $filter_callback, $filter_custom_uix, $filter_ismaster)
    {
    /*/
        $GLOBALS['log']->fatal(" OPS_dossier[GeoDossier] :: setGeoFilter => params » ".print_r( array(
            'filter_label'      => $filter_label,
            'filter_property'   => $filter_property,
            'filter_data_node'  => $filter_data_node,
            'filter_callback'   => $filter_callback,
            'filter_custom_uix' => $filter_custom_uix,
            'filter_ismaster'   => $filter_ismaster
        ) , true ));
    */

	    $html_component  = '';
        $html_component .= '<div class="filter-control">';
	    $html_component .= '<h3>'.$filter_label.' :</h3>';
	    $html_component .= '<select id="'.$filter_property.'" role="filter" data-master="'.$filter_ismaster.'" data-property="'.$filter_property.'" data-node="'.$filter_data_node.'" data-filter-cb="'.$filter_callback.'" style="width: 100%;height: -1%;">';
	    $html_component .= '</select>';
        $html_component .= '</div>';

    	return $html_component;

    }



    public function get_full_list_custom($order_by = "", $where = "", $check_dates = false, $show_deleted = 0)
    {
       
        global $current_user;

        if (isset($_SESSION['show_deleted'])) {
            $show_deleted = 1;
        }

        // In custom DISTINCT must be applied !
        $query = $this->create_new_list_query($order_by, $where, array(), array('distinct'=>true), $show_deleted);

        // Small Cleanup !
        $query = preg_replace('/[\']\s+[\']/', "''", $query);


        // TODO: Split properly the query between FROM & WHERE vs JOIN_Type
        // See https://sql.sh/cours/jointures
        // 
        // (...[tbl_name|field_key]) -> Make dynamic ! See /custom/modules/Users/ops_hoook_users_habilitations.php

        // We correct the related field used in our LEFT JOIN
        $query = preg_replace('/[\'][\']\s+ops_dispositif_id/', 'jt_dispdos.ops_dispositif_id  ops_dispositif_id', $query);



        // Adds the needed table used with our LEFT JOIN and clean a bit...
        $query = preg_replace('/\s+FROM\s+/', "\n FROM ops_dispositif_ops_dossier, ", $query);


        // Adds our LEFT JOIN appointment for table relations!
        $query = preg_replace('/\s+where\s+/', "\n LEFT JOIN ops_dispositif_ops_dossier jt_dispdos ON jt_dispdos.ops_dossier_id = ops_dossier.id AND jt_dispdos.deleted=0" ." WHERE " , $query);


        // Adds a WHERE clause complement...
        $query .= "\n";
        $query .= "AND ops_dispositif_ops_dossier.deleted=0 \n";


        $query .= "\n";

        // Retreive the sql trigger... and process the AND WHERE sql ending if not empty !
        $sql_trigger = $_SESSION['habilistations_rules']['sql_trigger'];
        if( !is_admin( $current_user ) ){

            $query .= "AND ( \n";
            $_xss_sql_ender = false;

            foreach ($_SESSION['habilistations_rules']['sql_rules'] as $rule_key => $rule_haystack) {
            
                $_xss_sql_ender = true;

                $query .=  $rule_key ." IN ( '' ";
                $query .= ( sizeof( array_filter( array_values($rule_haystack) ) ) > 0 ) ? ' , '  : '' ;
                $query .= implode( " , " , array_filter( array_values($rule_haystack) ) ) ;
                $query .=  " ) \n";

                $query .= "AND \n";

            }

            $query .= " ". ($_xss_sql_ender)? '1':'1'  ." \n";
            $query .= ") \n";

        }
        return parent::process_full_list_query($query, $check_dates);
    }



}
?>
