<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('include/Dashlets/DashletGeneric.php');
require_once('modules/OPS_dispositif/OPS_dispositif.php');

class AccesRapideDashlet extends DashletGeneric
{
    public function __construct($id, $def = null)
    {
        global $current_user, $app_strings;

        parent::__construct($id, $def);

        if (empty($def['title'])) {
            $this->title = translate('LBL_ACCES_RAPIDE_DASHLET', 'OPS_dispositif');
        }

        $this->seedBean = new OPS_dispositif();

        $obj_dispo = new OPS_dispositif();
        $dispositifs = $obj_dispo->getDispositifs();

        if($this->filters['dispositifs']) {
            foreach ($dispositifs as $id => $dispositif) {
                if(!in_array($id, $this->filters['dispositifs'])) {
                    unset($dispositifs[$id]);
                }
            }
        }
        $this->dispositifs = $dispositifs;

        $this->displayTpl = 'modules/OPS_dispositif/Dashlets/AccesRapideDashlet/AccesRapideDashlet.tpl';
    }

    function process($lvsParams = array(), $id = null)
	{
	}

    function display(){
        global $db, $beanFiles, $app_strings;

        $ss = new Sugar_Smarty();

        $url_complt = (!empty($_REQUEST["demandeur_id"]) && !empty($_REQUEST["demandeur_type"])) ? "&demandeur_id=" . $_REQUEST["demandeur_id"] . "&demandeur_type=" . $_REQUEST["demandeur_type"] : "";
        $url_complt .= (!empty($_REQUEST["famille_id"]) && !empty($_REQUEST["enfant_id"])) ? "&famille_id=".$_REQUEST["famille_id"]."&enfant_id=".$_REQUEST["enfant_id"] : "";
        $action = (!empty($_REQUEST["famille_id"]) && !empty($_REQUEST["enfant_id"])) ? "&action=create" : "&action=choix_demandeur";
        $url = $action . "&return_module=OPS_dossier&return_action=DetailView" . $url_complt;

        $ss->assign('url', $url);
        $ss->assign('dispositifs', $this->dispositifs);
        $str = $ss->fetch($this->displayTpl);
        
        return $str ;
    }
}
