<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('include/MVC/View/views/view.edit.php');

class OPS_dashletViewEdit extends ViewEdit
{
    public function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }

    public function display()
    {
        global $mod_strings, $app_list_strings;

        if ($this->bean->id) {
            $this->ss->assign("bean", $this->bean);

            // On décode les colonnes Filtres et Options des dashlets
            $filtres = unserialize(base64_decode($this->bean->filtres));
            $options = unserialize(base64_decode($this->bean->options));

            if (isset($options['myItemsOnly']) && $options['myItemsOnly'] == true) {
                $this->ss->assign('FILTRE_MY_ITEMS', $options['myItemsOnly']);
            }
        }

        // Récupération de la liste des colonnes affichées sur le Dashlet
        $liste_colonnes_affichees = array_filter(explode("\n", $this->bean->description));
        $this->ss->assign("LISTE_COLONNES_AFFICHEES", $liste_colonnes_affichees);

        $this->ss->assign("DESCRIPTION_DASHLET_VALEUR", $this->bean->description_dashlet);

        // Assignation des Libellés des champs du module
        $this->ss->assign("MOD_STRINGS", $mod_strings);

        $this->ss->assign("DASHLET_OBJETS_LISTE", $app_list_strings['dashlet_objet_list']);
        $this->ss->assign("DASHLET_MODELES_LISTE", $app_list_strings['dashlet_modele_list']);

        echo $this->ss->fetch("modules/OPS_dashlet/tpls/edit.tpl");

        // On va charger tout les TPLs des différents objets de dashlets disponibles et les filtres liés
        $controllers_files = array_diff(scandir('modules/OPS_dashlet/tpls/objets/'), ['..', '.']);
        foreach ($controllers_files as $file) {
            $file_name = 'modules/OPS_dashlet/tpls/objets/' . $file . '/edit.php';
            if (file_exists($file_name)) {
                // On va assigner les valeurs des filtres en fonction de l'objet concerné par le dashlet
                require_once($file_name);
                $class_name = $file . 'Edit';
                $edit_extend = new $class_name($this);
                $edit_extend->assignValeursFiltres($filtres);
            }

            if (file_exists("modules/OPS_dashlet/tpls/objets/" . $file . "/edit.tpl")) {
                echo $this->ss->fetch("modules/OPS_dashlet/tpls/objets/" . $file . "/edit.tpl");
            }
        }
    }
}
