<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('include/MVC/View/views/view.detail.php');

class OPS_dashletViewDetail extends ViewDetail
{
    public function __construct()
    {
        parent::__construct();
    }

    public function display()
    {
        global $mod_strings, $app_strings, $app_list_strings;

        if (empty($this->bean->id)) {
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }

        // Utilisé pour les boutons natifs de SuiteCRM
        parent::display();

        $this->ss->assign("bean", $this->bean);
        $this->ss->assign("record", $this->bean->id);

        // Récupération du texte descriptif du Dashlet
        $this->ss->assign("DESCRIPTION_DASHLET_VALEUR", $this->bean->description_dashlet);

        // Récupération de l'objet du Dashlet (OPS_dossier, Favorites, Tasks, ...)
        foreach ($app_list_strings['dashlet_objet_list'] as $key => $value) {
            if ($key == $this->bean->dashlet_objet) {
                $this->ss->assign("DASHLET_OBJET", $value);
            }
        }

        // Récupération du modèle du Dashlet (Mes dossiers, Mes favoris, ...)
        foreach ($app_list_strings['dashlet_modele_list'] as $key => $value) {
            if ($key == $this->bean->dashlet_modele) {
                $this->ss->assign("DASHLET_MODELE", $value);
            }
        }

        // On décode les colonnes Filtres et Options des dashlets
        $filtres = unserialize(base64_decode($this->bean->filtres));
        $options = unserialize(base64_decode($this->bean->options));

        if (isset($options['myItemsOnly'])) {
            $this->ss->assign("myItemsOnly", $options['myItemsOnly']);
        }

        if (file_exists('modules/OPS_dashlet/tpls/objets/' . $this->bean->dashlet_objet . '/detail.php')) {
            // On va assigner les valeurs des filtres en fonction de l'objet concerné par le dashlet
            require_once('modules/OPS_dashlet/tpls/objets/' . $this->bean->dashlet_objet . '/detail.php');
            $className = $this->bean->dashlet_objet . 'Detail';
            $detail_extend = new $className($this);
            $detail_extend->assignValeursFiltres($filtres);
        }

        // On récupère la liste des colonnes affichées dans le dashlet
        $liste_colonnes_affichees = array_filter(explode("\n", $this->bean->description));

        // On récupère la définition des champs du module OPS_dossier
        $bean = BeanFactory::newBean($this->bean->dashlet_objet);
        $field_defs = $bean->getFieldDefinitions();

        $array_liste_colonnes = array();
        for ($i = 0; $i < count($liste_colonnes_affichees); $i++) {
            foreach ($field_defs as $name => $value) {
                if ($name == $liste_colonnes_affichees[$i]) {
                    $display_label = translate($value['vname'], $this->bean->dashlet_objet);
                    $array_liste_colonnes[$name] = str_replace(' :', '', $display_label);
                }
            }
        }
        $this->ss->assign('LISTE_COLONNES_AFFICHEES', $array_liste_colonnes);

        $this->ss->assign("DASHLET_COLONNES", $array_dashlet_previsu);

        $this->ss->assign("MOD_STRINGS", $mod_strings);

        // On récupère la vue "Filtre" reliée au type d'objet paramétré sur le Dashlet
        if (file_exists("modules/OPS_dashlet/tpls/objets/" . $this->bean->dashlet_objet . "/detail.tpl")) {
            echo $this->ss->fetch("modules/OPS_dashlet/tpls/objets/" . $this->bean->dashlet_objet . "/detail.tpl");
        }

        echo $this->ss->fetch("modules/OPS_dashlet/tpls/detail.tpl");
    }
}
