<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.edit.php');

/**
 * Classe appelée par le view.edit.php du module Dashlet permettant la récupération d'informations liés à l'objet "OPS_justificatif"
 */
class OPS_dispositifEdit
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres = array())
    {
        $liste_dispositifs = array();

        // Filtre sur les dispositifs à afficher
        $obj_dispo = new OPS_dispositif();
        $dispositifs = $obj_dispo->getDispositifs();

        foreach ($dispositifs as $key => $dispositif) {
            $liste_dispositifs[$key] = $dispositif['name'];
        }
        asort($liste_dispositifs);
        $this->ss->assign('DASHLET_DISPOSITIF_FILTRES_DISPOSITIF', $liste_dispositifs);

        $this->ss->assign('FILTRE_DISPOSITIF_DISPOSITIF', $filtres['dispositifs']);

    }
}