<?php

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;

class OPS_conversation extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_conversation';
    public $object_name = 'OPS_conversation';
    public $table_name = 'ops_conversation';
    public $importable = false;

    public $id;
    public $name;
    public $deleted;
    public $description;

    public $date_entered;
    public $date_modified;

    public $modified_user_id;
    public $modified_by_name;

    public $created_by;
    public $created_by_name;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;

    public $SecurityGroups;
	
    public function bean_implements($interface)
    {

        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }


    /**
     * @method fetchConversationState
     * Récupère l'état d'une conversation du dossier (module).
     * 
     * @param $id, <UUID:36> Identifiant du module conversation
     * @param $module, <String> Module name
     * 
     * @return <Array>
     * Retourne un tableau associatif (id, clé du statut, label du statut)
     */
    public function fetchConversationState($id, $module = 'OPS_dossier')
    {

        global $app_list_strings;

        $data = false;

        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id, $output_array);

        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
        
            $obj_parent = BeanFactory::getBean( $module , $id );

            if( empty($obj_parent) || $obj_parent == false || $obj_parent == null || !isset($obj_parent->id) ){
                return $data;
            }

            // L'état de la conversation peut être de 2 états (ouverte,fermee) - par défaut [fermee].
            $conversation_statut = 'fermee';

            if( !isset($obj_parent->conversation_statut) || $obj_parent->conversation_statut == "" ){
                $obj_parent->conversation_statut = 'fermee';
                $obj_parent->save();
            }else{
                $conversation_statut = $obj_parent->conversation_statut;
            }


            $conversation_label = $app_list_strings['conversation_statut_list'][ $conversation_statut ];

            // Retour Controller|API
            $data = array(
                'id' => $obj_parent->id,
                'conversation_statut' => $conversation_statut,
                'conversation_label'  => $conversation_label,
            );

        }
        return $data;

    }    
	

    /**
     * @method setConversationState
     * Défini l'état d'une conversation du dossier (module)
     * 
     * @param $id, <UUID:36> Identifiant du module conversation
     * @param $module, <String> Module name
     * @param $conversation_statut, <String:key> - Clé du statut de la conversation (ouverte|fermee)
     * 
     * @return <Array>
     * Retourne un tableau associatif (id, clé du statut, label du statut, clé d'origine du dernier message)
     */
    public function setConversationState($id, $module = 'OPS_dossier', $conversation_statut = 'fermee')
    {
        global $app_list_strings;

        $data = false;

        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id, $output_array);

        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

            $obj_parent = BeanFactory::getBean( $module , $id );

            if( !isset($app_list_strings['conversation_statut_list'][ $conversation_statut ]) 
            ){
                $obj_parent->conversation_statut = 'fermee';
            }else{
                $obj_parent->conversation_statut = $conversation_statut;
            }

            $obj_parent->save();

            $conversation_label = $app_list_strings['conversation_statut_list'][ $obj_parent->conversation_statut ];

            // Retour Controller|API
            $data = array(
                'id' => $obj_parent->id,
                'conversation_statut' => $obj_parent->conversation_statut,
                'conversation_label'  => $conversation_label,
                'conversation_origin' => $obj_parent->conversation_origin,
            );


        }
        return $data;

    }    
    

    /**
     * @method setConversationOrigin
     * Défini l'origine d'une conversation du dossier (module)
     * 
     * @param $id, <UUID:36>
     * @param $module, <String> Module name
     * @param $conversation_origin, <String:key> - Clé de l'origine de la conversation (agent|usager)
     * 
     * @return <Array>
     * Retourne un tableau associatif (id, clé du statut, label du statut, clé d'origine du dernier message)
     */
    public function setConversationOrigin($id, $module = 'OPS_dossier', $conversation_origin = 'agent')
    {
        global $app_list_strings;

        $data = false;

        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id, $output_array);

        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

            $obj_parent = BeanFactory::getBean( $module , $id );

            if( !isset($app_list_strings['conversation_origin_list'][ $conversation_origin ]) 
            ){
                $obj_parent->conversation_origin = 'agent';
            }else{
                $obj_parent->conversation_origin = $conversation_origin;
            }

            $obj_parent->save();

            $conversation_label = $app_list_strings['conversation_statut_list'][ $obj_parent->conversation_statut ];

            // Retour Controller|API
            $data = array(
                'id' => $obj_parent->id,
                'conversation_statut' => $obj_parent->conversation_statut,
                'conversation_label'  => $conversation_label,
                'conversation_origin' => $obj_parent->conversation_origin,
            );


        }
        return $data;

    }    
    

    /**
     * @method addMessage
     * Ajoute un message à la conversation identifiée par l'id (parent_id) et le module (parent_type)
     * 
     * @param $parent_id, <UUID:36> Identifiant du module conversation
     * @param $parent_type, <String> Module name
     * @param $b64_message, <String:Base64> - Encode Base64 du message à ajouter
     * @param $objAuthor, <Object> - Informations prédéterminées de l'auteur qui poste le message :
     * 
     * <Object:objAuthor>
     *  objAuthor.prenom - <String> Prénom de l'auteur du message.
     *  objAuthor.nom - <String> Nom de l'auteur du message.
     *  objAuthor.source_id - <UUID:36> UUID de l'auteur du message.
     *  objAuthor.origin - <String:key> Clé d'rigine de l'auteur du message (agent|usager).
     * 
     * @return <Array>
     * Retourne un tableau associatif (id, clé du statut, label du statut, clé d'origine du dernier message)
     */
    public function addMessage($parent_id, $parent_type, $b64_message, $objAuthor)
    {

        global $app_list_strings;

        // Use Configurator to fetch identity paramerters.
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        $data = false;

        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $parent_id, $output_array);

        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
        
            $bean_name = 'OPS_conversation';
            $Message = BeanFactory::newBean($bean_name);

            $Message->message     = $b64_message;

            $Message->parent_type = $parent_type;
            $Message->parent_id   = $parent_id;

            $Message->statut      = 'nouveau'; // Flag le message nouveau.

            $now = DateTime::createFromFormat('U.u', number_format(microtime(true), 3, '.', ''));
            $now->setTimeZone(new DateTimeZone('Europe/Berlin'));
            $Message->stamp       = $now->format("YmdHisu");


            // Information de provenance et d'identité de l'auteur du message.
            $Message->prenom      = $objAuthor->prenom;
            $Message->nom         = $objAuthor->nom;

            $Message->source_id   = $objAuthor->source_id;
            $Message->origin      = $objAuthor->origin;


            $Message->save();


            // Déclare l'identité à utiliser dans chaque message Agent.
            $sender_custom_replacement = false;
            $sender_custom_identity = 'Nous';
            if( isset( $configuratorObj->config['module_conversation']['enable_custom'] )
             && intval( $configuratorObj->config['module_conversation']['enable_custom'] ) === 1 
            ){
                $sender_custom_replacement = true;
                $sender_custom_identity = ( trim( $configuratorObj->config['module_conversation']['custom_exp_identity'] ) !== '')? $configuratorObj->config['module_conversation']['custom_exp_identity'] : $sender_custom_identity;
            }


            if( $Message->origin == 'agent' ){
                $obj_user = BeanFactory::getBean( 'Users' , $Message->source_id );
                $sender_identity = ($sender_custom_replacement)? $sender_custom_identity : trim( join( ' ', [$obj_user->first_name , $obj_user->last_name] ) );
            }else{
                $obj_individu = BeanFactory::getBean( 'OPS_individu' , $Message->source_id );
                $sender_identity = trim( join( ' ', [$obj_individu->salutation , $obj_individu->first_name , $obj_individu->last_name] ) );
              //$sender_identity = trim( $obj_individu->full_name );
            }


            // Retour Controller|API
            $data = array(
                'message_id'     => $Message->id,
                'message_statut' => $Message->statut,
                'message_label'  => $app_list_strings['message_statut_list']['nouveau'],
                'message_origin' => $Message->origin,
                'message_stamp'  => $Message->stamp,
                'message_sender' => $sender_identity,
            );


            // On défini au niveau du module principal OPS_dossier (ou autre) l'origine du message.
            $obj_parent = BeanFactory::getBean( $parent_type , $parent_id );
            $obj_parent->conversation_origin = $Message->origin; // Fixe la provenance de ce dernier message (agent|usager)

            $obj_parent->save();


            // On peut potentiellement notifier par mail l'usager de l'arrivée d'un nouveau message.
            if( $Message->origin === 'agent'
             && isset( $configuratorObj->config['opensocle']['notif_usager_dossier_nouveau_msg_conversation'] )
             && !empty( $configuratorObj->config['opensocle']['notif_usager_dossier_nouveau_msg_conversation'] )
            ){

                $objDemandeur = BeanFactory::getBean('OPS_individu',$obj_parent->ops_individu_id);

                try {
                    
                    $mailer = new OdeMailer();
                    $ode_email = new OdeEmail([
                        'bean_source_id' => $obj_parent->id,
                        'bean_source_name' => 'OPS_dossier',
                        'bean_historisation_id' => $objDemandeur->id,
                        'bean_historisation_name' => 'OPS_individu',
                        'email_template_id' => $configuratorObj->config['opensocle']['notif_usager_dossier_nouveau_msg_conversation'],
                        'dest_to' => $objDemandeur->email1,
                        'dest_cc' => '',
                        'dest_cci ' => '',
                        'genere_dossier_pdf' => false,
                    ]);

                    $result = $mailer->send($ode_email);

                } catch (Exception $e) {}

            }



        }

        return $data;
    }
    

    /**
     * @method fetchMessages
     * Récupère l'ensemble des message d'une conversation du dossier (module) identifiée par l'id (parent_id) et le module (parent_type)
     * 
     * @param $parent_id, <UUID:36> Identifiant du module conversation
     * @param $parent_type, <String> Module name
     * 
     * @return <Array>
     * Retourne un tableau d'objet Tuples associatif des messages (agent & usager).
     */
    public function fetchMessages($parent_id, $parent_type)
    {

        global $app_list_strings;
        global $db;

        // Use Configurator to fetch identity paramerters.
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        $data = false;

        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $parent_id, $output_array);

        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
        
            $bean_name = 'OPS_conversation';

            // Déclare l'identité à utiliser dans chaque message Agent.
            $sender_custom_replacement = false;
            $sender_custom_identity = 'Nous';
            if( isset( $configuratorObj->config['module_conversation']['enable_custom'] )
             && intval( $configuratorObj->config['module_conversation']['enable_custom'] ) === 1 
            ){
                $sender_custom_replacement = true;
                $sender_custom_identity = ( trim( $configuratorObj->config['module_conversation']['custom_exp_identity'] ) !== '')? $configuratorObj->config['module_conversation']['custom_exp_identity'] : $sender_custom_identity;
            }

            $messages = array();

            $sql = "SELECT `id`, `description`, `message`, `parent_type`, `parent_id`, `statut`, `stamp`, `prenom`, `nom`, `source_id`, `origin` ";
            $sql.= "FROM `". strtolower($bean_name) ."` ";
            $sql.= "WHERE `parent_type` = '" . $parent_type . "' AND `parent_id` = '" . $parent_id . "' AND `deleted` = '0' ";
            $sql.= "ORDER BY `stamp` ASC"; // Le format du stamp permet de trier précisément.

            try {
                
                $result = $db->query($sql);
                while ($row = $db->fetchByAssoc($result)) {
                    $Message = (object) $row;

                    if( $Message->origin == 'agent' ){
                        $obj_user = BeanFactory::getBean( 'Users' , $Message->source_id );
                        $sender_identity = ($sender_custom_replacement)? $sender_custom_identity : trim( join( ' ', [$obj_user->first_name , $obj_user->last_name] ) );
                    }else{
                        $obj_individu = BeanFactory::getBean( 'OPS_individu' , $Message->source_id );
                        $sender_identity = trim( join( ' ', [$obj_individu->salutation , $obj_individu->first_name , $obj_individu->last_name] ) );
                      //$sender_identity = trim( $obj_individu->full_name );
                    }

                    $Message->sender = $sender_identity;
                    $messages[] = $Message;
                }

            } catch (Exception $e) {}

            // Retour Controller|API
            $data = $messages;

        }

        return $data;

    }
    

    /**
     * @method setMessageStatut
     * Défini le statut d'un message (nouveau|lu) appartenant à une conversation identifiée par l'id (parent_id) et le module (parent_type) 
     * 
     * @param $parent_id, <UUID:36> Identifiant du module conversation
     * @param $parent_type, <String> Module name
     * @param $message_id, <UUID:36> Identifiant du message
     * @param $message_id, <String:clé> Clé du statut du message (nouveau|lu)
     * 
     * @return <Array>
     * Retourne un tableau associatif des caractéristiques du message.
     */
    public function setMessageStatut($parent_id, $parent_type, $message_id, $message_statut)
    {

        global $app_list_strings;

        // Use Configurator to fetch identity paramerters.
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        $data = false;


        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $message_id, $output_array);

        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
        
            $bean_name = 'OPS_conversation';
            $Message = BeanFactory::getBean( $bean_name , $message_id );

            if( $Message && $Message->id === $message_id && $Message->parent_type === $parent_type && $Message->parent_id === $parent_id){

                if( !isset($app_list_strings['message_statut_list'][ $message_statut ]) 
                ){
                    $Message->statut = 'nouveau';
                }else{
                    $Message->statut = $message_statut;
                }

            }

            $Message->save();

            // Déclare l'identité à utiliser dans chaque message Agent.
            $sender_custom_replacement = false;
            $sender_custom_identity = 'Nous';
            if( isset( $configuratorObj->config['module_conversation']['enable_custom'] )
             && intval( $configuratorObj->config['module_conversation']['enable_custom'] ) === 1 
            ){
                $sender_custom_replacement = true;
                $sender_custom_identity = ( trim( $configuratorObj->config['module_conversation']['custom_exp_identity'] ) !== '')? $configuratorObj->config['module_conversation']['custom_exp_identity'] : $sender_custom_identity;
            }


            // Retour Controller|API
            $data = array(
                'message_id'     => $Message->id,
                'message_statut' => $Message->statut,
                'message_label'  => $app_list_strings['message_statut_list'][ $Message->statut ],
                'message_origin' => $Message->origin,
                'message_stamp'  => $Message->stamp,
                'message_sender' => ($Message->origin == 'agent' && $sender_custom_replacement )? $sender_custom_identity : trim($Message->prenom .' '.$Message->nom),
            );

        }

        return $data;

    }
    

    /**
     * @method getLastMessage
     * Récupère le dernier message de la vonversation identifiée par l'id (parent_id) et le module (parent_type)
     * 
     * @param $parent_id, <UUID:36> Identifiant du module conversation
     * @param $parent_type, <String> Module name
     * 
     * @return <Array>
     * Retourne un tableau associatif des caractéristiques du message.
     */
    public function getLastMessage($parent_id, $parent_type)
    {

        global $app_list_strings;

        $data = false;

        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $message_id, $output_array);

        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
        
            $bean_name = 'OPS_conversation';

            // Déclare l'identité à utiliser dans chaque message Agent.
            $sender_custom_replacement = false;
            $sender_custom_identity = 'Nous';
            if( isset( $configuratorObj->config['module_conversation']['enable_custom'] )
             && intval( $configuratorObj->config['module_conversation']['enable_custom'] ) === 1 
            ){
                $sender_custom_replacement = true;
                $sender_custom_identity = ( trim( $configuratorObj->config['module_conversation']['custom_exp_identity'] ) !== '')? $configuratorObj->config['module_conversation']['custom_exp_identity'] : $sender_custom_identity;
            }

            $message = array();

            $sql = "SELECT `id`, `description`, `message`, `parent_type`, `parent_id`, `statut`, `stamp`, `prenom`, `nom`, `source_id`, `origin` ";
            $sql.= "FROM `". strtolower($bean_name) ."` ";
            $sql.= "WHERE `parent_type` = '" . $parent_type . "' AND `parent_id` = '" . $parent_id . "' AND `deleted` = '0' ";
            $sql.= "ORDER BY `stamp` DESC LIMIT 1"; // Le format du stamp permet de trier précisément.

            try {
                
                $result = $db->query($sql);
                while ($row = $db->fetchByAssoc($result)) {
                    $Message = (object) $row;
                    $Message->sender = ($Message->origin == 'agent' && $sender_custom_replacement )? $sender_custom_identity : trim($Message->prenom .' '.$Message->nom);
                    $message[] = $Message;
                }

            } catch (Exception $e) {}

            // Retour Controller|API
            $data = $message;

        }

        // Retour Controller|API
        return $data;

    }
    

    /**
     * @method get_inline_js
     * Récupère le bloc de script Javascript permettant la changement d'état de champs selon l'état de la checkbox d'activation identité.
     * 
     * @return <String>
     * Retourne le bloc de script Javascript.
     */
    static function get_inline_js(){
$inline_js = <<<ADMIN_INLINE_SCRIPT
<script type="text/javascript" language="JavaScript">
$(document).ready(function () {
  $('input[name="enable_custom"]').off().on('change', change_checkbox_state );
  void $('input[name="enable_custom"]').trigger('change');
});

var change_checkbox_state = function(e,n) {
    let checked = $(e.target).is(':checked');
    if( checked ){
        $('#custom_exp_identity').removeAttr('disabled').prop('disabled',false);
    }else{
        $('#custom_exp_identity').attr('disabled','disabled').prop('disabled',true);
    }
}
</script>
ADMIN_INLINE_SCRIPT;
        return $inline_js;
    }
}