var jquery = jQuery.noConflict();

jquery(document).ready(function () {

    // PART RADIO BUTTON CREATION

    var labelArea = jquery('#calendar').closest('.edit-view-row-item').find('> .label');

    var buttonArea = '<div class="row align-items-center"><div class="col">';

    if( jquery('#famille_1').length && jquery('#famille_1').val() != '' )
    {
        var familyButton1 = '<div class="famille famille-1">';
        familyButton1 += '<label for="famille_1_select" class="famille-checked">' + jquery('#famille_1_name').val() + '</label>';
        familyButton1 += '<input type="radio" name="select_famille" id="famille_1_select" value="' + jquery('#famille_1').val() + '" checked>';
        familyButton1 += '</div>';

        buttonArea += familyButton1;
    }

    if( jquery('#famille_2').length && jquery('#famille_2').val() != '' )
    {
        var familyButton2 = '<div class="famille famille-2">';

        if( jquery('#famille_1').length && jquery('#famille_1').val() != '' )
        {
            familyButton2 += '<label for="famille_2_select">' + jquery('#famille_2_name').val() + '</label>';
            familyButton2 += '<input type="radio" name="select_famille" id="famille_2_select" value="' + jquery('#famille_2').val() + '">';
        }
        else
        {
            familyButton2 += '<label for="famille_2_select" class="famille-checked">' + jquery('#famille_2_name').val() + '</label>';
            familyButton2 += '<input type="radio" name="select_famille" id="famille_2_select" value="' + jquery('#famille_2').val() + '" checked>';
        }
        familyButton2 += '</div>';

        buttonArea += familyButton2;
    }

    buttonArea += '</div></div>';

    labelArea.append(buttonArea);

    jquery('#famille_1').remove();
    jquery('#famille_2').remove();
    jquery('#famille_1_name').remove();
    jquery('#famille_2_name').remove();

    // END PART RADIO BUTTON CREATION

    // PART CALENDAR

    //Build Json with all events
    var familyEventList = getEventDecode('event_list');
    var eventList = getEventList(familyEventList);

    if ( jquery('#famille_1_select').length && !(jquery('#famille_1_select').val() in familyEventList) )
    {
        familyEventList[jquery('#famille_1_select').val()] = [];
    }

    if ( jquery('#famille_2_select').length && !(jquery('#famille_2_select').val() in familyEventList) )
    {
        familyEventList[jquery('#famille_2_select').val()] = [];
    }
    

    if( jquery("input[name=select_famille]:checked").length )
    {
        var idSelected = jquery("input[name=select_famille]:checked").attr('id');
        var familyId = jquery("input[name=select_famille]:checked").val();
        var familyLabel = jquery("label[for='" + idSelected + "']").text();
        var familyColor = jquery('#' + idSelected.replace('_select', '') + '_couleur').val();
    }

    jquery( "input[name=select_famille]" ).change(function() {
          familyId = jquery(this).val();
          familyLabel = jquery("label[for='" + jquery(this).attr('id') + "']").text();
          
          jquery('.famille-checked').each(function(){
                jquery(this).removeClass('famille-checked');
          });

          jquery("label[for='" + jquery(this).attr('id') + "']").addClass('famille-checked');


          familyColor = jquery('#' + jquery(this).attr('id').replace('_select', '') + '_couleur').val();
    });

    // Get the current day
    var today = getFormattedDate(new Date());

    jquery('#calendar').fullCalendar({
		locale: 'fr',
		defaultView: 'agendaWeek',
		slotDuration: '00:30:00',
		slotLabelInterval: "01:00",
		slotLabelFormat: 'HH:mm',
		height: 700,
		aspectRatio: 15,
		timeFormat: 'HH:mm',
		allDaySlot: false,
        selectable: true,
		weekends: true, 
		views: {
			month: {
				buttonText: "Mois",
				eventLimit: 5,
			},
			calendarWeek: {
				buttonText: "Semaine",
				eventLimit: 6,
			},
			agendaDay: {
				buttonText: "Jour",
			},
		},
        header: {
			left: 'prev,next',
			center: 'title',
			right: 'month,agendaWeek,agendaDay',
		},

        events: eventList,

        eventClick: function(calEvent, jsEvent, view)
        {
            if( familyId !== undefined)
            {
                let event = getEvent(calEvent.id);

                var eventDay = calEvent.id;

                removeEvent(eventDay);

                if (event.groupId != familyId)
                {
                    createEvent(familyId, familyLabel, eventDay, familyColor)
                }
            }
        },

        /*
        dateClick: function(info) 
        {
            if (familyId !== undefined)
            {
                var eventDay = getFormattedDate(info.date)

                removeEvent(eventDay);

                createEvent(familyId, familyLabel, eventDay, familyColor);
            }
        },
        */
       
        select: function(startDate, endDate)
        {
            view = jQuery('#calendar').fullCalendar('getView').name;
            if (familyId !== undefined)
            {
                let startStr = getFormattedDate(startDate._d);
                let currentDayStr = getFormattedDate(startDate._d);
                let endStr = getFormattedDate(endDate._d);

                let currentDay = startDate._d;

                while( (view == 'month' && currentDayStr < endStr ) || (view != 'month' && currentDayStr <= endStr ) )
                {
                    let event_calendar = getEvent( currentDayStr );

                    removeEvent(currentDayStr);

                    if (event_calendar === undefined || event_calendar === null || event_calendar.groupId != familyId)
                    {
                        createEvent(familyId, familyLabel, currentDayStr, familyColor);
                    }

                    currentDay = addDays(currentDay, 1);
                    currentDayStr = getFormattedDate(currentDay);
                }
            }
        },
    });

    function getEventDecode(inputId)
    {
        var familyEventListDecode = {};
        if ( jquery('#' + inputId).length && jquery('#' + inputId).val() != '')
        {
            familyEventListDecode = JSON.parse( atob( jquery('#' + inputId).val() ) );
        }  
        return familyEventListDecode;
    }

    function getEventList(familyEventList)
    {
        var eventList = [];
        for (family in familyEventList)
        {
            if( family != '' && jquery('input[value=' + family  + ']').length )
            {
                var familyId = jquery('input[value=' + family  + ']').attr('id');
                var familyLabel = jquery('label[for="' + familyId + '"]').text();
                var familyColor = jquery('#' + familyId.replace('_select', '') + '_couleur').val();

                for (eventKey in familyEventList[family])
                {
                    eventDay = familyEventList[family][eventKey];
                    eventList.push({
                        id: eventDay,
                        groupId: family,
                        title: familyLabel,
                        start: eventDay + 'T00:00',
                        end: eventDay + 'T23:59',
                        color: 'white',
                        display: 'block',
                        backgroundColor: familyColor,
                    });     
                }
            }
        }
        return eventList;
    }

    function createEvent(familyId, familyLabel, eventDay, familyColor)
    {
        familyEventList[familyId].push(eventDay);

        addEvent(
            {
                id: eventDay,
                groupId: familyId,
                title: familyLabel,
                start: eventDay + 'T00:00',
                end: eventDay + 'T23:50',
                color: 'white',
                display: 'block',
                backgroundColor: familyColor,
            },
        );
        saveEventList(familyEventList);
    }

    function removeEvent(eventDay)
    {
        for (key in familyEventList)
        {
            var index = familyEventList[key].indexOf(eventDay);
            if (index > -1) 
            {
                familyEventList[key].splice(index, 1);
                let event = getEvent( eventDay );

                jQuery('#calendar').fullCalendar('removeEvents', event._id);
            }
        }
        saveEventList(familyEventList);
    }

    function replaceEvent(newEventId, newEventLabel)
    {
        for(key in familyEventList[ jquery('#famille_2_select').val() ])
        {
            let event = getEvent(familyEventList[ jquery('#famille_2_select').val() ][key] );
            jQuery('#calendar').fullCalendar('removeEvents', event._id);
            calendar.addEvent(
                {
                    id: event.id,
                    groupId: newEventId,
                    title: newEventLabel,
                    start: event.start,
                    end: event.end,
                    color: 'white',
                    display: 'block',
                    backgroundColor: event.backgroundColor,
                },
            );
        }
    }

    function getEvent(id)
    {
        let events = jQuery('#calendar').fullCalendar('clientEvents');

        // Parcourez les événements pour trouver celui avec l'ID spécifique
        let event = events.find(function(event) {
            return event.id === id;
        });

        return event;
    }
    
    function addEvent(event)
    {
        jQuery('#calendar').fullCalendar('renderEvent', event, true); 
    }

    /**
     * Add days in the date object
     *
     * @param { Object Date } date
     * @param { Integer } days
     *
     * @return { Object Date }
     */
    function addDays(date, days) 
    {
        date.setDate(date.getDate() + days);
        return date;
    }

    function getFormattedDate(date)
    {
        var month = date.getMonth() + 1;
        var day = date.getDate();

        return date.getFullYear() + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;
    }

    function saveEventList(eventList)
    {
        if( jquery('#event_list').length )
        {
            var eventListEncode = btoa(JSON.stringify(eventList)); 
            jquery('#event_list').val(eventListEncode);
        }
    }
});