<?php

$manifest = array(
    0 => array(
        'acceptable_sugar_versions' => array(
            0 => ''
        )
    ),
    1 => array(
        'acceptable_sugar_flavors' => array(
            0 => 'CE',
            1 => 'PRO',
            2 => 'ENT'
        )
    ),
    'readme' => '',
    'key' => 'OPS',
    'author' => 'Lanteas',
    'description' => 'Gestion des subventions par Lanteas',
    'icon' => '',
    'is_uninstallable' => true,
    'name' => 'Module Subventions',
    'published_date' => '2024-06-20 16:00:00',
    'type' => 'module',
    'version' => '3.0 BETA 1',
    'remove_tables' => 'false'
);

$installdefs = array(
    'id' => 'opensub',
    
    'post_execute' => array(
        0 => '<basepath>/scripts/post_execute.php'
    ),
    
    'logic_hooks' => array(
        
        ///////////////// HOOKS CLEANUP /////////////////      
        // Hook suppression des détails journal before_delete journal
        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des objets liés à subvention - [OPS_dossier]',
            'file' => 'custom/modules/OPS_dossier/hook_subvention.php',
            'class' => 'hook_subvention',
            'function' => 'delete_related_relations'
        )
    ),
    
    'beans' => array(
        
        array(
            'module' => 'OPS_engagement',
            'class' => 'OPS_engagement',
            'path' => 'modules/OPS_engagement/OPS_engagement.php',
            'tab' => true
        ),
        
        array(
            'module' => 'OPS_exercice',
            'class' => 'OPS_exercice',
            'path' => 'modules/OPS_exercice/OPS_exercice.php',
            'tab' => true
        ),
        
        array(
            'module' => 'OPS_liquidation',
            'class' => 'OPS_liquidation',
            'path' => 'modules/OPS_liquidation/OPS_liquidation.php',
            'tab' => true
        ),
        
        array(
            'module' => 'OPS_piece',
            'class' => 'OPS_piece',
            'path' => 'modules/OPS_piece/OPS_piece.php',
            'tab' => true
        ),
        
        
        array(
            'module' => 'OPS_tranche',
            'class' => 'OPS_tranche',
            'path' => 'modules/OPS_tranche/OPS_tranche.php',
            'tab' => true
        ),
        
        array(
            'module' => 'OPS_banque',
            'class' => 'OPS_banque',
            'path' => 'modules/OPS_banque/OPS_banque.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_campagne',
            'class' => 'OPS_campagne',
            'path' => 'modules/OPS_campagne/OPS_campagne.php',
            'tab' => true
        )
        
    ),
    
    'copy' => array(
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_dossier',
            'to' => 'modules/OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_engagement',
            'to' => 'modules/OPS_engagement'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_exercice',
            'to' => 'modules/OPS_exercice'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_liquidation',
            'to' => 'modules/OPS_liquidation'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_piece',
            'to' => 'modules/OPS_piece'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_tranche',
            'to' => 'modules/OPS_tranche'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_banque',
            'to' => 'modules/OPS_banque'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_campagne',
            'to' => 'modules/OPS_campagne'
        ),
        array(
            'from' => '<basepath>/custom/modules/OPS_generateur_vue/',
            'to' => 'modules/OPS_generateur_vue/'
        ),
        array(
            'from' => '<basepath>/custom/modules/',
            'to' => 'custom/modules/'
        ),
        array(
            'from' => '<basepath>/custom/include/generic/',
            'to' => 'custom/include/generic/',
        ),
        array(
            'from' => '<basepath>/custom/include/Ode/CustomBlock/',
            'to' => 'custom/include/Ode/CustomBlock/',
        ),
        array(
            'from' => '<basepath>/custom/Extension/modules/',
            'to' => 'custom/Extension/modules/'
        ),
        array(
            'from' => '<basepath>/custom/include/Ode/ActionStatut/Action/CreationDominiciliationBancaireAction.php',
            'to' => 'custom/include/Ode/ActionStatut/Action/CreationDominiciliationBancaireAction.php'
        ),

    ),
    
    'layoutdefs' => array(
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_ops_dossier_paiement_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_liquidation_documents_OPS_liquidation.php',
            'to_module' => 'OPS_liquidation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_campagne_documents_OPS_campagne.php',
            'to_module' => 'OPS_campagne'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_engagement_documents_OPS_engagement.php',
            'to_module' => 'OPS_engagement'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_engagement_ops_liquidation_OPS_engagement.php',
            'to_module' => 'OPS_engagement'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_engagement_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dispositif_ops_piece_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_tranche_ops_dossier_OPS_tranche.php',
            'to_module' => 'OPS_tranche'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_tranche_ops_exercice_OPS_exercice.php',
            'to_module' => 'OPS_exercice'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_domiciliation_ops_banque_OPS_banque.php',
            'to_module' => 'OPS_banque'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_campagne_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_campagne_ops_dossier_OPS_campagne.php',
            'to_module' => 'OPS_campagne'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_campagne_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        )
        
    ),
    
    'relationships' => array(
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_campagne_documentsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_engagement_documentsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_liquidation_documentsMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_engagement_ops_liquidationMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_engagement_ops_dossierMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dispositif_ops_pieceMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_tranche_ops_dossierMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_tranche_ops_exerciceMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_domiciliation_ops_banqueMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_campagne_ops_dossierMetaData.php'
        ),
        
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_campagne_ops_dispositifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_ops_dossier_paiementMetaData.php'
        )
    ),
    
    'image_dir' => '<basepath>/icons',
    
    'language' => array(
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dossier.php',
            'to_module' => 'OPS_dossier',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/Documents.php',
            'to_module' => 'Documents',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_liquidation.php',
            'to_module' => 'OPS_liquidation',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_liquidation.php',
            'to_module' => 'OPS_liquidation',
            'language' => 'fr_FR'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_engagement.php',
            'to_module' => 'OPS_engagement',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_engagement.php',
            'to_module' => 'OPS_engagement',
            'language' => 'fr_FR'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_exercice.php',
            'to_module' => 'OPS_exercice',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_exercice.php',
            'to_module' => 'OPS_exercice',
            'language' => 'fr_FR'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/language/application/en_us.lang.php',
            'to_module' => 'application',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/language/application/fr_FR.lang.php',
            'to_module' => 'application',
            'language' => 'fr_FR'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_tranche.php',
            'to_module' => 'OPS_tranche',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_tranche.php',
            'to_module' => 'OPS_tranche',
            'language' => 'fr_FR'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_piece.php',
            'to_module' => 'OPS_piece',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_piece.php',
            'to_module' => 'OPS_piece',
            'language' => 'fr_FR'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation',
            'language' => 'fr_FR'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_banque.php',
            'to_module' => 'OPS_banque',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_banque.php',
            'to_module' => 'OPS_banque',
            'language' => 'fr_FR'
        ),
        
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_campagne.php',
            'to_module' => 'OPS_campagne',
            'language' => 'en_us'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_campagne.php',
            'to_module' => 'OPS_campagne',
            'language' => 'fr_FR'
        )
        
    ),
    
    'vardefs' => array(
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_liquidation_documents_Documents.php',
            'to_module' => 'Documents'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_liquidation_documents_OPS_liquidation.php',
            'to_module' => 'OPS_liquidation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_engagement_documents_Documents.php',
            'to_module' => 'Documents'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_engagement_documents_OPS_engagement.php',
            'to_module' => 'OPS_engagement'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_campagne_documents_Documents.php',
            'to_module' => 'Documents'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_campagne_documents_OPS_campagne.php',
            'to_module' => 'OPS_campagne'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_engagement_ops_liquidation_OPS_liquidation.php',
            'to_module' => 'OPS_liquidation'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_engagement_ops_liquidation_OPS_engagement.php',
            'to_module' => 'OPS_engagement'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_engagement_ops_dossier_OPS_engagement.php',
            'to_module' => 'OPS_engagement'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_engagement_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dispositif_ops_piece_OPS_piece.php',
            'to_module' => 'OPS_piece'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dispositif_ops_piece_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_tranche_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_tranche_ops_dossier_OPS_tranche.php',
            'to_module' => 'OPS_tranche'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_tranche_ops_exercice_OPS_tranche.php',
            'to_module' => 'OPS_tranche'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_tranche_ops_exercice_OPS_exercice.php',
            'to_module' => 'OPS_exercice'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_domiciliation_ops_banque_OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_domiciliation_ops_banque_OPS_banque.php',
            'to_module' => 'OPS_banque'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_campagne_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_campagne_ops_dossier_OPS_campagne.php',
            'to_module' => 'OPS_campagne'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_campagne_ops_dispositif_OPS_campagne.php',
            'to_module' => 'OPS_campagne'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_campagne_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_dossier_paiementOPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_dossier_paiementOPS_dossier1.php',
            'to_module' => 'OPS_dossier'
        )
    )
);