<?php
class Indicateur_MtEngageViewUtils {

    private $smarty;
    private $template;
    private $type = "relation";


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/TuileSimple.tpl";

    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);

    }

    private function setData(){
        global $db, $sugar_config;
        $montant = number_format(($_GET['totaux_montant']["montant_total_engage"] ?? 0), 2, $sugar_config['default_decimal_seperator'],$sugar_config['default_number_grouping_seperator'] );

        $this->smarty->assign("TITRE", "Mt engagé");
        $this->smarty->assign("VALEUR", $montant . " " .  $sugar_config['default_currency_symbol']);
        $this->smarty->assign("ICON", $this->getOrdre() % 2 == 0 ? "fa-solid fa-chart-area" : "fa-solid fa-chart-line");

        
        
    }

    public function getOrdre(){
        return 4;
    }
}