class OdeValidator {

    constructor() {
        this.is_valid = true;
        this.OL = new OdeLogger();
    }

    isValid(element) {
        return ( element !== null && this.checkRequired(element) && this.checkLengthByType(element) && this.checkFormatByType(element) ) ? true : false;
    }
    
    isEmpty(element) {
        return ( this.getFieldValue(element) !== false) ? false : true;
    }    
    
    checkFormatByType( element ) {
        var is_valid = true;
        if( $("#"+element.id).hasClass("hasDatepicker") ){ is_valid = this.isValidDate( element.id ); }
        (is_valid) ? this.showSuccess(element) : this.showError(element, `Le format du champ "${this.getFieldName(element)}" est incorrect`) ;
        return is_valid;
    }

    isValidDate( id ) {

        if($('#'+id).val().length == 0){return true;}
        if($('#'+id).val().length < 10){return false;}

        var jour = $('#'+id).val().charAt(0) + $('#'+id).val().charAt(1);
        if(jour <1 || jour >31){return false;}
        if(!$.isNumeric(jour)){return false;}
        
        var mois = $('#'+id).val().charAt(3) + $('#'+id).val().charAt(4);
        if(!$.isNumeric(mois)){return false;}
        if(mois <1 || mois >12){return false;}
        
        var annee = $('#'+id).val().charAt(6) + $('#'+id).val().charAt(7) + $('#'+id).val().charAt(8) + $('#'+id).val().charAt(9);
        if(!$.isNumeric(annee)){return false;}
        
        return true;
    }

    checkLengthByType( element ) {
        return this.checkLength( element, 3, 15 );
    }

    checkLength( element, min, max ) {
        return  true;
    }

    checkRequired(element) {
        var check_required = (element.required === true && this.isEmpty(element) ) ? false : true;
        (check_required) ? this.showSuccess(element) : this.showError(element, `Le champ "${this.getFieldName(element)}" est obligatoire`) ;
        return check_required;
    }

    getFieldType(element) {
        return (element.tagName) ? element.tagName : false;
    }
    
    getFieldName(element) {
        var element_name = ( isStringValid(element.name) ) ? element.name : false;
        var element_name_id = ( isStringValid(element.id) ) ? element.id.replace(/value_champ_/g, "").charAt(0).toUpperCase() + element.id.replace(/value_champ_/g, "").slice(1) : false;
        var name = element_name || element_name_id;
        return name.replace(/&#039;/g, "'") ;
    }

    getFieldValue(element) {
        var type = this.getFieldType(element);
        switch (type) {
            case "INPUT":
                return ( isStringValid(element.value) ) ? element.value : false;
            case "SELECT":
                return ( isStringValid(element.value) ) ? element.value : false;
            case "TEXTAREA":
                return ( isStringValid(element.value) ) ? element.value : false;    
            default:
                return false;
        }
    }

    showError(element, message) {

        const formControl = document.getElementById("titre_champ_"+ element.id.replace(/value_champ_/g,""));
        if( formControl !== null ){
            const small = formControl.querySelector('small');
            small.innerText = message;
            small.style.display = "block";
        }
        this.showErrorOnglet(element, message);
        if(document.getElementById("display_"+ element.id)){
            element = document.getElementById("display_"+ element.id);
            element.className = element.className.replace(/ ode-success/g,"").replace(/ ode-error/g,"") + " ode-error";
        }else{
            if(element.type == "checkbox"){
                element.parentNode.className = element.parentNode.className.replace(/ode-success/g,"").replace(/ode-error/g,"") + " ode-error";
            }else{
                element.className = element.className.replace(/ ode-success/g,"").replace(/ ode-error/g,"") + " ode-error";
            }
        }
    }

    showErrorOnglet(element, message) {
        var id_onglet = $( "#" + $(element).attr('id') ).closest('.div_layout_onglet').attr('id');
        var btn = id_onglet.replace('layout_onglet','btn_onglet');
        $("#"+btn ).parent().addClass( "tab-error" );
    }
  


    showSuccess(element) {
        const formControl = document.getElementById("titre_champ_"+ element.id.replace(/value_champ_/g,""));
        if( formControl !== null ){
            const small = formControl.querySelector('small');
            small.style.display = "none";
        }
        if(document.getElementById("display_"+ element.id)){
            element = document.getElementById("display_"+ element.id)
            element.className = element.className.replace(/ ode-success/g,"").replace(/ ode-error/g,"") + " ode-success";
        }else{
            if( element.type == "checkbox" ){
                element.parentNode.className = element.parentNode.className.replace(/ ode-success/g,"").replace(/ ode-error/g,"") + " ode-success";
            }else{
                element.className = element.className.replace(/ ode-success/g,"").replace(/ ode-error/g,"") + " ode-success";
            }
        }
    }

}



class OdeLogger {

    log( message ) {
  
        var stackTrace = (new Error()).stack;
        var caller_name = stackTrace.replace(/^Error\s+/, ''); 
        var caller_file_link = caller_name.split("\n")[1];
        var caller_file_link_array = ( caller_file_link !== "undefined" ) ? caller_file_link.split('/') : false;
        var caller_file_path_1 = "";
        if( caller_file_link_array !== false && Object.size(caller_file_link_array) > 3 ){
            var size_array = Object.size(caller_file_link_array);
            for (var i = 3; i < size_array; i++) {
               caller_file_path_1 += ( size_array-1 !== i ) ? caller_file_link_array[i] + "/" : caller_file_link_array[i];
            }
        }
        var caller_file_path_1_array = ( isStringValid(caller_file_path_1) ) ? caller_file_path_1.split(':') : false;
        var caller_file_path = (caller_file_path_1_array !== false && Object.size(caller_file_path_1_array) > 0) ? caller_file_path_1_array[0] : "";
        caller_name = caller_name.split("\n")[1]; 
        caller_name = caller_name.replace(/^\s+at Object./, ''); 
        caller_name = caller_name.replace(/ \(.+\)$/, '');
        caller_name = caller_name.replace(/\@.+/, ''); 
        caller_name = caller_name.replace(/    at/, ''); 
        caller_name = ( caller_name.includes('http') ) ? "Hors fonction" : caller_name + "()";

        if (ODE_DEBUGG === true) {
            if( typeof message == "string" || typeof message == "number"){
                var message_display = message;
            }else{
                if(typeof message === "object" && message === null){
                    var message_display = "Type = null";
                }
            }
            console.log("%c" + caller_file_path +"%c"+" :: "+ "%c" + caller_name +"%c"+" ➨ "+"%c"+message_display, "color:#35B3C5;", "font-weight: bold;", "color:#F08377;","font-weight: bold;","font-style: italic;");
            if( typeof message === "object" && message !== null){
                console.dir(message)
            }
        } 
    }

}


class GenerateurNavigation {

    getOnglets(){
        var onglets = {};
        var elements = $("[role=onglet]");
        if( elements.length > 0 ){
            for (let index = 0; index < elements.length; index++) {
                const element = elements[index];
                onglets[index] = {
                    id: element.id.replace(/btn_onglet_/g,''),
                    element: element,
                    selected: element.getAttribute("data-selected")
                }
            }
        }
        return onglets;
    }

    route( onglet_id ){
        this.selectOnglet( onglet_id );
        this.updateOnglets();
    }

    selectOnglet(onglet_id){
    
        var onglets = this.getOnglets();  
        if( Object.size( onglets ) > 0 ){
            Object.keys( onglets ).forEach( function( index ) {
                if( onglet_id === false ) onglet_id =  onglets[0].id;
                const onglet = onglets[index];
                ( onglet.id === onglet_id ) ? onglet.element.setAttribute( "data-selected", "1" ) : onglet.element.setAttribute( "data-selected", "0" );
            }.bind(this));
        }
    }

    updateOnglets(){
        var onglets = this.getOnglets();  
        if( Object.size( onglets ) > 0 ){
            Object.keys( onglets ).forEach( function( index ) {
                const onglet = onglets[index];
                if( onglet.selected === "1" ){
                    onglet.element.className = "btn_onglet btn_onglet_selected";
                    changeElementDisplay("span_"+onglet.id,"block");
                    changeElementDisplay("layout_onglet_"+onglet.id,"block");
                }else{
                    onglet.element.className = "btn_onglet btn_onglet_not_selected";
                    changeElementDisplay("span_"+onglet.id,"none");
                    changeElementDisplay("layout_onglet_"+onglet.id,"none");
                }
            }.bind(this));
        }
    }

}


class GenerateurRouting {

    constructor() {
        this.OL = new OdeLogger();
        this.forms = {
            layout_panel_standards:{
                selected : true,
                initialisation : false,
                bouton : "standard"
            },  
            layout_panel_avances:{
                selected : false,
                initialisation : false,
                bouton : "avances"
            }, 
            layout_panel_message:{
                selected : false,
                initialisation : true,
                bouton : "none"
            },
            layout_panel_formulaire:{
                selected : false,
                initialisation : true,
                bouton : "none"
            }, 
            layout_panel_edit_liste:{
                selected : false,
                initialisation : true,
                bouton : "none"
            }, 
            layout_panel_formulaire_onglet:{
                selected : false,
                initialisation : true,
                bouton : "none"
            }, 
        }
    }

    route( form_name , data ){
        if( this.forms.hasOwnProperty(form_name) ){
            this.initForm(form_name, data);
            this.displayForm();
        }
    }

    displayForm(){
        Object.keys( this.forms ).forEach( function( form_name ) {
            if( this.forms[form_name].selected === true ){
                this.displayBouton(this.forms[form_name].bouton);
                changeElementDisplay(form_name, "block")
            }else{
                changeElementDisplay(form_name, "none")
            }
        }.bind(this));
    }

    selectForm(_form_name){
        Object.keys( this.forms ).forEach( function( form_name ) {
            this.forms[form_name].selected = ( form_name === _form_name ) ? true : false;
        }.bind(this));
    }

    displayBouton(bouton_name){
        if( bouton_name === "standard" ){
            changeElementClass("btn_panel_standard", "btn_panel btn_panel_selected");
            changeElementClass("btn_panel_avances", "btn_panel btn_panel_not_selected");
        } else if( bouton_name === "avances" ){
            changeElementClass("btn_panel_standard", "btn_panel btn_panel_not_selected");
            changeElementClass("btn_panel_avances", "btn_panel btn_panel_selected");
        }else{
            changeElementClass("btn_panel_standard", "btn_panel btn_panel_not_selected");
            changeElementClass("btn_panel_avances", "btn_panel btn_panel_not_selected");
        }
    }

    initForm( form_name, data ){
        if(form_name === "layout_panel_formulaire") this.initFormulaire(data);
        if(form_name === "layout_panel_message") this.initFormMessage(data);
        if(form_name === "layout_panel_edit_liste") this.initFormListe(data);
        if(form_name === "layout_panel_formulaire_onglet") this.initFormOnglet(data);
        this.selectForm(form_name);
    }

    initFormOnglet( data ){
        var onglet_id = ( isStringValid(data.onglet.id) ) ? data.onglet.id :"";
        var onglet_libelle = ( isStringValid(data.onglet.libelle) ) ? data.onglet.libelle :"";
        var onglet_cle = ( isStringValid(data.onglet.cle) ) ? data.onglet.cle :"";
        setInputValue( "formulaire_onglet_id", onglet_id );
        setInputValue( "formulaire_onglet_libelle", onglet_libelle );
        setInputValue( "formulaire_onglet_cle", onglet_cle );
        changeElementDisplay("formulaire_onglet_libelle_small", "none");
        document.getElementById("formulaire_onglet_libelle").style.border = "none";
        this.initBoutonFormulaireOnglet(data.fonction);
        this.initTitleFormulaireOnglet(data.fonction);
    }

    initBoutonFormulaireOnglet(fonction_name){
        switch (fonction_name) {
            case "create":
                changeElementDisplay("formulaire_onglet_ajouter", "flex");
                changeElementDisplay("formulaire_onglet_modifier", "none");
                changeElementDisplay("formulaire_onglet_supprimer", "none");
                if(document.getElementById('formulaire_onglet_ajouter')){
                    document.getElementById('formulaire_onglet_ajouter').childNodes[1].style.display = "none";
                }
                break;
            case "edit":
                changeElementDisplay("formulaire_onglet_ajouter", "none");
                changeElementDisplay("formulaire_onglet_modifier", "flex");
                changeElementDisplay("formulaire_onglet_supprimer", "flex");
                if(document.getElementById('formulaire_onglet_modifier')){
                    document.getElementById('formulaire_onglet_modifier').childNodes[1].style.display = "none";
                }
                if(document.getElementById('formulaire_onglet_supprimer')){
                    document.getElementById('formulaire_onglet_supprimer').childNodes[1].style.display = "none";
                }
                break;
            default:
                changeElementDisplay("formulaire_onglet_ajouter", "none");
                changeElementDisplay("formulaire_onglet_modifier", "none");
                changeElementDisplay("formulaire_onglet_supprimer", "none");
                break;
        }
    }

    initTitleFormulaireOnglet(fonction_name){
        viderElement("formulaire_onglet_titre");
        switch (fonction_name) {
            case "create":
                if(document.getElementById("formulaire_onglet_titre")) document.getElementById("formulaire_onglet_titre").appendChild(document.createTextNode("Création d'un onglet"));
                break;
            case "edit":
                if(document.getElementById("formulaire_onglet_titre")) document.getElementById("formulaire_onglet_titre").appendChild(document.createTextNode("Edition de l'onglet"));
                break;
            default:
                if(document.getElementById("formulaire_onglet_titre")) document.getElementById("formulaire_onglet_titre").appendChild(document.createTextNode("Générateur d'onglet"));
                break;
        }
    }

    initFormListe( data ){
        setInputValue( "edit_liste_hidden", utf8_to_b64( JSON.stringify(data) ) )
        var liste = isStringValid( data.champ.params ) ? this.getListeChamp( data.champ.params ) : false;
        this.initFormEditListe( liste ); 
    }

    getListeChamp( params ){
        var params = ( isStringValid(params) ) ? JSON.parse( b64_to_utf8( params) ) : {} ;
        return ( params.hasOwnProperty("liste") && Object.size(params.liste) > 0 ) ? params.liste : false;
    }
    
    initFormEditListe( liste ){
        var list_elements_html = '';
        viderElement("div_ligne_edit_liste");
        if(liste === false){
            list_elements_html += this.getLigneEditListe("","");
        }else{
            Object.keys(liste).forEach(function(key) {
                list_elements_html += this.getLigneEditListe( key, liste[key] );
            }.bind(this));
        }
        $("#div_ligne_edit_liste").append(list_elements_html);
    }

    getLigneEditListe( cle, value ){
        var ligne_html  = '<div style="padding: 2%;">';
        ligne_html      +=    '<input type="text" placeholder="Clé" value="'+ cle +'" style="height: 10%;width: 25%;margin-right: 2%;">';
        ligne_html      +=    '<input type="text" placeholder="Valeur" value="'+ value +'" style="height: 10%;width: 65%;">';
        ligne_html      +=    '<span onclick="deleteLigneListe(this)" class="glyphicon glyphicon-trash" style="margin-left: 5px;color: red;cursor: pointer;"></span>';
        ligne_html      += '</div>';
        return ligne_html;
    }

    initFormMessage( data ){

        if( data.statut === "ok" ){
            changeElementDisplay("form_message_icon_success", "inline-block");
            changeElementDisplay("form_message_icon_error", "none");
        }else{
            changeElementDisplay("form_message_icon_success", "none");
            changeElementDisplay("form_message_icon_error", "inline-block");
        }
        viderElement("form_message_titre");
        document.getElementById("form_message_titre").appendChild( document.createTextNode(data.titre) );
        viderElement("form_message_message");
        document.getElementById("form_message_message").appendChild( document.createTextNode(data.message) );
    }

    initFormulaire( data ){

        var init = this.getDataInitFormulaire(data)
        if ( init !== false ) {
            setInputValue("formulaire_nom", init.name);
            setInputValue("formulaire_libelle", init.libelle);
            setInputValue("formulaire_type", init.type);
            ( init.obligatoire === "0" ) ? setCheckBoxValue("formulaire_obligatoire", false) : setCheckBoxValue("formulaire_obligatoire", true);
            ( init.ineditable === "0" ) ? setCheckBoxValue("formulaire_ineditable", false) : setCheckBoxValue("formulaire_ineditable", true);
            setInputValue("formulaire_aide", init.aide);
            this.initChampDefaut(init.type , init.params);
            if( init.type === "checkbox" ){
                ( init.defaut === "0" || init.defaut === 0 ) ? $('#formulaire_defaut').prop("checked" , false) : $('#formulaire_defaut').prop("checked" , true);
            }else{
                setInputValue("formulaire_defaut", init.defaut);
            }
            setInputValue("formulaire_description", init.description);
            setInputValue("formulaire_params", init.params);
            ( init.modifiable === "0" ) ? setInputValue("formulaire_modifiable", '0') : setInputValue("formulaire_modifiable", '1');
            ( data.fonction === "create" ) ? removeElementAttribute("formulaire_nom","disabled") : setElementAttribute("formulaire_nom","disabled",true);
            ( init.modifiable === "0" ) ? this.lockFormulaire() : this.dislockFormulaire();
            this.initSelectFormulaire(init);
            this.initBoutonFormulaire(data.fonction);
            this.initTitleFormulaire(data.fonction);

        } else {
            console.log(" - initFormulaire :: ERREUUUR " )
        }
        
    }

    getListeChampBasic( params ){
        var params = ( isStringValid(params) ) ? JSON.parse( b64_to_utf8( params) ) : {} ;
        var liste_name = ( params.hasOwnProperty("liste_name") && Object.size(params.liste_name) > 0 ) ? params.liste_name : false;
        var listes = ( liste_name !== false && isStringValid( $("#listes_dossier").val() ) ) ? JSON.parse( b64_to_utf8( $("#listes_dossier").val() ) ) : {} ;
        var liste = ( listes.hasOwnProperty(liste_name) && Object.size( listes[liste_name] ) > 0 ) ?listes[liste_name] : {};
        return liste;
    }

    initChampDefaut( type , params ){

        $('#formulaire_defaut_div').empty();

        var input_defaut = '<label for="formulaire_defaut" style="width: 25%;">Défaut:</label>';
        if ( type === "montant" || type === "pourcentage" ) {
            input_defaut += '<input id="formulaire_defaut" type="number" value="0.00" step=".01" min="0" style="height: 10%; width: 70%;background: #c3e7fd none repeat scroll 0 0;" >';
        } else if ( type === "liste_choix_simple" || type === "liste_choix_multi") {
            input_defaut += '<select name="default" id="formulaire_defaut" style="height: 10%; width: 60%;"></select>';
        } else if ( type === "liste") {
            var liste = this.getListeChampBasic( params );
            input_defaut += '<select name="default" id="formulaire_defaut" style="height: 10%; width: 60%;">';
            input_defaut +=     '<option label="-aucun-" value="">-aucun-</option>'
            if ( Object.size( liste ) > 0 ){
                Object.keys(liste).forEach(function(option_id) {
                    var option_name = liste[option_id];
                    if( isStringValid(option_id) && isStringValid(option_name) ){
                        input_defaut +=     '<option label="' + option_name + '" value="'+option_id+'">' + option_name + '</option>'
                    }
                });
            }
            input_defaut += '</select>';
        } else if ( type === "date" ) {
            input_defaut += '<select name="default" id="formulaire_defaut">'
            input_defaut +=     '<option label="-aucun-" value="">-aucun-</option>'
            input_defaut +=     '<option label="hier" value="-1 day">hier</option>'
            input_defaut +=     '<option label="aujourd\'hui" value="now">aujourd\'hui</option>'
            input_defaut +=     '<option label="demain" value="+1 day">demain</option>'
            input_defaut +=     '<option label="prochaine semaine" value="+1 week">prochaine semaine</option>'
            input_defaut +=     '<option label="prochain lundi" value="next monday">prochain lundi</option>'
            input_defaut +=     '<option label="prochain vendredi" value="next friday">prochain vendredi</option>'
            input_defaut +=     '<option label="2 semaines" value="+2 weeks">2 semaines</option>'
            input_defaut +=     '<option label="prochain mois" value="+1 month">prochain mois</option>'
            input_defaut +=     '<option label="premier jour du mois prochain" value="first day of next month">premier jour du mois prochain</option>'
            input_defaut +=     '<option label="3 mois" value="+3 months">3 mois</option>'
            input_defaut +=     '<option label="6 mois" value="+6 months">6 mois</option>'
            input_defaut +=     '<option label="année prochaine" value="+1 year">année prochaine</option>'
            input_defaut += '</select>'
        } else if ( type === "checkbox" ) {
            input_defaut += '<input type="checkbox" id="formulaire_defaut" /> (Etat initial)';
        } else if ( type === "relation" ) {
            input_defaut += '<input type="text" id="formulaire_defaut" style="height: 10%; width: 70%;" disabled />';
        } else{
            input_defaut += '<input type="text" id="formulaire_defaut" style="height: 10%; width: 70%;" />';
        }
        
        $('#formulaire_defaut_div').append( input_defaut );
    }

    initSelectFormulaire(init){

        $('#formulaire_liste').empty();
       
        if ( init.type === "liste_choix_simple" || init.type === "liste_choix_multi" ){
            var params = ( isStringValid(init.params) ) ? JSON.parse( b64_to_utf8(init.params) ) : "" ;
            if( params !== "" && params.hasOwnProperty("liste") && Object.size(params.liste) > 0 ){
                $('#formulaire_defaut').append( '<option value="">Aucun</option>' );
                Object.keys( params.liste ).forEach( function( option_id ) {
                    const option_value = params.liste[option_id];
                    $('#formulaire_liste').append( '<option value="' + option_id + '">' + option_value + '</option>' );
                    $('#formulaire_defaut').append( '<option value="' + option_id + '">' + option_value + '</option>' );
                });
            }
            changeElementDisplay("div_formulaire_select", "block")
        }else{
            changeElementDisplay("div_formulaire_select", "none");
        } 
  
    }

    lockFormulaire(){
        setElementAttribute("formulaire_obligatoire","disabled",true)
        setElementAttribute("formulaire_ineditable","disabled",true)
    }

    dislockFormulaire(){
        removeElementAttribute("formulaire_obligatoire","disabled")
        removeElementAttribute("formulaire_ineditable","disabled")
    }

    initBoutonFormulaire(fonction_name){
        switch (fonction_name) {
            case "create":
                changeElementDisplay("formulaire_btn_ajouter", "flex");
                changeElementDisplay("formulaire_btn_modifier", "none");
                changeElementDisplay("formulaire_btn_annuler", "flex");
                changeElementDisplay("formulaire_btn_terminer", "none");
                if(document.getElementById('formulaire_btn_ajouter')){
                    document.getElementById('formulaire_btn_ajouter').childNodes[1].style.display = "none";
                }
                break;
            case "edit":
                changeElementDisplay("formulaire_btn_ajouter", "none");
                changeElementDisplay("formulaire_btn_modifier", "flex");
                changeElementDisplay("formulaire_btn_annuler", "flex");
                changeElementDisplay("formulaire_btn_terminer", "none");
                if(document.getElementById('formulaire_btn_modifier')){
                    document.getElementById('formulaire_btn_modifier').childNodes[1].style.display = "none";
                }
                break;
            default:
                changeElementDisplay("formulaire_btn_ajouter", "none");
                changeElementDisplay("formulaire_btn_modifier", "none");
                changeElementDisplay("formulaire_btn_annuler", "none");
                changeElementDisplay("formulaire_btn_terminer", "none");
                break;
        }
    }

    initTitleFormulaire(fonction_name){
        viderElement("formulaire_titre");
        switch (fonction_name) {
            case "create":
                if(document.getElementById("formulaire_titre")) document.getElementById("formulaire_titre").appendChild(document.createTextNode("Création d'un nouveau champ"));
                break;
            case "edit":
                if(document.getElementById("formulaire_titre")) document.getElementById("formulaire_titre").appendChild(document.createTextNode("Edition du champ"));
                break;
            default:
                if(document.getElementById("formulaire_titre")) document.getElementById("formulaire_titre").appendChild(document.createTextNode("Générateur de champ"));
                break;
        }
    }

    getDataInitFormulaire(data){
        var init = {
            name: data.champ.name,
            libelle: data.champ.libelle,
            type: data.champ.type,
            obligatoire: data.champ.obligatoire,
            ineditable: data.champ.ineditable,
            aide: data.champ.aide,
            defaut: data.champ.defaut,
            description: data.champ.description,
            params: data.champ.params,
            modifiable: data.champ.modifiable,
        };
        return init;
    }



}












class GenerateurChamp {

    constructor( element ) {
        this.OL = new OdeLogger();
        this.element = ( this.isValid( element ) ) ? element : false;
    }

    isValid(element) {
        return ( element !== null && element !== undefined && this.checkRequired(element) ) ? true : false;
    }

    checkRequired(element){
        if( typeof element.getAttribute === undefined || typeof element.getAttribute !== "function" ) return false; 
        if( element.getAttribute("data-name") === null ) return false;
        if( element.getAttribute("data-libelle") === null ) return false;
        if( element.getAttribute("data-type") === null ) return false;
        if( element.getAttribute("data-obligatoire") === null ) return false;
        if( element.getAttribute("data-ineditable") === null ) return false;
        if( element.getAttribute("data-aide") === null ) return false;
        if( element.getAttribute("data-defaut") === null ) return false;
        if( element.getAttribute("data-description") === null ) return false;
        if( element.getAttribute("data-params") === null ) return false;
        if( element.getAttribute("data-modifiable") === null ) return false;
        return true;
    }

    createElement( element ) {

        var element_html = ""; 

        var display_obligatoire = ( element.obligatoire === '1' ) ? 'display:inline-block;' : 'display:none;';
        var name_display = element.name.trim().replace(/ /g, "_").toLowerCase();
        var libelle_display = ( isStringValid(element.libelle) ) ? element.libelle : capitalizeFirstLetter( element.name.trim() ); 
        
        element_html += '<div '; 
        element_html +=     'id="champ_'+name_display+'"'; 
        element_html +=     'class="champ_referentiel champ_panel" draggable="true" ondragstart="onDragStart(event)" ondragend="onDragEnd(event)" onclick="openEditChamp(this)"'; 
        element_html +=     'data-name="'+name_display+'"';
        element_html +=     'data-libelle="'+libelle_display+'"';
        element_html +=     'data-obligatoire="'+element.obligatoire+'"';
        element_html +=     'data-ineditable="'+element.ineditable+'"';
        element_html +=     'data-aide="'+element.aide+'"';
        element_html +=     'data-defaut="'+element.defaut+'"';
        element_html +=     'data-description="'+element.description+'"';
        element_html +=     'data-type="'+element.type+'"';
        element_html +=     'data-modifiable="'+element.modifiable+'"';
        element_html +=     'data-params="'+element.params+'"';
        element_html += '> ';
        element_html +=     '<div id="titre_champ_'+name_display+'" class="align-items-center d-flex" style="width: 100%;">';
        element_html +=         '<div style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;max-width: 70%;">'+libelle_display+'&nbsp; </div>';
        element_html +=         '<span role="obligatoire" style="color: red; font-weight: bold; ' + display_obligatoire + '">&nbsp; *</span>';
        element_html +=         '<span style="font-size: x-small; font-style: oblique; color: #35b3c5;margin-right: 3px;">';
        element_html +=             this.getLibelleType(element.type);
        element_html +=         '</span>';
        element_html +=     '</div>';
        element_html +=     '<div class="ode_input_hidden"></div>';
        element_html += '</div>';

        $("#layout_panel_standards").append(element_html);

        this.element = ( this.isValid( document.getElementById("champ_"+name_display) ) ) ? document.getElementById("champ_"+name_display) : false;
    }

    getLibelleType(type){
        var array_type = { 
            "montant": "Montant",
            "checkbox": "Case à cocher",
            "relation": "Relation",
            "text": "Texte",
            "date": "Date",
            "liste": "Liste simple",
            "liste_choix_simple": "Liste",
            "liste_choix_multi": "Liste multiple",
            "pourcentage": "Pourcentage",
            "text_long": "Texte long",
        };
        return ( array_type.hasOwnProperty(type) ) ? " ("+array_type[type]+") " : " (Indéfini) " ; 
    }

    getName(){
        return ( this.element !== false && isStringValid(this.element.getAttribute("data-name")) ) ? this.element.getAttribute("data-name") : "";
    }

    setName(name){}

    getLibelle(){
        return ( this.element !== false &&  isStringValid(this.element.getAttribute("data-libelle")) ) ? this.element.getAttribute("data-libelle") : "";
    }

    setLibelle(libelle){
        if( this.element !== false && isStringValid(libelle) ){ 
            this.element.setAttribute( "data-libelle", libelle ); 
            this.setTitre(libelle);
        }
    }

    setTitre(libelle){
        var id_titre = "titre_champ_"+this.getName();
        var titre_html = "";
        if(document.getElementById(id_titre)){
            viderElement(id_titre);
            titre_html += ( this.getModifiable() === '0' ) ? '<i class="fas fa-lock" style="color: #d4af37;margin-right: 3px;"></i>' : '';
            titre_html += '<div style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;max-width: 70%;">' + libelle + '&nbsp;</div>';
            titre_html += '<span role="obligatoire" style="color: red; font-weight: bold;display:none;">&nbsp; *</span>';
            titre_html += '<span style="font-size: x-small; font-style: oblique; color: #35b3c5;margin-right: 3px;">';
            titre_html +=       this.getLibelleType(this.getType());
            titre_html += '</span>';
            $("#"+id_titre).append(titre_html);
        }
    }

    getType(){
        return ( this.element !== false &&  isStringValid(this.element.getAttribute("data-type")) ) ? this.element.getAttribute("data-type") : "";
    }

    setType(type){
        if( this.element !== false && isStringValid(type) ){ this.element.setAttribute( "data-type", type ); }
    }

    getObligatoire(){
        return ( this.element !== false &&  this.element.getAttribute("data-obligatoire") === "1" ) ? "1" : "0";
    }

    setObligatoire(obligatoire){
        if( this.element !== false ){ 
            if ( obligatoire === "1" ){
                this.element.setAttribute( "data-obligatoire", "1" );
                document.getElementById("titre_champ_"+this.getName()).querySelectorAll('[role="obligatoire"]')[0].style.display = "inline-block";
            } else {
                this.element.setAttribute( "data-obligatoire", "0" );
                document.getElementById("titre_champ_"+this.getName()).querySelectorAll('[role="obligatoire"]')[0].style.display = "none";
            }; 
        }
    }

    getIneditable(){
        return ( this.element !== false &&  this.element.getAttribute("data-ineditable") === "1" ) ? "1" : "0";
    }

    setIneditable(ineditable){
        if( this.element !== false ){ 
            ( ineditable === "1" ) ? this.element.setAttribute( "data-ineditable", "1" ) : this.element.setAttribute( "data-ineditable", "0" ); 
        }
    }

    getAide(){
        return ( this.element !== false &&  isStringValid(this.element.getAttribute("data-aide")) ) ? this.element.getAttribute("data-aide") : "";
    }
    
    setAide( aide ){
        if( this.element !== false ){ this.element.setAttribute( "data-aide", aide ); }
    }

    getDefaut(){
        return ( this.element !== false &&  isStringValid(this.element.getAttribute("data-defaut")) ) ? this.element.getAttribute("data-defaut") : "";
    }

    setDefaut(defaut){
        if( this.element !== false ){ this.element.setAttribute( "data-defaut", defaut ); }
    }

    getDescription(){
        return ( this.element !== false &&  isStringValid(this.element.getAttribute("data-description")) ) ? this.element.getAttribute("data-description") : "";
    }

    setDescription(description){
        if( this.element !== false && isStringValid(description) ){ this.element.setAttribute( "data-description", description ); }
    }

    getParams(){
        return ( this.element !== false &&  isStringValid(this.element.getAttribute("data-params")) ) ? this.element.getAttribute("data-params") : "";
    }

    setParams(params){
        if( this.element !== false && isStringValid(params) ){ this.element.setAttribute( "data-params", params ); }
    }

    getModifiable(){
        return ( this.element !== false &&  this.element.getAttribute("data-modifiable") === "1" ) ? "1" : "0";
    }

    setModifiable(modifiable){ }

    getData(){
        if( this.element !== false ){
            return {
                name: this.getName(),
                libelle: this.getLibelle(),
                type: this.getType(),
                obligatoire: this.getObligatoire(),
                ineditable: this.getIneditable(),
                aide: this.getAide(),
                defaut: this.getDefaut(),
                description: this.getDescription(),
                params: this.getParams(),
                modifiable: this.getModifiable(),
            };
        }else{
            return false;
        }
    }

    setData(data){
        if( data !== null && data !== undefined && this.element !== false ){
            this.setLibelle( data.libelle );
            this.setType( data.type );
            this.setObligatoire( data.obligatoire );
            this.setIneditable( data.ineditable );
            this.setAide( data.aide );
            this.setDefaut( data.defaut );
            this.setDescription( data.description );
            this.setParams( data.params );
            return true;
        }else{
            return false;
        }
    }

}



class OdeLoading {

    constructor( ) {
        this.OL = new OdeLogger();
        if( document.getElementById("overlay_body") === null ) this.initOverlay();
    }

    initOverlay(){
        var div= document.createElement("div");
        div.id = "overlay_body";
        div.className = "overlay-body";
        document.body.appendChild(div);
    }

    addSpinner( el, static_pos ){
        this.showOverlay();
        var spinner = el.children('.spinner');
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    }

    removeSpinner(el, complete){
        this.hideOverlay();
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    }

    hideOverlay(){ $("#overlay_body").hide();}
    showOverlay(){ $("#overlay_body").show("fade", { direction: "right", align: "center" }, 200 ) ;}

    animateSpinner(el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }
}