if( typeof ODE_DEBUGG === undefined) {
    const ODE_DEBUGG = true;
}

// Fonction qui vérifie si le param est un string et non null , si oui retourne le string sinon false 
function isStringValid(string){
    return ( typeof string == "string" && string.replace(/\s/g, '').length != 0 ) ? string : false;
}

// Fonction qui ajoute un Object à une liste d'objets
function addElement (element_list, element) {
    let new_element_list = Object.assign(element_list, element)
    return new_element_list
}

// Fonction qui change la valeur de l'attribut display d'un élément
function changeElementDisplay(name, display) {
    if (document.querySelectorAll("#" + name)) {
        for (let i = 0; i < document.querySelectorAll("#" + name).length; i++) {
            var element = document.querySelectorAll("#" + name)[i];
            element.style.display = display;
        }
    }
}

// Fonction qui change la valeur de l'attribut class d'un élément
function changeElementClass(name, new_class) {
    if (document.querySelectorAll("#" + name)) {
        for (let i = 0; i < document.querySelectorAll("#" + name).length; i++) {
            var element = document.querySelectorAll("#" + name)[i];
            element.className = new_class;
        }
    }
}

// Fonction qui déclenche un traitement Ajax, pour l'utiliser il faut d'abord coder les 3 fonctions dans "getDataFunction" , "loadingFunction" et "retourFunction" 
function execute( _name , _module_name){

    var xhr = getXhr();
    if (xhr === false) display_erreur("Votre navigateur ne supporte pas l objet XMLHTTPRequest.");

    var url = (typeof _module_name === 'undefined' || _module_name === null || !isStringValid(_module_name) ) ? '/index.php?module=OPS_generateur_vue' : '/index.php?module='+_module_name;
    var fonctions = ( getDataFunction.hasOwnProperty(_name) && loadingFunction.hasOwnProperty(_name) && retourFunction.hasOwnProperty(_name) ) ? true : false;
    if(fonctions){
        var data = ( getDataFunction[_name]() ) ? getDataFunction[_name]() : false;
        var full_url = url + "&action=" + _name ;
    }

    if( data ){
        xhr.open('POST', full_url , true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.addEventListener('loadstart', loadingFunction[_name]());
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if(isReponseValid(xhr.response)){
                    retourFunction[_name](isReponseValid(xhr.response));
                }
            }
        }
        xhr.send(data);
    }else{
        console.log(" sendAjaxRequest() => data == false");
    }
}

// Fonction qui vérifie que la réponse retouner par l'ajax n'est pas vide ou erreur et qu'elle est bien au format Json
// Si oui retourne le json sous forme d'objet sinon retourne false
function isReponseValid(reponse){
    return ( !isErreurAjax(reponse) && isJson(reponse) ) ? JSON.parse(reponse) : false;
}

// Fonction qui vide un element des elements qu'il contient
function viderElement(id) {
    if (document.querySelectorAll("#" + id)) {
        for (let i = 0; i < document.querySelectorAll("#" + id).length; i++) {
            var myNode = document.querySelectorAll("#" + id)[i];
            while (myNode.firstChild) {
                myNode.removeChild(myNode.firstChild);
            }
        }
    }
}

// Fonction qui vérifie l'éxistance de l'élement et ajoute l'attribut
function setElementAttribute( id, attribut_name, attribut_value){
    if( isStringValid(id) && isStringValid(attribut_name) ){
        if( document.getElementById(id) ){
            document.getElementById(id).setAttribute(attribut_name,attribut_value);
        }
    }
}

// Fonction qui vérifie l'éxistance de l'élement et supprime l'attribut
function removeElementAttribute( id, attribut_name){
    if( isStringValid(id) && isStringValid(attribut_name) ){
        if( document.getElementById(id) ){
            document.getElementById(id).removeAttribute(attribut_name);
        }
    }
}

// Fonction qui retourne la valeur d'un input 
function getInputValue(id_input) {
    var value = "";
    if (document.getElementById(id_input)) {
        if(isStringValid(document.getElementById(id_input).value)){
            value = document.getElementById(id_input).value;
        }
    }
  
    return value;
}

// Fonction qui retourne la valeur d'un input 
function getCheckBoxValue(id_check_box) {
    var checked = false;
    if (document.getElementById(id_check_box)) {
        if(document.getElementById(id_check_box).checked){
            checked = document.getElementById(id_check_box).checked;
        }
    }
    return checked;
}

// Fonction qui affecte une valeur à un input 
function setCheckBoxValue(id_check_box,checked) {
    if (document.getElementById(id_check_box)) {
        document.getElementById(id_check_box).checked = checked;
    }
    checked ? setInputValue(id_check_box, "1") : setInputValue(id_check_box, "0");
}

// Fonction qui affecte une valeur à un input 
function setInputValue(id_input,value) {
    if (document.getElementById(id_input)) {
        document.getElementById(id_input).value = ( isStringValid(value) ) ? value : "";
    }
}

// Fonction qui retourne l'id de l'option séléctionné
function getSelectValue(id_select) {
    var value = "";
    if (document.getElementById(id_select)) {
        if(document.getElementById(id_select).options.length > 0){
            var id_selected = document.getElementById(id_select).options.selectedIndex;
            if(document.getElementById(id_select).options[id_selected]){
                value = document.getElementById(id_select).options[id_selected].value;
            }
        }
        
    }
    return value;
}

// fonction qui détecte si un élement dispose de la classe en param, retourne true ou false
function hasClass(element, cls) {
    return (' ' + element.className + ' ').indexOf(' ' + cls + ' ') > -1;
}

// Detection si c'est une erreur ajax, généralement retourne une page html
function isErreurAjax(reponse) {
    return ( reponse.indexOf('<!DOCTYPE html>') != -1 ) ? true : false;
}

// Fonction qui vérifie si le string en param est un Json
function isJson(item) {
    item = typeof item !== "string" ?
        JSON.stringify(item) :
        item;

    try {
        item = JSON.parse(item);
    } catch (e) {
        return false;
    }

    if (typeof item === "object" && item !== null) {
        return true;
    }

    return false;
}

function getRandomId(){
    return Date.now();
}

// Fonction qui initialise l'objet XHR
function getXhr() {
    var xhr = null;
    if (window.XMLHttpRequest || window.ActiveXObject) {
        if (window.ActiveXObject) {
            try {
                xhr = new ActiveXObject('Msxml2.XMLHTTP');
            } catch (e) {
                xhr = new ActiveXObject('Microsoft.XMLHTTP');
            }
        } else {
            xhr = new XMLHttpRequest();
        }
        return xhr;
    } else {
        return false;
    }
}

// fonction qui récupere la valeur d'une variable dans l'url
function $_GET(param) {
    var vars = {};
    window.location.href.replace(location.hash, '').replace(
        /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
        function(m, key, value) { // callback
            vars[key] = value !== undefined ? value : '';
        }
    );
    if (param) {
        return vars[param] ? vars[param] : null;
    }
    return vars;
}

// Fonction pour calculer length d'un Objet JS
Object.size = function(obj) {
    var size = 0, key;
    for (key in obj) {
        if (obj.hasOwnProperty(key)) size++;
    }
    return size;
};

// Fonction pour attendre quelques secondes avant de continuer pour 3 secondes par exemple on utilise wait(3000)
function wait(ms){
    var start = new Date().getTime();
    var end = start;
    while(end < start + ms) {
      end = new Date().getTime();
   }
}

// Fonction qui encode une chaine de caractere utf8 => base64
function utf8_to_b64( str ) {
    return window.btoa(unescape(encodeURIComponent( str )));
}

// Fonction qui decode une chaine de caractere base64 => utf8
function b64_to_utf8( str ) {
    return decodeURIComponent(escape(window.atob( str )));
}

function initSelectOptions( id_select, options ){
    if( document.getElementById( id_select ) ){
        viderElement(id_select);
        if( Object.size(options) > 0 ){
            Object.keys(options).forEach(function(key) {
                if( isStringValid(key) && isStringValid(options[key]) ){
                    var option = document.createElement("option"); 
                    option.setAttribute("value", key);
                    option.appendChild( document.createTextNode( options[key] ) )
                    document.getElementById( id_select ).appendChild(option);
                }
            });
        }else{
            console.log("initSelectOptions :: Options vide ")
        }
    }else{
       (ODE_DEBUGG === true) ? console.log("%c ode_helper.js :: initSelectOptions => Le select id = "+id_select+" est undefini", "color: red;") : "";
    }
}

function odeLog( message ){

    var caller_name = ( (odeLog.caller) && (odeLog.caller.name) ) ?  odeLog.caller.name : "undefined";
    var caller_file_link = ( isStringValid(_getCallerFile()) ) ? _getCallerFile() : "undefined";
    var caller_file_link_array = ( caller_file_link !== "undefined" ) ? caller_file_link.split('/') : false;
    var caller_file_path = "";
    if( caller_file_link_array !== false && Object.size(caller_file_link_array) > 3 ){
        var size_array = Object.size(caller_file_link_array);
        for (i = 3; i < size_array; i++) {
           caller_file_path += ( size_array-1 !== i ) ? caller_file_link_array[i] + "/" : caller_file_link_array[i];
        }
    }
    if (ODE_DEBUGG === true) {
        if( typeof message == "string" || typeof message == "number"){
            var message_display = message;
        }else{
            if(typeof message === "object" && message === null){
                var message_display = "Type = null";
            }
        
        }
        console.log("%c" + caller_file_path +"%c"+" :: "+ "%c" + caller_name +"()"+"%c"+" ➨ "+"%c"+message_display, "color:#35B3C5;", "font-weight: bold;", "color:#F08377;","font-weight: bold;","font-style: italic;");
        if( typeof message === "object" && message !== null){
                console.dir(message)
        }
    } 
}

function _getCallerFile() {
    var originalFunc = Error.prepareStackTrace;
    var callerfile;
    try {
        var err = new Error();
        var currentfile;
        Error.prepareStackTrace = function (err, stack) { return stack; };
        currentfile = err.stack.shift().getFileName();
        while (err.stack.length) {
            callerfile = err.stack.shift().getFileName();
            if(currentfile !== callerfile) break;
        }
    } catch (e) {}
    Error.prepareStackTrace = originalFunc; 
    return callerfile;
}

// Fonction qui met en Maj la premiere lettre et en min les autres, si != de string ou empty elle retourne la variable
function capitalizeFirstLetter(string) {
    return (typeof string === "string" && string !== "") ?
        string.toLowerCase().charAt(0).toUpperCase() + string.toLowerCase().slice(1) : string; 
}

// Fonction qui convertie un number au format montant en Euro 
function getCurrencyFormat(num) {
    return (typeof num === "number") ? (
      num
        .toFixed(2)
        .replace('.', ',')  
        .replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1 ') + ' €'
    ) : '0,00 €';
}