<?php


class hook_subvention
{

	// Méthode du hook « Cleanup »
	function delete_related_relations( $bean, $event, $arguments = null)
	{
		if ($event != 'before_delete') {
			return;
		}
		
		$is_erreur = false;

		// On récupere le dossier 
		$obj_bean = ( !empty( $bean->id )) ? BeanFactory::getBean( 'OPS_dossier', $bean->id ) : false;

		# On vérifie de disposer véritablement d'un dossier.
		if( $obj_bean === false ){

			$is_erreur = true;

			$GLOBALS['log']->fatal(" hook_subvention :: delete_related_relations => Récupération impossible du Bean Dossier !");
			return;

		}

		# On collecte l'ensemble des éléments liés...

		$linked_elements = array();

		// Dependency context : ODE_SUB
		$linked_elements['ops_engagement']    = $bean->get_linked_beans("ops_engagement_ops_dossier","OPS_dossier");


		foreach( array_keys( $linked_elements ) as $i => $relationship ){

			// Reme relationships between OPD_dossier and OPS_{$relationship}
			foreach ($linked_elements[$relationship] as $relation) {
				$relation->mark_deleted($relation->id);
			}

		}
		

	}


}

?>