<?php

$manifest = array(
    0 => array(
        'acceptable_sugar_versions' => array(
            0 => ''
        )
    ),
    1 => array(
        'acceptable_sugar_flavors' => array(
            0 => 'CE',
            1 => 'PRO',
            2 => 'ENT'
        )
    ),
    'readme' => 'README.txt',
    'key' => 'ODE',
    'author' => 'Lanteas',
    'description' => 'Socle technique de la gamme Open X par Lanteas',
    'icon' => '',
    'is_uninstallable' => true,
    'name' => 'Open CRM - Premium',
    'published_date' => '2024-06-20 16:00:00',
    'type' => 'module',
    'version' => '3.0 BETA1',
    'release' => '01',
    'sticky' => '--',
    'remove_tables' => 'false'
);


$installdefs = array(

    'id' => 'ode_core',

    'administration' => array(
        array(
            'from' => '<basepath>/custom/modules/Administration/ops_admin.php'
        )
    ),
    'scheduledefs' => array(
        array(
            'from' => '<basepath>/custom/modules/Schedulers/notification_justificatifs.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/supprimer_justificatif.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/execution_retarde.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/supprimer_brouillon.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/supprimer_dossiers_temp.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/purge_bd_avec_delai.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/anonymisation_dossier_cloture.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/suppression_dossier_cloture.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/notification_suppression_compte_usager.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/supprimer_editiques_brouillons.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/delai_dossier.php'
        ),
    ),
    'post_execute' => array(
        0 => '<basepath>/scripts/post_execute.php'
    ),
    'pre_execute' => array(
        0 => '<basepath>/scripts/pre_execute.php'
    ),
    'post_uninstall' => array(
        0 => '<basepath>/scripts/post_uninstall.php'
    ),

    // Hooks Users : Habilitations + Dashlets
    'hookdefs' => array(
        array(
            'from' => '<basepath>/custom/Extension/modules/Users/Ext/LogicHooks/habilitation_hook.php',
            'to_module' => 'Users'
        )
    ),

    'logic_hooks' => array(
        array(
            'module' => 'OPS_justificatif_historisation',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Badge statut et fichier entry point',
            'file' => 'modules/OPS_justificatif_historisation/hook.php',
            'class' => 'hook_justificatif_historisation',
            'function' => 'init_statut'
        ),
        array(
            'module' => 'OPS_suivi_dossier',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'encode la valeur information en base64',
            'file' => 'modules/OPS_suivi_dossier/hook.php',
            'class' => 'hook_suivi_dossier',
            'function' => 'set_valeur_information'
        ),
        array(
            'module' => 'OPS_suivi_dossier',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Affichage html',
            'file' => 'modules/OPS_suivi_dossier/hook.php',
            'class' => 'hook_suivi_dossier',
            'function' => 'display_valeur_information'
        ),
        array(
            'module' => 'OPS_suivi_dossier',
            'hook' => 'after_retrieve',
            'order' => '',
            'description' => 'Affichage html',
            'file' => 'modules/OPS_suivi_dossier/hook.php',
            'class' => 'hook_suivi_dossier',
            'function' => 'display_valeur_information'
        ),
        array(
            'module' => 'OPS_lien_parente',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Set individu name and role',
            'file' => 'modules/OPS_lien_parente/hook.php',
            'class' => 'hook_lien_parente',
            'function' => 'set_individu'
        ),
        array(
            'module' => 'SecurityGroups',
            'hook' => 'after_save',
            'order' => '',
            'description' => 'Créer les habilitations des dispositifs au profil métier',
            'file' => 'custom/modules/SecurityGroups/hook_habilitation.php',
            'class' => 'hook_habilitation',
            'function' => 'create_habilitations_dispositifs'
        ),
        array(
            'module' => 'OPS_reunion',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Init name reunion',
            'file' => 'modules/OPS_reunion/hook.php',
            'class' => 'hook_reunion',
            'function' => 'set_name_reunion'
        ),
        array(
            'module' => 'OPS_commission',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Init name commission',
            'file' => 'modules/OPS_commission/hook.php',
            'class' => 'hook_commission',
            'function' => 'set_name_commission'
        ),

        array(
            'module' => 'OPS_elu',
            'hook' => 'before_relationship_add',
            'order' => '',
            'description' => 'Liaison élu dossier',
            'file' => 'modules/OPS_elu/hook.php',
            'class' => 'hook_elu',
            'function' => 'set_relation_elu_dossier'
        ),
        array(
            'module' => 'OPS_commission',
            'hook' => 'before_relationship_add',
            'order' => '',
            'description' => 'Liaison commission dossier',
            'file' => 'modules/OPS_commission/hook.php',
            'class' => 'hook_commission',
            'function' => 'set_relation_commission_dossier'
        ),
        array(
            'module' => 'OPS_reunion',
            'hook' => 'before_relationship_add',
            'order' => '',
            'description' => 'Liaison reunion dossier',
            'file' => 'modules/OPS_reunion/hook.php',
            'class' => 'hook_reunion',
            'function' => 'set_relation_reunion_dossier'
        ),
        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_relationship_add',
            'order' => '',
            'description' => 'Liaison des sous territoires du dossier',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'set_relation_sous_territoire_dossier'
        ),

        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_relationship_delete',
            'order' => '',
            'description' => 'Retire la liaison des sous territoires du dossier',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'unset_relation_sous_territoire_dossier'
        ),

        ///////////////// HOOKS BEFORE SAVE /////////////////      
        array(
            'module' => 'OPS_individu',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Initialisation du numéro de individu',
            'file' => 'modules/OPS_individu/hook.php',
            'class' => 'hook_individu',
            'function' => 'set_num_individu'
        ),
        array(
            'module' => 'OPS_action_statut',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Initialise ordre à 0 dans le fetched_row quand il est vide',
            'file' => 'modules/OPS_action_statut/hook.php',
            'class' => 'hook_action_statut',
            'function' => 'change_ordre'
        ),
        array(
            'module' => 'OPS_action_statut',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Initialisation du nom de la fonction',
            'file' => 'modules/OPS_action_statut/hook.php',
            'class' => 'hook_action_statut',
            'function' => 'init_fonction'
        ),
        array(
            'module' => 'OPS_dossier',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Initialisation du demandeur',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'init_demandeur'
        ),
        array(
            'module' => 'OPS_dossier',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Initialisation du dossier lié',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'init_dossier_lie'
        ),
        array(
            'module' => 'OPS_dispositif',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Initialisation des type tiers',
            'file' => 'modules/OPS_dispositif/hook.php',
            'class' => 'hook_dispositif',
            'function' => 'init_type_tiers'
        ),
        array(
            'module' => 'OPS_dossier',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Initialisation du badge statut avec sa couleur',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'init_statut'
        ),

        array(
            'module' => 'OPS_justificatif',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Initialisation du badge statut avec sa couleur',
            'file' => 'modules/OPS_justificatif/hook.php',
            'class' => 'hook_justificatif',
            'function' => 'init_statut'
        ),

        array(
            'module' => 'OPS_justificatif',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Initialisation de odre en fonction du dépôt',
            'file' => 'modules/OPS_justificatif/hook.php',
            'class' => 'hook_justificatif',
            'function' => 'init_order'
        ),

        array(
            'module' => 'OPS_justificatif',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Justificatif incomplet si on demande un justificatif',
            'file' => 'modules/OPS_justificatif/hook.php',
            'class' => 'hook_justificatif',
            'function' => 'justificatif_incomplet'
        ),

        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'execute action de statut lors de la correction du dossier',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'execute_action_statut'
        ),
        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Enregistrement dans les registres des suppressions des dossiers',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'sauvegarder_registre_suppression'
        ),
        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Met à jour les réunions sur les dossiers en passant par l edit view du dossier',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'set_reunions'
        ),

        array(
            'module' => 'OPS_statut',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Modification du sous pannel',
            'file' => 'modules/OPS_statut/hook.php',
            'class' => 'hook_statut',
            'function' => 'modif_subpannel'
        ),

        array(
            'module' => 'OPS_type_personne',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Modification de la vue liste',
            'file' => 'modules/OPS_type_personne/hook.php',
            'class' => 'hook_type_personne',
            'function' => 'modif_listview'
        ),

        array(
            'module' => 'Employees',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'test Employees',
            'file' => 'custom/Extension/modules/Employees/hook.php',
            'class' => 'hook_employees',
            'function' => 'test_employees'
        ),

        array(
            'module' => 'OPS_personne_morale',
            'hook' => 'after_retrieve',
            'order' => '',
            'description' => 'Affichage des champs HTML',
            'file' => 'modules/OPS_personne_morale/hook.php',
            'class' => 'hook_personne_morale',
            'function' => 'display_personne_morale'
        ),

        array(
            'module' => 'OPS_personne_morale',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Initialisation du numéro de tiers',
            'file' => 'modules/OPS_personne_morale/hook.php',
            'class' => 'hook_personne_morale',
            'function' => 'set_num_tiers'
        ),

        array(
            'module' => 'OPS_personne_morale',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Initialisation de la categorie pse et la nature juridique pse',
            'file' => 'modules/OPS_personne_morale/hook.php',
            'class' => 'hook_personne_morale',
            'function' => 'set_categorie_nature_juridique_pse'
        ),

        array(
            'module' => 'OPS_personne_morale',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Fusion des relations lors de la fusion',
            'file' => 'modules/OPS_personne_morale/hook.php',
            'class' => 'hook_personne_morale',
            'function' => 'fusionPersonneMorale'
        ),

        ///////////////// HOOKS CLEANUP /////////////////      
        // Hook suppression des détails journal before_delete journal
        array(
            'module' => 'OPS_journal',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des détails journal',
            'file' => 'modules/OPS_journal/hook.php',
            'class' => 'hook_journal',
            'function' => 'delete_journal_details'
        ),

        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des objets liés - [OPS_dossier]',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'delete_related_relations'
        ),

        array(
            'module' => 'OPS_dossier',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Notification suppression brouillon',
            'file' => 'modules/OPS_dossier/hook.php',
            'class' => 'hook_dossier',
            'function' => 'notification_suppression_brouillon'
        ),

        array(
            'module' => 'OPS_generateur_vue',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des objets liés - [OPS_generateur_vue]',
            'file' => 'modules/OPS_generateur_vue/hook.php',
            'class' => 'hook_generateur_vue',
            'function' => 'delete_related_relations'
        ),

        array(
            'module' => 'OPS_generateur_referentiel',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Vérification de existance du bean dans les vues avant suppression',
            'file' => 'modules/OPS_generateur_referentiel/hook.php',
            'class' => 'hook_generateur_referentiel',
            'function' => 'verification_suppression'
        ),

        array(
            'module' => 'OPS_generateur_champ',
            'hook' => 'after_relationship_add',
            'order' => '',
            'description' => 'Vérification si le champ est utilisé dans un formulaire',
            'file' => 'modules/OPS_generateur_champ/hook.php',
            'class' => 'hook_generateur_champ',
            'function' => 'check_utilise'
        ),

        array(
            'module' => 'OPS_generateur_champ',
            'hook' => 'after_relationship_delete',
            'order' => '',
            'description' => 'Vérification si le champ est utilisé dans un formulaire',
            'file' => 'modules/OPS_generateur_champ/hook.php',
            'class' => 'hook_generateur_champ',
            'function' => 'check_utilise'
        ),

        // Hook suppression des élements flux before_delete flux
        array(
            'module' => 'OPS_flux',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des élements flux',
            'file' => 'modules/OPS_flux/hook.php',
            'class' => 'hook_flux',
            'function' => 'delete_flux_elements'
        ),

        array(
            'module' => 'OPS_onglet_securitygroups',
            'hook' => 'after_relationship_delete',
            'order' => '',
            'description' => 'Suppression du bean après suppression de la relation',
            'file' => 'modules/OPS_onglet_securitygroups/hook.php',
            'class' => 'hook_onglet_securitygroups',
            'function' => 'delete_bean'
        ),
        array(
            'module' => 'OPS_dashlet_onglet',
            'hook' => 'after_relationship_delete',
            'order' => '',
            'description' => 'Suppression du bean après suppression de la relation',
            'file' => 'modules/OPS_dashlet_onglet/hook.php',
            'class' => 'hook_dashlet_onglet',
            'function' => 'delete_bean'
        ),

        // Hook suppression des etapes et des statuts before_delete guide d'instrcution
        array(
            'module' => 'OPS_guide_instruction',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des élements flux',
            'file' => 'modules/OPS_guide_instruction/hook.php',
            'class' => 'hook_guide_instruction',
            'function' => 'deleteEtapesAndStatuts'
        ),

        array(
            'module' => 'OPS_justificatif',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression du justificatif',
            'file' => 'modules/OPS_justificatif/hook.php',
            'class' => 'hook_justificatif',
            'function' => 'justificatif_delete'
        ),

        array(
            'module' => 'OPS_type_personne',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des relation intermédiaire avec type document',
            'file' => 'modules/OPS_type_personne/hook.php',
            'class' => 'hook_type_personne',
            'function' => 'deleteRelation'
        ),

        array(
            'module' => 'OPS_generateur_formulaire',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des relation intermédiaire avec générateur formulaire',
            'file' => 'modules/OPS_generateur_formulaire/hook.php',
            'class' => 'hook_generateur_formulaire',
            'function' => 'deleteRelation'
        ),

        array(
            'module' => 'OPS_type_document',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des relation intermédiaire avec type tiers',
            'file' => 'modules/OPS_type_document/hook.php',
            'class' => 'hook_type_document',
            'function' => 'deleteRelation'
        ),

        // Relation individu / personne morale 
        array(
            'module' => 'OPS_personne_morale_individu',
            'hook' => 'before_save',
            'order' => '',
            'description' => 'Initialisation de l individu pour la RGPD',
            'file' => 'modules/OPS_personne_morale_individu/hook.php',
            'class' => 'hook_personne_morale_individu',
            'function' => 'init_individu'
        ),

        array(
            'module' => 'OPS_personne_morale',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des relation intermédiaire avec individu',
            'file' => 'modules/OPS_personne_morale/hook.php',
            'class' => 'hook_personne_morale',
            'function' => 'deleteRelation'
        ),

        array(
            'module' => 'OPS_individu',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Suppression des relation intermédiaire avec personne morale',
            'file' => 'modules/OPS_individu/hook.php',
            'class' => 'hook_individu',
            'function' => 'deleteRelation'
        ),

        array(
            'module' => 'OPS_individu',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Change la civilite de l individu en fonction de son type',
            'file' => 'modules/OPS_individu/hook.php',
            'class' => 'hook_individu',
            'function' => 'set_civilite'
        ),

        array(
            'module' => 'OPS_calendrier_garde',
            'hook' => 'after_relationship_delete',
            'order' => '',
            'description' => 'Supprime le calendrier si aucune famille est liée avec',
            'file' => 'modules/OPS_calendrier_garde/hook.php',
            'class' => 'hook_calendrier_garde',
            'function' => 'delete_calendrier'
        ),

        array(
            'module' => 'Documents',
            'hook' => 'before_save',
            'order' => '6',
            'description' => 'description',
            'file' => 'custom/modules/Documents/LogicHooks/HookDocument.php',
            'class' => 'HookDocument',
            'function' => 'sendNotification'
        ),
        array(
            'module' => 'Documents',
            'hook' => 'process_record',
            'order' => '',
            'description' => 'Initialisation du badge statut avec sa couleur',
            'file' => 'custom/modules/Documents/LogicHooks/HookDocument.php',
            'class' => 'HookDocument',
            'function' => 'initBadge'
        ),

        array(
            'module' => 'OPS_etape',
            'hook' => 'after_retrieve',
            'order' => '',
            'description' => 'affichage html',
            'file' => 'modules/OPS_etape/hook.php',
            'class' => 'hook_etape',
            'function' => 'display_etape'
        ),

        array(
            'module' => 'OPS_etape',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'Lors de la suppression de l étape, nous récupérons tout les dossiers lié à celle-ci pour leur attribué leur ancienne étape',
            'file' => 'modules/OPS_etape/hook.php',
            'class' => 'hook_etape',
            'function' => 'replace_etape'
        ),

        array(
            'module' => 'OPS_classement_type',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'suppression des classements type et des niveaux liés',
            'file' => 'modules/OPS_classement_type/hook.php',
            'class' => 'hook_classement_type',
            'function' => 'deleteRelationClassementType'
        ),
        array(
            'module' => 'OPS_niveau_1',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'suppression des niveaux 1 et des niveaux 2 liés',
            'file' => 'modules/OPS_niveau_1/hook.php',
            'class' => 'hook_niveau_1',
            'function' => 'deleteRelationNiveau1'
        ),
        array(
            'module' => 'OPS_niveau_2',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'suppression des niveaux 2 et des niveaux 3 liés',
            'file' => 'modules/OPS_niveau_2/hook.php',
            'class' => 'hook_niveau_2',
            'function' => 'deleteRelationNiveau2'
        ),
        array(
            'module' => 'OPS_niveau_3',
            'hook' => 'before_delete',
            'order' => '',
            'description' => 'suppression des niveaux 3 et des niveaux 4 liés',
            'file' => 'modules/OPS_niveau_3/hook.php',
            'class' => 'hook_niveau_3',
            'function' => 'deleteRelationNiveau3'
        ),
        //conversation
        array(
            'module' => 'OPS_dossier',
            'hook' => 'after_ui_frame',
            'order' => '',
            'description' => 'Prépare la zone de contenu de la vue détail dossier pour le nouvel onglet.',
            'file' => 'modules/OPS_conversation/hook.php',
            'class' => 'hook_conversation',
            'function' => 'prepare_after_ui_frame'
        ),

        array(
                'module' => 'OPS_dossier',
                'hook' => 'before_delete',
                'order' => '',
                'description' => 'Suppression des messages de la conversation',
                'file' => 'modules/OPS_conversation/hook.php',
                'class' => 'hook_conversation',
                'function' => 'delete_messages_conversation'
        ),
        // fin conversation
        array(
                'module' => 'OPS_dossier',
                'hook' => 'process_record',
                'order' => '',
                'description' => 'Calcul du délai des dossiers en fonction de l étape',
                'file' => 'modules/OPS_dossier/hook.php',
                'class' => 'hook_dossier',
                'function' => 'process_delai'
        ),
    ),

    'entrypoints' => array(
        array(
            'from' => '<basepath>/custom/application/Ext/EntryPoinyRegistry/entry_point_registry_core.php',
            'to_module' => 'application'
        )
    ),

    'beans' => array(
        array(
            'module' => 'OPS_registre_suppression_dossier',
            'class' => 'OPS_registre_suppression_dossier',
            'path' => 'modules/OPS_registre_suppression_dossier/OPS_registre_suppression_dossier.php',
            'tab' => true,
        ),
        array (
            'module' => 'OPS_justificatif_historisation',
            'class' => 'OPS_justificatif_historisation',
            'path' => 'modules/OPS_justificatif_historisation/OPS_justificatif_historisation.php',
            'tab' => false,
        ),
        array(
            'module' => 'OPS_dispositif',
            'class' => 'OPS_dispositif',
            'path' => 'modules/OPS_dispositif/OPS_dispositif.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_statut',
            'class' => 'OPS_statut',
            'path' => 'modules/OPS_statut/OPS_statut.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_etape',
            'class' => 'OPS_etape',
            'path' => 'modules/OPS_etape/OPS_etape.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_guide_instruction',
            'class' => 'OPS_guide_instruction',
            'path' => 'modules/OPS_guide_instruction/OPS_guide_instruction.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_formule',
            'class' => 'OPS_formule',
            'path' => 'modules/OPS_formule/OPS_formule.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_appairage',
            'class' => 'OPS_appairage',
            'path' => 'modules/OPS_appairage/OPS_appairage.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_individu',
            'class' => 'OPS_individu',
            'path' => 'modules/OPS_individu/OPS_individu.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_historisation',
            'class' => 'OPS_historisation',
            'path' => 'modules/OPS_historisation/OPS_historisation.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_type_document',
            'class' => 'OPS_type_document',
            'path' => 'modules/OPS_type_document/OPS_type_document.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_action_statut',
            'class' => 'OPS_action_statut',
            'path' => 'modules/OPS_action_statut/OPS_action_statut.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_journal',
            'class' => 'OPS_journal',
            'path' => 'modules/OPS_journal/OPS_journal.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_journal_detail',
            'class' => 'OPS_journal_detail',
            'path' => 'modules/OPS_journal_detail/OPS_journal_detail.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_dossier',
            'class' => 'OPS_dossier',
            'path' => 'modules/OPS_dossier/OPS_dossier.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_integrites',
            'class' => 'OPS_integrites',
            'path' => 'modules/OPS_integrites/OPS_integrites.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_integrites_req',
            'class' => 'OPS_integrites_req',
            'path' => 'modules/OPS_integrites_req/OPS_integrites_req.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_connecteur',
            'class' => 'OPS_connecteur',
            'path' => 'modules/OPS_connecteur/OPS_connecteur.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_flux_element',
            'class' => 'OPS_flux_element',
            'path' => 'modules/OPS_flux_element/OPS_flux_element.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_flux',
            'class' => 'OPS_flux',
            'path' => 'modules/OPS_flux/OPS_flux.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_territoire',
            'class' => 'OPS_territoire',
            'path' => 'modules/OPS_territoire/OPS_territoire.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_type_territoire',
            'class' => 'OPS_type_territoire',
            'path' => 'modules/OPS_type_territoire/OPS_type_territoire.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_sous_territoire',
            'class' => 'OPS_sous_territoire',
            'path' => 'modules/OPS_sous_territoire/OPS_sous_territoire.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_habilitation_dispositif',
            'class' => 'OPS_habilitation_dispositif',
            'path' => 'modules/OPS_habilitation_dispositif/OPS_habilitation_dispositif.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_habilitation_etape',
            'class' => 'OPS_habilitation_etape',
            'path' => 'modules/OPS_habilitation_etape/OPS_habilitation_etape.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_dashlet',
            'class' => 'OPS_dashlet',
            'path' => 'modules/OPS_dashlet/OPS_dashlet.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_dashlet_onglet',
            'class' => 'OPS_dashlet_onglet',
            'path' => 'modules/OPS_dashlet_onglet/OPS_dashlet_onglet.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_onglet',
            'class' => 'OPS_onglet',
            'path' => 'modules/OPS_onglet/OPS_onglet.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_onglet_securitygroups',
            'class' => 'OPS_onglet_securitygroups',
            'path' => 'modules/OPS_onglet_securitygroups/OPS_onglet_securitygroups.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_generateur_vue',
            'class' => 'OPS_generateur_vue',
            'path' => 'modules/OPS_generateur_vue/OPS_generateur_vue.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_generateur_onglet',
            'class' => 'OPS_generateur_onglet',
            'path' => 'modules/OPS_generateur_onglet/OPS_generateur_onglet.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_generateur_champ',
            'class' => 'OPS_generateur_champ',
            'path' => 'modules/OPS_generateur_champ/OPS_generateur_champ.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_generateur_referentiel',
            'class' => 'OPS_generateur_referentiel',
            'path' => 'modules/OPS_generateur_referentiel/OPS_generateur_referentiel.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_generateur_version',
            'class' => 'OPS_generateur_version',
            'path' => 'modules/OPS_generateur_version/OPS_generateur_version.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_generateur_formulaire',
            'class' => 'OPS_generateur_formulaire',
            'path' => 'modules/OPS_generateur_formulaire/OPS_generateur_formulaire.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_historique_connexion',
            'class' => 'OPS_historique_connexion',
            'path' => 'modules/OPS_historique_connexion/OPS_historique_connexion.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_personne_morale',
            'class' => 'OPS_personne_morale',
            'path' => 'modules/OPS_personne_morale/OPS_personne_morale.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_type_personne',
            'class' => 'OPS_type_personne',
            'path' => 'modules/OPS_type_personne/OPS_type_personne.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_suivi_dossier',
            'class' => 'OPS_suivi_dossier',
            'path' => 'modules/OPS_suivi_dossier/OPS_suivi_dossier.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_personne_morale_individu',
            'class' => 'OPS_personne_morale_individu',
            'path' => 'modules/OPS_personne_morale_individu/OPS_personne_morale_individu.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_type_personne_type_document',
            'class' => 'OPS_type_personne_type_document',
            'path' => 'modules/OPS_type_personne_type_document/OPS_type_personne_type_document.php',
            'tab' => true
        ),

        array(
            'module' => 'OPS_justificatif',
            'class' => 'OPS_justificatif',
            'path' => 'modules/OPS_justificatif/OPS_justificatif.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_commission',
            'class' => 'OPS_commission',
            'path' => 'modules/OPS_commission/OPS_commission.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_elu',
            'class' => 'OPS_elu',
            'path' => 'modules/OPS_elu/OPS_elu.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_rapport',
            'class' => 'OPS_rapport',
            'path' => 'modules/OPS_rapport/OPS_rapport.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_reunion',
            'class' => 'OPS_reunion',
            'path' => 'modules/OPS_reunion/OPS_reunion.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_action_retarde',
            'class' => 'OPS_action_retarde',
            'path' => 'modules/OPS_action_retarde/OPS_action_retarde.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_type_traitement',
            'class' => 'OPS_type_traitement',
            'path' => 'modules/OPS_type_traitement/OPS_type_traitement.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_type_traitement_etapes',
            'class' => 'OPS_type_traitement_etapes',
            'path' => 'modules/OPS_type_traitement_etapes/OPS_type_traitement_etapes.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_traitement',
            'class' => 'OPS_traitement',
            'path' => 'modules/OPS_traitement/OPS_traitement.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_traitement_valeurs',
            'class' => 'OPS_traitement_valeurs',
            'path' => 'modules/OPS_traitement_valeurs/OPS_traitement_valeurs.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_traitement_historique',
            'class' => 'OPS_traitement_historique',
            'path' => 'modules/OPS_traitement_historique/OPS_traitement_historique.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_lien_parente',
            'class' => 'OPS_lien_parente',
            'path' => 'modules/OPS_lien_parente/OPS_lien_parente.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_information_fiscale',
            'class' => 'OPS_information_fiscale',
            'path' => 'modules/OPS_information_fiscale/OPS_information_fiscale.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_historique_adresse',
            'class' => 'OPS_historique_adresse',
            'path' => 'modules/OPS_historique_adresse/OPS_historique_adresse.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_domiciliation',
            'class' => 'OPS_domiciliation',
            'path' => 'modules/OPS_domiciliation/OPS_domiciliation.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_calendrier_garde',
            'class' => 'OPS_calendrier_garde',
            'path' => 'modules/OPS_calendrier_garde/OPS_calendrier_garde.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_classement',
            'class' => 'OPS_classement',
            'path' => 'modules/OPS_classement/OPS_classement.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_classement_type',
            'class' => 'OPS_classement_type',
            'path' => 'modules/OPS_classement_type/OPS_classement_type.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_niveau_1',
            'class' => 'OPS_niveau_1',
            'path' => 'modules/OPS_niveau_1/OPS_niveau_1.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_niveau_2',
            'class' => 'OPS_niveau_2',
            'path' => 'modules/OPS_niveau_2/OPS_niveau_2.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_niveau_3',
            'class' => 'OPS_niveau_3',
            'path' => 'modules/OPS_niveau_3/OPS_niveau_3.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_niveau_4',
            'class' => 'OPS_niveau_4',
            'path' => 'modules/OPS_niveau_4/OPS_niveau_4.php',
            'tab' => true
        ),
        array(
            'module' => 'OPS_template_sms',
            'class' => 'OPS_template_sms',
            'path' => 'modules/OPS_template_sms/OPS_template_sms.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_liste_referentiel',
            'class' => 'OPS_liste_referentiel',
            'path' => 'modules/OPS_liste_referentiel/OPS_liste_referentiel.php',
            'tab' => true,
        ),
        array(
            'module' => 'OPS_liste_valeur',
            'class' => 'OPS_liste_valeur',
            'path' => 'modules/OPS_liste_valeur/OPS_liste_valeur.php',
            'tab' => true,
        ),
        array (
            'module' => 'OPS_conversation',
            'class' => 'OPS_conversation',
            'path' => 'modules/OPS_conversation/OPS_conversation.php',
            'tab' => false,
        ),
        array(
            'module' => 'OPS_modele_document',
            'class' => 'OPS_modele_document',
            'path' => 'modules/OPS_modele_document/OPS_modele_document.php',
            'tab' => true
        )
    ),

    'copy' => array(
        //Rapport
        array(
            'from' => '<basepath>/OverWrite/modules/AOW_WorkFlow/',
            'to' => 'modules/AOW_WorkFlow/'
        ),
        array(
            'from' => '<basepath>/OverWrite/modules/AOR_Reports/',
            'to' => 'modules/AOR_Reports/'
        ),
        array(
            'from' => '<basepath>/OverWrite/modules/AOR_Conditions/',
            'to' => 'modules/AOR_Conditions/'
        ),
        array(
            'from' => '<basepath>/OverWrite/modules/AOR_Fields/',
            'to' => 'modules/AOR_Fields/'
        ),
        array(
            'from' => '<basepath>/Fields/Ops_bool',
            'to' => 'custom/include/SugarFields/Fields/Ops_bool/'
        ),


        array(
            'from' => '<basepath>/SugarModules/modules/',
            'to' => 'modules/'
        ),

        array(
            'from' => '<basepath>/Fields/ColourPicker/TemplateColourPicker.php',
            'to' => 'custom/modules/DynamicFields/templates/Fields/ColourPicker/TemplateColourPicker.php'
        ),

        array(
            'from' => '<basepath>/Fields/ColourPicker',
            'to' => 'custom/include/SugarFields/Fields/ColourPicker/'
        ),
        array(
            'from' => '<basepath>/Fields/Icone/TemplateIcone.php',
            'to' => 'custom/modules/DynamicFields/templates/Fields/Icone/TemplateIcone.php'
        ),

        array(
            'from' => '<basepath>/Fields/Icone',
            'to' => 'custom/include/SugarFields/Fields/Icone/'
        ),

        array(
            'from' => '<basepath>/Fields/CheckboxMultienum',
            'to' => 'custom/include/SugarFields/Fields/CheckboxMultienum/'
        ),
        array(
            'from' => '<basepath>/Fields/Address',
            'to' => 'custom/include/SugarFields/Fields/Address/'
        ),

        array(
            'from' => '<basepath>/custom/include/javascript/bootstrap-inputmask.js',
            'to' => 'custom/include/javascript/bootstrap-inputmask.js'
        ),

        array(
            'from' => '<basepath>/custom/include/javascript/math.js',
            'to' => 'custom/include/javascript/math.js'
        ),

        array(
            'from' => '<basepath>/custom/include/javascript/autonumeric.js',
            'to' => 'custom/include/javascript/autonumeric.js'
        ),

        array(
            'from' => '<basepath>/custom/include/javascript/jquery.inputmask.bundle.js',
            'to' => 'custom/include/javascript/jquery.inputmask.bundle.js'
        ),

        array(
            'from' => '<basepath>/custom/include/javascript/fullcalendar/',
            'to' => 'custom/include/javascript/fullcalendar/'
        ),


        // A revoir
        array(
            'from' => '<basepath>/custom/Extension/modules/Documents',
            'to' => 'custom/Extension/modules/Documents'
        ),

        array(
            'from' => '<basepath>/custom/modules/Employees',
            'to' => 'custom/Extension/modules/Employees'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/Calls/language',
            'to' => 'custom/Extension/modules/Calls/Ext/Language'
        ),

        array(
            'from' => '<basepath>/custom/modules/Documents',
            'to' => 'custom/modules/Documents'
        ),

        array(
            'from' => '<basepath>/custom/modules/Tasks',
            'to' => 'custom/modules/Tasks'
        ),

        array(
            'from' => '<basepath>/custom/modules/Meetings',
            'to' => 'custom/modules/Meetings'
        ),

        array(
            'from' => '<basepath>/custom/modules/Calls',
            'to' => 'custom/modules/Calls'
        ),

        array(
            'from' => '<basepath>/custom/modules/Employees',
            'to' => 'custom/modules/Employees'
        ),
        array(
            'from' => '<basepath>/custom/modules/Users',
            'to' => 'custom/Extension/modules/Users'
        ),
        array(
            'from' => '<basepath>/custom/Extension/modules/SecurityGroups',
            'to' => 'custom/Extension/modules/SecurityGroups'
        ),
        array(
            'from' => '<basepath>/custom/modules/Users/Menu.php',
            'to' => 'modules/Users/Menu.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Users/',
            'to' => 'custom/modules/Users/'
        ),
        array(
            'from' => '<basepath>/custom/modules/Users/DetailView.js',
            'to' => 'modules/Users/DetailView.js'
        ),
        // Surcharge pour trier les listes déroulantes 
        array(
            'from' => '<basepath>/custom/modules/EmailTemplates/',
            'to' => 'custom/modules/EmailTemplates/'
        ),

        /* ----- Ces fichiers écrase le core SuiteCRM ----- */
        // Implementation des actions par lot  
        array(
            'from' => '<basepath>/OverWrite/include/ListView/ListViewDisplay.php',
            'to' => 'include/ListView/ListViewDisplay.php'
        ),

        // Modification de la place du symbole - CHAMP CURRENCY => fonction format_place_symbol 

        array(
            'from' => '<basepath>/OverWrite/modules/Currencies/Currency.php',
            'to' => 'modules/Currencies/Currency.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/modules/Tasks/Save.php',
            'to' => 'modules/Tasks/Save.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/modules/Tasks/metadata/subpanels/ForActivities.php',
            'to' => 'modules/Tasks/metadata/subpanels/ForActivities.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/include/SugarFields/Fields/Currency/ListView.tpl',
            'to' => 'include/SugarFields/Fields/Currency/ListView.tpl'
        ),

        array(
            'from' => '<basepath>/OverWrite/include/SugarFields/Fields/Link/ListView.tpl',
            'to' => 'include/SugarFields/Fields/Link/ListView.tpl'
        ),

        // Ajout du type URL et VARCHAR
        array(
            'from' => '<basepath>/OverWrite/include/MassUpdate.php',
            'to' => 'include/MassUpdate.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/include/UploadFile.php',
            'to' => 'include/UploadFile.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/include/generic/SugarWidgets/',
            'to' => 'include/generic/SugarWidgets/'
        ),
        // Image sur le coté du module OPS_individu et OPS_personne_morale
        array(
            'from' => '<basepath>/OverWrite/include/MVC/View/SugarView.php',
            'to' => 'include/MVC/View/SugarView.php'
        ),
        //Nombre d'éléments dans un sous-panel
        array(
            'from' => '<basepath>/OverWrite/include/SubPanel/',
            'to' => 'include/SubPanel/'
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/SuiteP/include/SubPanel/tpls/SubPanelTiles.tpl',
            'to' => 'themes/SuiteP/include/SubPanel/tpls/SubPanelTiles.tpl'
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/SuiteP/tpls/_headerModuleList.tpl',
            'to' => 'themes/SuiteP/tpls/_headerModuleList.tpl'
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/OEPLTheme/themedef.php',
            'to' => 'themes/OEPLTheme/themedef.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/OEPLTheme/include/SubPanel/tpls/SubPanelTiles.tpl',
            'to' => 'themes/OEPLTheme/include/SubPanel/tpls/SubPanelTiles.tpl'
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/OEPLTheme/tpls/_headerModuleList.tpl',
            'to' => 'themes/OEPLTheme/tpls/_headerModuleList.tpl'
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/OEPLTheme/include/DetailView/actions_buttons.tpl',
            'to' => 'themes/OEPLTheme/include/DetailView/actions_buttons.tpl'
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/OEPLTheme/include/EditView/actions_buttons.tpl',
            'to' => 'themes/OEPLTheme/include/EditView/actions_buttons.tpl'
        ),
        //Modèle d'email
        array(
            'from' => '<basepath>/OverWrite/modules/EmailTemplates/',
            'to' => 'modules/EmailTemplates/'
        ),
        array(
            'from' => '<basepath>/OverWrite/modules/AOS_PDF_Templates/',
            'to' => 'modules/AOS_PDF_Templates/'
        ),

        array(
            'from' => '<basepath>/OverWrite/modules/Home/',
            'to' => 'modules/Home/'
        ),
        array(
            'from' => '<basepath>/OverWrite/modules/Documents/',
            'to' => 'modules/Documents/'
        ),

        array(
            'from' => '<basepath>/OverWrite/modules/DocumentRevisions/',
            'to' => 'modules/DocumentRevisions/'
        ),

        array(
            'from' => '<basepath>/OverWrite/modules/Studio/',
            'to' => 'modules/Studio/'
        ),

        array(
            'from' => '<basepath>/OverWrite/modules/MergeRecords/',
            'to' => 'modules/MergeRecords/'
        ),

        // Correction json des popup filtre
        array(
            'from' => '<basepath>/OverWrite/include/Popups/Popup_picker.php',
            'to' => 'include/Popups/Popup_picker.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/include/Popups/PopupSmarty.php',
            'to' => 'include/Popups/PopupSmarty.php'
        ),

        //Correction relation ops_dossier_ops_dossier
        array(
            'from' => '<basepath>/OverWrite/modules/Administration/',
            'to' => 'modules/Administration/'
        ),

        //Convertion des dates
        array(
            'from' => '<basepath>/OverWrite/include/TimeDate.php',
            'to' => 'include/TimeDate.php'
        ),
        // Désactivation de la possibilité de changer de moteur de recherche globale 
        array(
            'from' => '<basepath>/OverWrite/lib/Search/UI/SearchFormView.php',
            'to' => 'lib/Search/UI/SearchFormView.php'
        ),
        array(
            'from' => '<basepath>/OverWrite/ModuleInstall/ModuleInstaller.php',
            'to' => 'ModuleInstall/ModuleInstaller.php'
        ),

        // ENTRYPOINT
        array(
            'from' => '<basepath>/custom/entrypoints/',
            'to' => 'custom/entrypoints/'
        ),


        // Action EditView generateur flux
        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_flux/Ext/ActionViewMap/generateur.php',
            'to' => 'custom/Extension/modules/OPS_flux/Ext/ActionViewMap/generateur.php'
        ),

        // Images
        array(
            'from' => '<basepath>/custom/include/images',
            'to' => 'custom/include/images'
        ),

        // SugarWidgets
        array(
            'from' => '<basepath>/custom/include/generic/SugarWidgets',
            'to' => 'custom/include/generic/SugarWidgets'
        ),


        array(
            'from' => '<basepath>/custom/modules/Home/index.php',
            'to' => 'custom/modules/Home/index.php'
        ),

        array(
            'from' => '<basepath>/custom/include/generic/SugarWidgets',
            'to' => 'custom/include/generic/SugarWidgets'
        ),
        array(
            'from' => '<basepath>/custom/modules/SecurityGroups/',
            'to' => 'custom/modules/SecurityGroups/'
        ),
        array(
            'from' => '<basepath>/custom/modules/SecurityGroups/Menu.php',
            'to' => 'modules/SecurityGroups/Menu.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/ACLRoles/Menu.php',
            'to' => 'modules/ACLRoles/Menu.php'
        ),

        // Générateur de champs pour les formulaires
        array(
            'from' => '<basepath>/custom/include/Ode',
            'to' => 'custom/include/Ode'
        ),

        // Déclaration des actions 
        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_generateur_vue/Ext/ActionViewMap/generer.php',
            'to' => 'custom/Extension/modules/OPS_generateur_vue/Ext/ActionViewMap/generer.php'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_generateur_vue/Ext/ActionViewMap/genere.php',
            'to' => 'custom/Extension/modules/OPS_generateur_vue/Ext/ActionViewMap/genere.php'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_generateur_formulaire/Ext/ActionViewMap/importer.php',
            'to' => 'custom/Extension/modules/OPS_generateur_formulaire/Ext/ActionViewMap/importer.php'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_generateur_referentiel/Ext/ActionViewMap/importer.php',
            'to' => 'custom/Extension/modules/OPS_generateur_referentiel/Ext/ActionViewMap/importer.php'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/create.php',
            'to' => 'custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/create.php'
        ),
        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/choix_demandeur.php',
            'to' => 'custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/choix_demandeur.php'
        ),
        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/choix_dispositif.php',
            'to' => 'custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/choix_dispositif.php'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/modifier.php',
            'to' => 'custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/modifier.php'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/geoloc.php',
            'to' => 'custom/Extension/modules/OPS_dossier/Ext/ActionViewMap/geoloc.php'
        ),

        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_generateur_formulaire/Ext/ActionViewMap/generer.php',
            'to' => 'custom/Extension/modules/OPS_generateur_formulaire/Ext/ActionViewMap/generer.php'
        ),

        // ODE Helpers
        array(
            'from' => '<basepath>/custom/include/helpers',
            'to' => 'custom/include/helpers'
        ),

        // Libs
        array(
            'from' => '<basepath>/custom/include/libs',
            'to' => 'custom/include/libs'
        ),

        // CSS
        array(
            'from' => '<basepath>/custom/include/css',
            'to' => 'custom/include/css'
        ),


        // ODE GEOLOC / UIX - View Style :: GeoLoc
        /*
        array (
        'from' => '<basepath>/custom/include/css/geoloc.css',
        'to'   => 'custom/include/css/geoloc.css',
        'desc' => 'UIX for OPS_dossier (GeoLocalisation) - Map view & components'
        ),
        
        array (
        'from' => '<basepath>/custom/include/css/base-flex.css',
        'to'   => 'custom/include/css/base-flex.css',
        'desc' => 'UIX for OPS_dossier (GeoLocalisation) - Micro Bootsrap DFlex support'
        ),
        */

        // ODE GEOLOC / UIX - View Behaviors :: Geo
        array(
            'from' => '<basepath>/custom/include/javascript/jsonpath-0.8.0.js',
            'to' => 'custom/include/javascript/jsonpath-0.8.0.js',
            'desc' => 'JIA for OPS_dossier (GeoLocalisation) - Map Application JSON Path library'
        ),
        array(
            'from' => '<basepath>/custom/include/javascript/geoloc.js',
            'to' => 'custom/include/javascript/geoloc.js',
            'desc' => 'JIA for OPS_dossier (GeoLocalisation) - Map Application Behaviors runtime'
        ),
        array(
            'from' => '<basepath>/custom/include/javascript/cantons.js',
            'to' => 'custom/include/javascript/cantons.js',
            'desc' => 'JIA for OPS_dossier (GeoLocalisation) - Map Application SVG layering'
        ),



        // Import / export d'un guide d'instruction
        array(
            'from' => '<basepath>/custom/Extension/modules/OPS_guide_instruction/Ext/ActionViewMap',
            'to' => 'custom/Extension/modules/OPS_guide_instruction/Ext/ActionViewMap'
        ),

        // Prise en charge des modèle PDF - AOS_PDF_Templates
        array(
            'from' => '<basepath>/custom/Extension/modules/AOS_PDF_Templates/language',
            'to' => 'custom/Extension/modules/AOS_PDF_Templates/Ext/Language'
        ),
        array(
            'from' => '<basepath>/custom/Extension/modules/AOS_PDF_Templates/',
            'to' => 'custom/Extension/modules/AOS_PDF_Templates/Ext/Vardefs'
        ),
        array(
            'from' => '<basepath>/custom/modules/AOS_PDF_Templates/metadata',
            'to' => 'custom/modules/AOS_PDF_Templates/metadata'
        ),
        array(
            'from' => '<basepath>/custom/modules/AOS_PDF_Templates/OPS_generate_PDF.php',
            'to' => 'custom/modules/AOS_PDF_Templates/OPS_generate_PDF.php',
            'desc' => 'AOS_PDF_Templates Class (Générateur PDF des flux)'
        ),
        array(
            'from' => '<basepath>/custom/Extension/modules/EmailTemplates/language',
            'to' => 'custom/Extension/modules/EmailTemplates/Ext/Language'
        ),
        // Page administration
        array(
            'from' => '<basepath>/custom/modules/Administration/',
            'to' => 'custom/modules/Administration/'
        ),

        /* Nouveau theme */

        array(
            'from' => '<basepath>/themes/SuiteP/themedef.php',
            'to' => 'custom/themes/SuiteP/themedef.php'
        ),

        array(
            'from' => '<basepath>/themes/SuiteP/css/Lanteas',
            'to' => 'themes/SuiteP/css/Lanteas'
        ),

        array(
            'from' => '<basepath>/themes/OEPLTheme/css/Indigo',
            'to' => 'themes/OEPLTheme/css/Indigo'
        ),

        array(
            'from' => '<basepath>/themes/OEPLTheme/css/Brown',
            'to' => 'themes/OEPLTheme/css/Brown'
        ),

        array(
            'from' => '<basepath>/custom/Extension/application/Ext/Language/en_us.LanteasThemeLabel.php',
            'to' => 'custom/Extension/application/Ext/Language/en_us.LanteasThemeLabel.php'
        ),
        array(
            'from' => '<basepath>/custom/modules/Favorites/Dashlets/MesFavorisDashlet',
            'to' => 'modules/Favorites/Dashlets/MesFavorisDashlet',
        ),
        array(
            'from' => '<basepath>/custom/modules/Favorites/Dashlets/MesFavorisTuilesMiniDashlet',
            'to' => 'custom/modules/Favorites/Dashlets/MesFavorisTuilesMiniDashlet',
        ),
        // On ajoute les modules "Favorites" et "Tasks" à la variable $moduleList pour qu'il soit reconnu correctement par SuiteCRM et la page d'accueil
        array(
            'from' => '<basepath>/custom/Extension/application/Ext/Include/OPS_moduleList.php',
            'to' => 'custom/Extension/application/Ext/Include/OPS_moduleList.php',
        ),
        array(
            'from' => '<basepath>/custom/Extension/modules/Favorites/Ext/Language/fr_FR.Favorites.php',
            'to' => 'custom/Extension/modules/Favorites/Ext/Language/fr_FR.Favorites.php',
        ),
        // On ajoute le bridage de la page d'accueil sur les tpls gérants la page d'accueil (NON UPGRADE SAFE)
        array(
            'from' => '<basepath>/OverWrite/themes/SuiteP/include/Dashlets/DashletHeader.tpl',
            'to' => 'themes/SuiteP/include/Dashlets/DashletHeader.tpl',
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/SuiteP/include/MySugar/',
            'to' => 'themes/SuiteP/include/MySugar/',
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/OEPLTheme/include/Dashlets/DashletHeader.tpl',
            'to' => 'themes/OEPLTheme/include/Dashlets/DashletHeader.tpl',
        ),
        array(
            'from' => '<basepath>/OverWrite/themes/OEPLTheme/include/MySugar/',
            'to' => 'themes/OEPLTheme/include/MySugar/',
        ),
        // Refonte graphique des Dashlets
        array(
            'from' => '<basepath>/themes/SuiteP/include/Dashlets/dashlets.css',
            'to' => 'themes/SuiteP/include/Dashlets/dashlets.css',
        ),
        // On surcharge le champ de type "Enumération" pour ajouter un tri alphabétique sur les valeurs
        array(
            'from' => '<basepath>/custom/include/generic/SugarWidgets/SugarWidgetFieldenum.php',
            'to' => 'custom/include/generic/SugarWidgets/SugarWidgetFieldenum.php',
        ),
        // On écrase le fichier meta du dashlet standard pour rajouter un flag "hidden" permettant de cacher le dashlet dans la liste des dashlets disponibles
        array(
            'from' => '<basepath>/custom/modules/Favorites/Dashlets/FavoritesDashlet/FavoritesDashlet.meta.php',
            'to' => 'modules/Favorites/Dashlets/FavoritesDashlet/FavoritesDashlet.meta.php',
        ),
        // Ajout de OPS_habilitation_dispositif dans les exceptions pour SecurityGroup
        array(
            'from' => '<basepath>/OverWrite/data/Relationships/M2MRelationship.php',
            'to' => 'data/Relationships/M2MRelationship.php'
        ),

        /* ----------------------------------------------------- */
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_type_traitement',
            'to' => 'modules/OPS_type_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_type_traitement_etapes',
            'to' => 'modules/OPS_type_traitement_etapes',
        ),
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_traitement',
            'to' => 'modules/OPS_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_traitement_valeurs',
            'to' => 'modules/OPS_traitement_valeurs',
        ),
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_traitement_historique',
            'to' => 'modules/OPS_traitement_historique',
        ),
        array(
            'from' => '<basepath>/custom/include/Ode/Traitements',
            'to' => 'custom/include/Ode/Traitements',
        ),
        array(
            'from' => '<basepath>/custom/include/Ode/Fonctions',
            'to' => 'custom/include/Ode/Fonctions',
        ),
        array(
            'from' => '<basepath>/custom/modules/Notes',
            'to' => 'custom/modules/Notes'
        ),
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_liste_referentiel',
            'to' => 'modules/OPS_liste_referentiel',
        ),
        array(
            'from' => '<basepath>/SugarModules/modules/OPS_liste_valeur',
            'to' => 'modules/OPS_liste_valeur',
        ),
        // Moteur de recherche custom OpenCRM
        array(
            'from' => '<basepath>/custom/Extension/SearchEngines',
            'to' => 'custom/Extension/SearchEngines',
        ),
        array(
            'from' => '<basepath>/custom/vendor',
            'to' => 'vendor'
        ), 
    ),

    'layoutdefs' => array(
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_reunion_ops_dossier_OPS_reunion.php',
            'to_module' => 'OPS_reunion'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_elu_ops_dossier_OPS_elu.php',
            'to_module' => 'OPS_elu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_commission_ops_dossier_OPS_commission.php',
            'to_module' => 'OPS_commission'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_etape_ops_statut_OPS_etape.php',
            'to_module' => 'OPS_etape'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_guide_instruction_ops_etape_OPS_guide_instruction.php',
            'to_module' => 'OPS_guide_instruction'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_individu_ops_appairage_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_individu_activities_calls_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_document_documents_OPS_type_document.php',
            'to_module' => 'OPS_type_document'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_document_ops_justificatif_OPS_type_document.php',
            'to_module' => 'OPS_type_document'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_action_statut_ops_statut_OPS_statut.php',
            'to_module' => 'OPS_statut'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_journal_detail_ops_journal_OPS_journal.php',
            'to_module' => 'OPS_journal'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_appairage_ops_journal_OPS_appairage.php',
            'to_module' => 'OPS_appairage'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_documents_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_ops_justificatif_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_justificatif_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_individu_documents_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_activities_calls_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_notes_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_notes_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_individu_ops_dossier_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_ops_appairage_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_historisation_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_historique_connexion_ops_individu_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_justificatif_historisation_ops_justificatif_OPS_justificatif.php',
            'to_module' => 'OPS_justificatif'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_integrites_req_ops_integrites_OPS_integrites.php',
            'to_module' => 'OPS_integrites'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_connecteur_ops_flux_OPS_connecteur.php',
            'to_module' => 'OPS_connecteur'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_flux_ops_flux_element_OPS_flux.php',
            'to_module' => 'OPS_flux'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_ops_journal_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_territoire_ops_type_territoire_OPS_type_territoire.php',
            'to_module' => 'OPS_type_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_territoire_users_Users.php',
            'to_module' => 'Users'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_territoire_users_OPS_territoire.php',
            'to_module' => 'OPS_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_sous_territoire_ops_territoire_OPS_territoire.php',
            'to_module' => 'OPS_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_sous_territoire_ops_territoire_OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_sous_territoire_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_sous_territoire_ops_dossier_OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_sous_territoire_ops_personne_morale_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_sous_territoire_ops_personne_morale_OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_habilitation_etape_ops_habilitation_dispositif_OPS_habilitation_dispositif.php',
            'to_module' => 'OPS_habilitation_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dashlet_onglet_ops_onglet_OPS_onglet.php',
            'to_module' => 'OPS_onglet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dashlet_onglet_ops_dashlet_OPS_dashlet.php',
            'to_module' => 'OPS_dashlet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_onglet_securitygroups_securitygroups_SecurityGroups.php',
            'to_module' => 'SecurityGroups'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_onglet_securitygroups_ops_onglet_OPS_onglet.php',
            'to_module' => 'OPS_onglet'
        ),
        /*
        array(
        'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_habilitation_dispositif_securitygroups_SecurityGroups.php',
        'to_module' => 'SecurityGroups'
        ),
        */
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_habilitation_dispositif_securitygroups_OPS_habilitation_dispositif.php',
            'to_module' => 'OPS_habilitation_dispositif'
        ),

        // Générateur de vue
        /*
        array (
        'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_generateur_vue_ops_generateur_onglet_OPS_generateur_vue.php',
        'to_module' => 'OPS_generateur_vue',
        ),
        */
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_generateur_vue_ops_dispositif_OPS_generateur_vue.php',
            'to_module' => 'OPS_generateur_vue'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_generateur_onglet_ops_generateur_champ_OPS_generateur_onglet.php',
            'to_module' => 'OPS_generateur_onglet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_generateur_version_ops_generateur_formulaire_OPS_generateur_formulaire.php',
            'to_module' => 'OPS_generateur_formulaire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_generateur_formulaire_ops_dispositif_OPS_generateur_formulaire.php',
            'to_module' => 'OPS_generateur_formulaire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_dossier_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_activities_calls_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_documents_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_appairage_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_journal_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_personne_ops_personne_morale_OPS_type_personne.php',
            'to_module' => 'OPS_type_personne'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_personne_ops_dispositif_OPS_type_personne.php',
            'to_module' => 'OPS_type_personne'
        ),
        /*array(
        'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_personne_ops_dispositif_OPS_dispositif.php',
        'to_module' => 'OPS_dispositif',
        ),*/
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_ops_suivi_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_individu_ops_personne_morale_individu_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_personne_morale_individu_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_document_ops_type_personne_type_document_OPS_type_document.php',
            'to_module' => 'OPS_type_document'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_dossier_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_traitement_ops_type_traitement_etapes_OPS_type_traitement.php',
            'to_module' => 'OPS_type_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_type_traitement_ops_traitement_OPS_type_traitement.php',
            'to_module' => 'OPS_type_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_traitement_ops_traitement_valeurs_OPS_traitement.php',
            'to_module' => 'OPS_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_traitement_ops_traitement_historique_OPS_traitement.php',
            'to_module' => 'OPS_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_lien_parente_ops_individu_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_historique_adresse_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_information_fiscale_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_personne_morale_ops_domiciliation_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_individu_ops_domiciliation_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_domiciliation_ops_appairage_OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation'
        ),
        
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_domiciliation_ops_journal_OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_classement_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_niveau_2_ops_niveau_1_OPS_niveau_1.php',
            'to_module' => 'OPS_niveau_1'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_niveau_3_ops_niveau_2_OPS_niveau_2.php',
            'to_module' => 'OPS_niveau_2'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_niveau_1_ops_classement_type_OPS_classement_type.php',
            'to_module' => 'OPS_classement_type'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_niveau_4_ops_niveau_3_OPS_niveau_3.php',
            'to_module' => 'OPS_niveau_3'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_liste_valeur_ops_liste_referentiel_OPS_liste_referentiel.php',
            'to_module' => 'OPS_liste_referentiel'
        ),
        array (
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_rapport_securitygroups_SecurityGroups.php',
            'to_module' => 'SecurityGroups',
        ),
        array (
            'from' => '<basepath>/SugarModules/relationships/layoutdefs/ops_rapport_securitygroups_OPS_rapport.php',
            'to_module' => 'OPS_rapport',
        ),
    ),

    'relationships' => array(
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_elu_ops_dossierMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_reunion_ops_dossierMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_commission_ops_dossierMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_etape_ops_statutMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_guide_instruction_ops_etapeMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_guide_instruction_ops_dispositifMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_ops_appairageMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_activities_emailsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_activities_callsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_activities_meetingsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_activities_notesMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_activities_tasksMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_document_documentsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_document_ops_justificatifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_document_ops_justificatif_historisationMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_action_statut_ops_statutMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_journal_detail_ops_journalMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_appairage_ops_journalMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_documentsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_ops_justificatifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_ops_justificatifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_documentsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_activities_callsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_activities_meetingsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_activities_notesMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_activities_tasksMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_activities_emailsMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_notesMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_notesMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dispositif_ops_dossierMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_ops_dossierMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_ops_appairageMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_historisation_ops_dossierMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_historique_connexion_ops_individuMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_justificatif_historisation_ops_justificatifMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_integrites_req_ops_integritesMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_connecteur_ops_fluxMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_flux_ops_flux_elementMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_ops_journalMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_territoire_ops_type_territoireMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_territoire_usersMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_sous_territoire_ops_territoireMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_sous_territoire_ops_dossierMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_sous_territoire_ops_personne_moraleMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_habilitation_dispositif_securitygroupsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_habilitation_dispositif_ops_dispositifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_habilitation_etape_ops_habilitation_dispositifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_habilitation_etape_ops_etapeMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dashlet_onglet_ops_ongletMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dashlet_onglet_ops_dashletMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_onglet_securitygroups_securitygroupsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_onglet_securitygroups_ops_ongletMetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_activities_callsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_activities_emailsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_activities_meetingsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_activities_notesMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_activities_tasksMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_documentsMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_ops_appairageMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_ops_journalMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_personne_ops_personne_moraleMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_personne_ops_individuMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_personne_ops_ops_dispositifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_ops_suivi_dossierMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_ops_personne_morale_individuMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_personne_ops_type_personne_type_documentMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_ops_personne_morale_individuMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_document_ops_type_personne_type_documentMetaData.php'
        ),

        // Générateur de vue
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_generateur_vue_ops_generateur_ongletMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_generateur_vue_ops_dispositifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_generateur_onglet_ops_generateur_champMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_generateur_version_ops_generateur_formulaireMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_generateur_formulaire_ops_dispositifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_dossier_ops_dossierMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_traitement_ops_type_traitement_etapesMetaData.php',
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_traitement_ops_traitementMetaData.php',
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_type_traitement_etapes_ops_traitementMetaData.php',
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_traitement_ops_traitement_valeursMetaData.php',
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_traitement_ops_traitement_historiqueMetaData.php',
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_lien_parente_ops_individuMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_lien_parente_ops_individu_2MetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_ops_information_fiscaleMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_ops_historique_adresseMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_ops_domiciliationMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_individu_ops_calendrier_gardeMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_personne_morale_individu_2_ops_calendrier_gardeMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_individu_ops_domiciliationMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_domiciliation_ops_appairageMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_domiciliation_ops_journalMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_classement_ops_dossierMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_niveau_2_ops_niveau_1MetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_niveau_3_ops_niveau_2MetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_niveau_1_ops_classement_typeMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_niveau_4_ops_niveau_3MetaData.php'
        ),

        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_liste_valeur_ops_liste_referentielMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/securitygroups_usersMetaData.php'
        ),
        array (
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_rapport_securitygroupsMetaData.php',
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_modele_document_ops_dispositifMetaData.php'
        ),
        array(
            'meta_data' => '<basepath>/SugarModules/relationships/relationships/ops_modele_document_ops_type_personneMetaData.php'
        ),
    ),

    'image_dir' => '<basepath>/icons',

    'language' => array(
        array(
            'from' => '<basepath>/custom/modules/Schedulers/language/fr_FR.lang.php',
            'to_module' => 'Schedulers',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_elu.php',
            'to_module' => 'OPS_elu',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_elu.php',
            'to_module' => 'OPS_elu',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_reunion.php',
            'to_module' => 'OPS_reunion',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_reunion.php',
            'to_module' => 'OPS_reunion',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_commission.php',
            'to_module' => 'OPS_commission',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_commission.php',
            'to_module' => 'OPS_commission',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_individu.php',
            'to_module' => 'OPS_individu',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_individu.php',
            'to_module' => 'OPS_individu',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Documents.php',
            'to_module' => 'Documents',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Documents.php',
            'to_module' => 'Documents',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/language/application/en_us.lang.php',
            'to_module' => 'application',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/language/application/fr_FR.lang.php',
            'to_module' => 'application',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Calls.php',
            'to_module' => 'Calls',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Calls.php',
            'to_module' => 'Calls',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Meetings.php',
            'to_module' => 'Meetings',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Meetings.php',
            'to_module' => 'Meetings',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Notes.php',
            'to_module' => 'Notes',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Notes.php',
            'to_module' => 'Notes',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dispositif.php',
            'to_module' => 'OPS_dispositif',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dispositif.php',
            'to_module' => 'OPS_dispositif',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Tasks.php',
            'to_module' => 'Tasks',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Tasks.php',
            'to_module' => 'Tasks',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Emails.php',
            'to_module' => 'Emails',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Emails.php',
            'to_module' => 'Emails',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_statut.php',
            'to_module' => 'OPS_statut',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_statut.php',
            'to_module' => 'OPS_statut',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_etape.php',
            'to_module' => 'OPS_etape',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_etape.php',
            'to_module' => 'OPS_etape',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_guide_instruction.php',
            'to_module' => 'OPS_guide_instruction',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_guide_instruction.php',
            'to_module' => 'OPS_guide_instruction',
            'language' => 'fr_FR'
        ),

        // Retrait de la création des champs => BUG 
        array(
            'from' => '<basepath>/Fields/ColourPicker/fr_FR.ColourPicker.php',
            'to_module' => 'ModuleBuilder',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/Fields/Icone/fr_FR.Icone.php',
            'to_module' => 'ModuleBuilder',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dispositif.php',
            'to_module' => 'OPS_dispositif',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dispositif.php',
            'to_module' => 'OPS_dispositif',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_appairage.php',
            'to_module' => 'OPS_appairage',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_appairage.php',
            'to_module' => 'OPS_appairage',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_historisation.php',
            'to_module' => 'OPS_historisation',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_historisation.php',
            'to_module' => 'OPS_historisation',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_document.php',
            'to_module' => 'OPS_type_document',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_document.php',
            'to_module' => 'OPS_type_document',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_action_statut.php',
            'to_module' => 'OPS_action_statut',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_action_statut.php',
            'to_module' => 'OPS_action_statut',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_journal_detail.php',
            'to_module' => 'OPS_journal_detail',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_journal_detail.php',
            'to_module' => 'OPS_journal_detail',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_journal.php',
            'to_module' => 'OPS_journal',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_journal.php',
            'to_module' => 'OPS_journal',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dossier.php',
            'to_module' => 'OPS_dossier',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dossier.php',
            'to_module' => 'OPS_dossier',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_integrites_req.php',
            'to_module' => 'OPS_integrites_req',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_integrites_req.php',
            'to_module' => 'OPS_integrites_req',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_integrites.php',
            'to_module' => 'OPS_integrites',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_integrites.php',
            'to_module' => 'OPS_integrites',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux.php',
            'to_module' => 'OPS_flux',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux.php',
            'to_module' => 'OPS_flux',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_connecteur.php',
            'to_module' => 'OPS_connecteur',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_connecteur.php',
            'to_module' => 'OPS_connecteur',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux_element.php',
            'to_module' => 'OPS_flux_element',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux_element.php',
            'to_module' => 'OPS_flux_element',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux_element.php',
            'to_module' => 'OPS_flux_element',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux_element.php',
            'to_module' => 'OPS_flux_element',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux.php',
            'to_module' => 'OPS_flux',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_flux.php',
            'to_module' => 'OPS_flux',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/language/application/fr_FR.lang.php',
            'to_module' => 'application',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/language/application/en_us.lang.php',
            'to_module' => 'application',
            'language' => 'en_us'
        ),

        array(
            'from' => '<basepath>/custom/modules/Administration/language/ops_admin.fr_FR.php',
            'to_module' => 'Administration',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/language/Users.php',
            'to_module' => 'Users',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/Users.php',
            'to_module' => 'Users',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_territoire.php',
            'to_module' => 'OPS_territoire',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_territoire.php',
            'to_module' => 'OPS_territoire',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_territoire.php',
            'to_module' => 'OPS_type_territoire',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_territoire.php',
            'to_module' => 'OPS_type_territoire',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_territoire.php',
            'to_module' => 'OPS_territoire',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_territoire.php',
            'to_module' => 'OPS_territoire',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_territoire.php',
            'to_module' => 'OPS_territoire',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_territoire.php',
            'to_module' => 'OPS_territoire',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/SecurityGroups.php',
            'to_module' => 'SecurityGroups',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/SecurityGroups.php',
            'to_module' => 'SecurityGroups',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_habilitation_dispositif.php',
            'to_module' => 'OPS_habilitation_dispositif',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_habilitation_dispositif.php',
            'to_module' => 'OPS_habilitation_dispositif',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_habilitation_etape.php',
            'to_module' => 'OPS_habilitation_etape',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_habilitation_etape.php',
            'to_module' => 'OPS_habilitation_etape',
            'language' => 'fr_FR'
        ),

        array(
            'from' => '<basepath>/SugarModules/modules/Administration/language/ops_admin.fr_FR.php',
            'to_module' => 'Administration',
            'language' => 'fr_FR'
        ),

        // Générateur de vue 
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_vue.php',
            'to_module' => 'OPS_generateur_vue',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_vue.php',
            'to_module' => 'OPS_generateur_vue',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_onglet.php',
            'to_module' => 'OPS_generateur_onglet',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_onglet.php',
            'to_module' => 'OPS_generateur_onglet',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_champ.php',
            'to_module' => 'OPS_generateur_champ',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_champ.php',
            'to_module' => 'OPS_generateur_champ',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_version.php',
            'to_module' => 'OPS_generateur_version',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_version.php',
            'to_module' => 'OPS_generateur_version',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_personne.php',
            'to_module' => 'OPS_type_personne',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_personne.php',
            'to_module' => 'OPS_type_personne',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_personne.php',
            'to_module' => 'OPS_type_personne',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_personne.php',
            'to_module' => 'OPS_type_personne',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_suivi_dossier.php',
            'to_module' => 'OPS_suivi_dossier',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_suivi_dossier.php',
            'to_module' => 'OPS_suivi_dossier',
            'language' => 'fr_FR'
        ),
        // Manquant , A revoir 
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_referentiel.php',
            'to_module' => 'OPS_generateur_referentiel',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_referentiel.php',
            'to_module' => 'OPS_generateur_referentiel',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_formulaire.php',
            'to_module' => 'OPS_generateur_formulaire',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_generateur_formulaire.php',
            'to_module' => 'OPS_generateur_formulaire',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_personne_morale_individu.php',
            'to_module' => 'OPS_personne_morale_individu',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_personne_morale_individu.php',
            'to_module' => 'OPS_personne_morale_individu',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_personne_type_document.php',
            'to_module' => 'OPS_type_personne_type_document',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_personne_type_document.php',
            'to_module' => 'OPS_type_personne_type_document',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_justificatif.php',
            'to_module' => 'OPS_justificatif',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_justificatif.php',
            'to_module' => 'OPS_justificatif',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_justificatif_historisation.php',
            'to_module' => 'OPS_justificatif_historisation',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_justificatif_historisation.php',
            'to_module' => 'OPS_justificatif_historisation',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/custom/modules/Administration/language/ops_admin.fr_FR.php',
            'to_module' => 'Administration',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/custom/modules/Schedulers/language/fr_FR.lang.php',
            'to_module' => 'Schedulers',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_traitement_etapes.php',
            'to_module' => 'OPS_type_traitement_etapes',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_traitement_etapes.php',
            'to_module' => 'OPS_type_traitement_etapes',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_traitement.php',
            'to_module' => 'OPS_type_traitement',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_type_traitement.php',
            'to_module' => 'OPS_type_traitement',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_traitement.php',
            'to_module' => 'OPS_traitement',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_traitement.php',
            'to_module' => 'OPS_traitement',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_traitement_valeurs.php',
            'to_module' => 'OPS_traitement_valeurs',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_traitement_valeurs.php',
            'to_module' => 'OPS_traitement_valeurs',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_traitement_historique.php',
            'to_module' => 'OPS_traitement_historique',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_traitement_historique.php',
            'to_module' => 'OPS_traitement_historique',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/language/application/en_us.lang.php',
            'to_module' => 'application',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/language/application/fr_FR.lang.php',
            'to_module' => 'application',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_lien_parente.php',
            'to_module' => 'OPS_lien_parente',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_lien_parente.php',
            'to_module' => 'OPS_lien_parente',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_information_fiscale.php',
            'to_module' => 'OPS_information_fiscale',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_information_fiscale.php',
            'to_module' => 'OPS_information_fiscale',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_historique_adresse.php',
            'to_module' => 'OPS_historique_adresse',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_historique_adresse.php',
            'to_module' => 'OPS_historique_adresse',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_calendrier_garde.php',
            'to_module' => 'OPS_calendrier_garde',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_calendrier_garde.php',
            'to_module' => 'OPS_calendrier_garde',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_classement.php',
            'to_module' => 'OPS_classement',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_classement.php',
            'to_module' => 'OPS_classement',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dossier.php',
            'to_module' => 'OPS_dossier',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_dossier.php',
            'to_module' => 'OPS_dossier',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/language/application/en_us.lang.php',
            'to_module' => 'application',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/language/application/fr_FR.lang.php',
            'to_module' => 'application',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_2.php',
            'to_module' => 'OPS_niveau_2',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_2.php',
            'to_module' => 'OPS_niveau_2',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_1.php',
            'to_module' => 'OPS_niveau_1',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_1.php',
            'to_module' => 'OPS_niveau_1',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_3.php',
            'to_module' => 'OPS_niveau_3',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_3.php',
            'to_module' => 'OPS_niveau_3',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_4.php',
            'to_module' => 'OPS_niveau_4',
            'language' => 'en_us'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_niveau_4.php',
            'to_module' => 'OPS_niveau_4',
            'language' => 'fr_FR'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_liste_referentiel.php',
            'to_module' => 'OPS_liste_referentiel',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_liste_referentiel.php',
            'to_module' => 'OPS_liste_referentiel',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_liste_valeur.php',
            'to_module' => 'OPS_liste_valeur',
            'language' => 'en_us',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_liste_valeur.php',
            'to_module' => 'OPS_liste_valeur',
            'language' => 'fr_FR',
        ),
        array (
            'from' => '<basepath>/SugarModules/relationships/language/OPS_rapport.php',
            'to_module' => 'OPS_rapport',
            'language' => 'en_us',
        ),
        array (
            'from' => '<basepath>/SugarModules/relationships/language/OPS_rapport.php',
            'to_module' => 'OPS_rapport',
            'language' => 'fr_FR',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/language/OPS_modele_document.php',
            'to_module' => 'OPS_modele_document',
            'language' => 'fr_FR'
        ),
    ),

    'vardefs' => array(
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_elu_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_elu_ops_dossier_OPS_elu.php',
            'to_module' => 'OPS_elu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_reunion_ops_dossier_OPS_reunion.php',
            'to_module' => 'OPS_reunion'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_reunion_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_commission_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_commission_ops_dossier_OPS_commission.php',
            'to_module' => 'OPS_commission'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_etape_ops_statut_OPS_statut.php',
            'to_module' => 'OPS_statut'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_etape_ops_statut_OPS_etape.php',
            'to_module' => 'OPS_etape'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_guide_instruction_ops_etape_OPS_etape.php',
            'to_module' => 'OPS_etape'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_guide_instruction_ops_etape_OPS_guide_instruction.php',
            'to_module' => 'OPS_guide_instruction'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_guide_instruction_ops_dispositif_OPS_guide_instruction.php',
            'to_module' => 'OPS_guide_instruction'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_guide_instruction_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_ops_appairage_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_calls_Calls.php',
            'to_module' => 'Calls'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_calls_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_meetings_Meetings.php',
            'to_module' => 'Meetings'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_meetings_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_notes_Notes.php',
            'to_module' => 'Notes'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_notes_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_tasks_Tasks.php',
            'to_module' => 'Tasks'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_tasks_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_emails_Emails.php',
            'to_module' => 'Emails'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_activities_emails_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_documents_Documents.php',
            'to_module' => 'Documents'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_documents_OPS_type_document.php',
            'to_module' => 'OPS_type_document'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_ops_justificatif_OPS_justificatif.php',
            'to_module' => 'OPS_justificatif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_ops_justificatif_historisation_OPS_justificatif_historisation.php',
            'to_module' => 'OPS_justificatif_historisation'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_ops_justificatif_OPS_type_document.php',
            'to_module' => 'OPS_type_document'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_ops_justificatif_historisation_OPS_type_document.php',
            'to_module' => 'OPS_type_document'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_action_statut_ops_statut_OPS_action_statut.php',
            'to_module' => 'OPS_action_statut'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_action_statut_ops_statut_OPS_statut.php',
            'to_module' => 'OPS_statut'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_journal_detail_ops_journal_OPS_journal_detail.php',
            'to_module' => 'OPS_journal_detail'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_journal_detail_ops_journal_OPS_journal.php',
            'to_module' => 'OPS_journal'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_appairage_ops_journal_OPS_appairage.php',
            'to_module' => 'OPS_appairage'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_documents_Documents.php',
            'to_module' => 'Documents'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_documents_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_justificatif_OPS_justificatif.php',
            'to_module' => 'OPS_justificatif'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_justificatif_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_justificatif_OPS_justificatif.php',
            'to_module' => 'OPS_justificatif'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_justificatif_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_documents_Documents.php',
            'to_module' => 'Documents'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_documents_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_calls_Calls.php',
            'to_module' => 'Calls'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_calls_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_meetings_Meetings.php',
            'to_module' => 'Meetings'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_meetings_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_notes_Notes.php',
            'to_module' => 'Notes'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_notes_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_tasks_Tasks.php',
            'to_module' => 'Tasks'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_tasks_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_emails_Emails.php',
            'to_module' => 'Emails'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_activities_emails_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_notes_Notes.php',
            'to_module' => 'Notes'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_notes_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_notes_Notes.php',
            'to_module' => 'Notes'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_notes_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dispositif_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dispositif_ops_dossier_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_ops_dossier_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_appairage_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_historisation_ops_dossier_OPS_historisation.php',
            'to_module' => 'OPS_historisation'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_historisation_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_historique_connexion_ops_individu_OPS_historique_connexion.php',
            'to_module' => 'OPS_historique_connexion'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_historique_connexion_ops_individu_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_justificatif_historisation_ops_justificatif_OPS_justificatif_historisation.php',
            'to_module' => 'OPS_justificatif_historisation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_justificatif_historisation_ops_justificatif_OPS_justificatif.php',
            'to_module' => 'OPS_justificatif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_integrites_req_ops_integrites_OPS_integrites_req.php',
            'to_module' => 'OPS_integrites_req'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_integrites_req_ops_integrites_OPS_integrites.php',
            'to_module' => 'OPS_integrites'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_connecteur_ops_flux_OPS_flux.php',
            'to_module' => 'OPS_flux'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_connecteur_ops_flux_OPS_connecteur.php',
            'to_module' => 'OPS_connecteur'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_flux_ops_flux_element_OPS_flux_element.php',
            'to_module' => 'OPS_flux_element'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_flux_ops_flux_element_OPS_flux.php',
            'to_module' => 'OPS_flux'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_journal_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),

        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_territoire_ops_type_territoire_OPS_territoire.php',
            'to_module' => 'OPS_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_territoire_ops_type_territoire_OPS_type_territoire.php',
            'to_module' => 'OPS_type_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_territoire_users_Users.php',
            'to_module' => 'Users'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_territoire_users_OPS_territoire.php',
            'to_module' => 'OPS_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_sous_territoire_ops_territoire_OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_sous_territoire_ops_territoire_OPS_territoire.php',
            'to_module' => 'OPS_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_sous_territoire_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_sous_territoire_ops_dossier_OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_sous_territoire_ops_personne_morale_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_sous_territoire_ops_personne_morale_OPS_sous_territoire.php',
            'to_module' => 'OPS_sous_territoire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_dispositif_ops_dispositif_OPS_habilitation_dispositif.php',
            'to_module' => 'OPS_habilitation_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_dispositif_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_etape_ops_habilitation_dispositif_OPS_habilitation_etape.php',
            'to_module' => 'OPS_habilitation_etape'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_etape_ops_habilitation_dispositif_OPS_habilitation_dispositif.php',
            'to_module' => 'OPS_habilitation_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_etape_ops_etape_OPS_etape.php',
            'to_module' => 'OPS_etape'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_etape_ops_etape_OPS_habilitation_etape.php',
            'to_module' => 'OPS_habilitation_etape'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dashlet_onglet_ops_onglet_OPS_dashlet_onglet.php',
            'to_module' => 'OPS_dashlet_onglet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dashlet_onglet_ops_onglet_OPS_onglet.php',
            'to_module' => 'OPS_onglet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dashlet_onglet_ops_dashlet_OPS_dashlet_onglet.php',
            'to_module' => 'OPS_dashlet_onglet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dashlet_onglet_ops_dashlet_OPS_dashlet.php',
            'to_module' => 'OPS_dashlet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_onglet_securitygroups_securitygroups_OPS_onglet_securitygroups.php',
            'to_module' => 'OPS_onglet_securitygroups'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_onglet_securitygroups_securitygroups_SecurityGroups.php',
            'to_module' => 'SecurityGroups'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_onglet_securitygroups_ops_onglet_OPS_onglet_securitygroups.php',
            'to_module' => 'OPS_onglet_securitygroups'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_dispositif_securitygroups_OPS_habilitation_dispositif.php',
            'to_module' => 'OPS_habilitation_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_habilitation_dispositif_securitygroups_SecurityGroups.php',
            'to_module' => 'SecurityGroups'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_onglet_securitygroups_ops_onglet_OPS_onglet.php',
            'to_module' => 'OPS_onglet'
        ),

        // Générateur de vue 
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_vue_ops_generateur_onglet_OPS_generateur_onglet.php',
            'to_module' => 'OPS_generateur_onglet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_vue_ops_generateur_onglet_OPS_generateur_vue.php',
            'to_module' => 'OPS_generateur_vue'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_vue_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_vue_ops_dispositif_OPS_generateur_vue.php',
            'to_module' => 'OPS_generateur_vue'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_onglet_ops_generateur_champ_OPS_generateur_champ.php',
            'to_module' => 'OPS_generateur_champ'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_onglet_ops_generateur_champ_OPS_generateur_onglet.php',
            'to_module' => 'OPS_generateur_onglet'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_version_ops_generateur_formulaire_OPS_generateur_version.php',
            'to_module' => 'OPS_generateur_version'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_version_ops_generateur_formulaire_OPS_generateur_formulaire.php',
            'to_module' => 'OPS_generateur_formulaire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_formulaire_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_generateur_formulaire_ops_dispositif_OPS_generateur_formulaire.php',
            'to_module' => 'OPS_generateur_formulaire'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_calls_Calls.php',
            'to_module' => 'Calls'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_calls_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_emails_Emails.php',
            'to_module' => 'Emails'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_emails_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_meetings_Meetings.php',
            'to_module' => 'Meetings'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_meetings_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_notes_Notes.php',
            'to_module' => 'Notes'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_notes_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_tasks_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_activities_tasks_Tasks.php',
            'to_module' => 'Tasks'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_documents_Documents.php',
            'to_module' => 'Documents'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_documents_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_appairage_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_journal_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_individu_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_individu_OPS_type_personne.php',
            'to_module' => 'OPS_type_personne'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_personne_morale_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_personne_morale_OPS_type_personne.php',
            'to_module' => 'OPS_type_personne'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_dispositif_OPS_type_personne.php',
            'to_module' => 'OPS_type_personne'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_suivi_dossier_OPS_suivi_dossier.php',
            'to_module' => 'OPS_suivi_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_suivi_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_personne_morale_individu_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_personne_morale_individu_OPS_personne_morale_individu.php',
            'to_module' => 'OPS_personne_morale_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_type_personne_type_document_OPS_type_personne.php',
            'to_module' => 'OPS_type_personne'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_personne_ops_type_personne_type_document_OPS_type_personne_type_document.php',
            'to_module' => 'OPS_type_personne_type_document'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_ops_personne_morale_individu_OPS_personne_morale_individu.php',
            'to_module' => 'OPS_personne_morale_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_ops_personne_morale_individu_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_ops_type_personne_type_document_OPS_type_personne_type_document.php',
            'to_module' => 'OPS_type_personne_type_document'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_document_ops_type_personne_type_document_OPS_type_document.php',
            'to_module' => 'OPS_type_document'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_dossier_ops_dossier_OPS_dossier1.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_traitement_ops_type_traitement_etapes_OPS_type_traitement_etapes.php',
            'to_module' => 'OPS_type_traitement_etapes',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_traitement_ops_type_traitement_etapes_OPS_type_traitement.php',
            'to_module' => 'OPS_type_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_traitement_ops_traitement_OPS_traitement.php',
            'to_module' => 'OPS_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_traitement_ops_traitement_OPS_type_traitement.php',
            'to_module' => 'OPS_type_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_traitement_ops_traitement_valeurs_OPS_traitement_valeurs.php',
            'to_module' => 'OPS_traitement_valeurs',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_traitement_ops_traitement_valeurs_OPS_traitement.php',
            'to_module' => 'OPS_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_traitement_ops_traitement_historique_OPS_traitement_historique.php',
            'to_module' => 'OPS_traitement_historique',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_traitement_ops_traitement_historique_OPS_traitement.php',
            'to_module' => 'OPS_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_traitement_etapes_ops_traitement_OPS_traitement.php',
            'to_module' => 'OPS_traitement',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_type_traitement_etapes_ops_traitement_OPS_type_traitement_etapes.php',
            'to_module' => 'OPS_type_traitement_etapes',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_lien_parente_ops_individu_OPS_lien_parente.php',
            'to_module' => 'OPS_lien_parente'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_lien_parente_ops_individu_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_lien_parente_ops_individu_2_OPS_lien_parente.php',
            'to_module' => 'OPS_lien_parente'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_lien_parente_ops_individu_2_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_information_fiscale_OPS_information_fiscale.php',
            'to_module' => 'OPS_information_fiscale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_information_fiscale_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_historique_adresse_OPS_historique_adresse.php',
            'to_module' => 'OPS_historique_adresse'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_historique_adresse_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_domiciliation_OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_ops_domiciliation_OPS_personne_morale.php',
            'to_module' => 'OPS_personne_morale'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_ops_domiciliation_OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_individu_ops_domiciliation_OPS_individu.php',
            'to_module' => 'OPS_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_domiciliation_ops_appairage_OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_domiciliation_ops_journal_OPS_domiciliation.php',
            'to_module' => 'OPS_domiciliation'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_individu_ops_calendrier_garde_OPS_calendrier_garde.php',
            'to_module' => 'OPS_calendrier_garde'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_individu_ops_calendrier_garde_OPS_personne_morale_individu.php',
            'to_module' => 'OPS_personne_morale_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_individu_2_ops_calendrier_garde_OPS_personne_morale_individu.php',
            'to_module' => 'OPS_personne_morale_individu'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_personne_morale_individu_2_ops_calendrier_garde_OPS_calendrier_garde.php',
            'to_module' => 'OPS_calendrier_garde'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_classement_ops_dossier_OPS_classement.php',
            'to_module' => 'OPS_classement'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_classement_ops_dossier_OPS_dossier.php',
            'to_module' => 'OPS_dossier'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_2_ops_niveau_1_OPS_niveau_2.php',
            'to_module' => 'OPS_niveau_2'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_2_ops_niveau_1_OPS_niveau_1.php',
            'to_module' => 'OPS_niveau_1'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_3_ops_niveau_2_OPS_niveau_3.php',
            'to_module' => 'OPS_niveau_3'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_3_ops_niveau_2_OPS_niveau_2.php',
            'to_module' => 'OPS_niveau_2'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_1_ops_classement_type_OPS_niveau_1.php',
            'to_module' => 'OPS_niveau_1'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_1_ops_classement_type_OPS_classement_type.php',
            'to_module' => 'OPS_classement_type'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_4_ops_niveau_3_OPS_niveau_4.php',
            'to_module' => 'OPS_niveau_4'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_niveau_4_ops_niveau_3_OPS_niveau_3.php',
            'to_module' => 'OPS_niveau_3'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_liste_valeur_ops_liste_referentiel_OPS_liste_referentiel.php',
            'to_module' => 'OPS_liste_referentiel'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_liste_valeur_ops_liste_referentiel_OPS_liste_valeur.php',
            'to_module' => 'OPS_liste_valeur'
        ),
        array (
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_rapport_securitygroups_SecurityGroups.php',
            'to_module' => 'SecurityGroups',
        ),
        array (
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_rapport_securitygroups_OPS_rapport.php',
            'to_module' => 'OPS_rapport',
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_modele_document_ops_dispositif_OPS_modele_document.php',
            'to_module' => 'OPS_modele_document'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_modele_document_ops_dispositif_OPS_dispositif.php',
            'to_module' => 'OPS_dispositif'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_modele_document_ops_type_personne_OPS_modele_document.php',
            'to_module' => 'OPS_modele_document'
        ),
        array(
            'from' => '<basepath>/SugarModules/relationships/vardefs/ops_modele_document_ops_type_personne_OPS_type_personne.php',
            'to_module' => 'OPS_type_personne'
        ),
    ),

    'layoutfields' => array(
        array(
            'additional_fields' => array(
                'Calls' => 'ops_individu_activities_calls_name'
            )
        ),
        array(
            'additional_fields' => array(
                'Meetings' => 'ops_individu_activities_meetings_name'
            )
        ),
        array(
            'additional_fields' => array(
                'Notes' => 'ops_individu_activities_notes_name'
            )
        ),
        array(
            'additional_fields' => array(
                'Tasks' => 'ops_individu_activities_tasks_name'
            )
        ),
        array(
            'additional_fields' => array(
                'Calls' => 'ops_personne_morale_activities_calls_name'
            )
        ),

        array(
            'additional_fields' => array(
                'Meetings' => 'ops_personne_morale_activities_meetings_name'
            )
        ),

        array(
            'additional_fields' => array(
                'Notes' => 'ops_personne_morale_activities_notes_name'
            )
        ),
        array(
            'additional_fields' => array(
                'Tasks' => 'ops_personne_morale_activities_tasks_name'
            )
        )
    ),
    'custom_fields' => array(
        'SecurityGroupsbridage_page_accueil_c' => array(
            'id' => 'SecurityGroupsbridage_page_accueil_c',
            'name' => 'bridage_page_accueil_c',
            'label' => 'LBL_BRIDAGE_PAGE_ACCUEIL',
            'comments' => NULL,
            'help' => NULL,
            'module' => 'SecurityGroups',
            'type' => 'bool',
            'max_size' => '255',
            'require_option' => '0',
            'default_value' => '1',
            'date_modified' => '2020-02-28 15:55:09',
            'deleted' => '0',
            'audited' => '0',
            'mass_update' => '0',
            'duplicate_merge' => '0',
            'reportable' => '1',
            'importable' => 'true',
            'ext1' => NULL,
            'ext2' => NULL,
            'ext3' => NULL,
            'ext4' => NULL
        )
    )
);
