$(document).ready(function() {

	$('[data-role="dispositif"]').each(function() {
		if($(this).find('[data-name="visualisation"]').attr('data-value') === 'none')
		{
			disabled_checkbox($(this).closest('tr'));
		}
	});

	/** Pour toutes les habilitations sauf l'accès
	 *  Action sur le onClick
	/*
	/*  Change la valeur de l'habilitation
	/*  Enregistre la valeur dans le base64
	*/
	$('[data-role="habilitation-dispositif"]:not([data-name="visualisation"])').click(function() {
		change_button_value(this);
		save_habilitation($(this).closest('tr').attr('id'), $(this).attr('data-name'), $(this).attr('data-value'));
	});

	$('[data-role="habilitation-individu"]').click(function() {
		change_button_value_individu(this);
		save_onglet($(this).closest('tr').attr('id'), $(this).attr('data-value'));
	});

	$('[data-name="visualisation"]:not([data-role="habilitation-etape"])').click(function(){
		change_button_value(this);
		if($(this).attr('data-value') === 'none')
		{
			disabled_checkbox($(this).closest('tr'));
			if($('#dispositif_acces').is(':checked'))
			{
				$(this).closest('tr').hide();
			}
			delete_habilitation($(this).closest('tr').attr('id'));
		}
		else
		{
			$(this).closest('tr').find('[data-role="habilitation-dispositif"]:not([data-name="visualisation"])').show();
			save_habilitation($(this).closest('tr').attr('id'), $(this).attr('data-name'), $(this).attr('data-value'));
		}
	});

	$('[data-role="habilitation-custom"]').click(function() {
		var modal = $(this).parent().find('.modal');
		$(modal).modal();
	});

	$('[data-role="habilitation-etape"]').click(function() {
		change_button_value(this);

		var dispositif_id = $(this).closest('tr').parent().closest('tr').attr('id')

		save_etape(dispositif_id, $(this).attr('data-name'), $(this).closest('tr').attr('id'), $(this).attr('data-value'));
	});

	/** Affiche la liste des dipositifs en fonction du bouton radio sélectionné
	/*
	/* acces => Affiche les dispositifs qui sont accèsible par le profil
	/* all => Affiche tous les dispositifs
	*/

	display_dispositif_list($('input[name="dispositif_choix"]'));

	$('input[name="dispositif_choix"]').change(function() {
		display_dispositif_list(this);
	});

	function display_dispositif_list(input_checkbox)
	{
		if($(input_checkbox).is(':checked') && $(input_checkbox).val() == 'acces')
		{
			$('[data-role="dispositif"]').each(function() {
				if($(this).find('[data-name="visualisation"]').attr('data-value') === 'none')
				{
					$(this).hide();
				}
				else
				{
					$(this).show();
				}
			});
		}
		else if ($(input_checkbox).is(':checked') && $(input_checkbox).val() == 'all')
		{
			$('[data-role="dispositif"]').show();
		}
	}

	function disabled_checkbox(row)
	{
		$(row).find('[data-role="habilitation-dispositif"]').attr('data-value', 'none');
		$(row).find('[data-role="habilitation-etape"]').attr('data-value', 'none');
		$(row).find('[data-role="habilitation-dispositif"]:not([data-name="visualisation"])').hide();
		$(row).find('[data-role="habilitation-custom"]').hide();
	}

	function change_button_value(icone)
	{
		var habilitation_partielle_autorise = ['visualisation', 'edition', 'instruction'];

		var habilitation_type = $(icone).attr('data-name');
		var value = $(icone).attr('data-value');

		if(value == 'none')
		{
			value = 'all';
		}
		else if(value == 'all')
		{
			if( $(icone).attr('data-role') == 'habilitation-dispositif' && habilitation_partielle_autorise.includes(habilitation_type))
			{
				value = 'partielle';
			}
			else
			{
				value = 'none';
			}
		}
		else
		{
			value = 'none';
		}

		if( $(icone).attr('data-role') == 'habilitation-dispositif' && habilitation_partielle_autorise.includes(habilitation_type))
		{
			if(value == 'partielle')
			{
				$(icone).closest('td').find('[data-role="habilitation-custom"]').show();
			}
			else
			{
				$(icone).closest('td').find('[data-role="habilitation-custom"]').hide();
				$(icone).parent().find('[data-role="habilitation-etape"]').attr('data-value', 'none');
			}
		}

		if(value == 'partielle')
		{
			save_habilitation_partielle($(icone).closest('tr').attr('id'), $(icone).attr('data-name'));
		}
		else if($(icone).attr('data-value') == 'partielle' && value != 'partielle')
		{
			delete_habilitation_partielle($(icone).closest('tr').attr('id'), $(icone).attr('data-name'));
		}

		$(icone).attr('data-value', value);
	}

	function change_button_value_individu(icone)
	{
		var value = $(icone).attr('data-value');

		if(value == 'none')
		{
			value = 'all';
		}
		else
		{
			value = 'none';
		}

		$(icone).attr('data-value', value);
	}

	function save_habilitation(dispositif_id, habilitation, value_habilitation)
	{
		var habilitation_dispositifs = {}
		if($('#habilitation_dispositifs').val() != '')
		{
            habilitation_dispositifs = JSON.parse(decodeURIComponent(escape(atob( $('#habilitation_dispositifs').val() ))));
        }

        var dispositif = {};
        if(dispositif_id in habilitation_dispositifs)
        {
        	dispositif = habilitation_dispositifs[dispositif_id];
        }
        dispositif[habilitation] =  value_habilitation;

        habilitation_dispositifs[dispositif_id] = dispositif;

        $('#habilitation_dispositifs').val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, habilitation_dispositifs)) ) ) ) );
	}

	function save_habilitation_partielle(dispositif_id, habilitation)
	{
		var habilitation_partielle = {}
		if($('#habilitation_partielle').val() != '')
		{
            habilitation_partielle = JSON.parse(decodeURIComponent(escape(atob( $('#habilitation_partielle').val() ))));
        }

        var dispositif = {};
        if(dispositif_id in habilitation_partielle) 
        {
        	dispositif = habilitation_partielle[dispositif_id];
        }
        dispositif[habilitation] =  1;

        habilitation_partielle[dispositif_id] = dispositif;

        $('#habilitation_partielle').val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, habilitation_partielle)) ) ) ) );
	}

	function save_etape(dispositif_id, habilitation, etape_id, value_etape_habilitation)
	{
		habilitation_dispositifs = JSON.parse(decodeURIComponent(escape(atob( $('#habilitation_dispositifs').val() ))));

        dispositif = habilitation_dispositifs[dispositif_id];

        var etapes = {};
        if('etapes' in dispositif)
        {
        	etapes = dispositif['etapes'];
        }

        var etape = {};
        if(etape_id in etapes)
        {
        	etape = etapes[etape_id];
        }

        etape[habilitation] = value_etape_habilitation;

        etapes[etape_id] =  etape;

        dispositif['etapes'] =  etapes;
        
        habilitation_dispositifs[dispositif_id] =  dispositif;

        $('#habilitation_dispositifs').val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, habilitation_dispositifs)) ) ) ) );
	}

	function save_onglet(onglet_id, value)
	{
		var habilitation_individu = {}
		if($('#habilitation_individu').val() != '')
		{
            habilitation_individu = JSON.parse(decodeURIComponent(escape(atob( $('#habilitation_individu').val() ))));
        }

        if(value == 'all')
        {
	        value = 1;
        }
        else
        {
        	value = 0;
        }

        habilitation_individu[onglet_id] = value;

        $('#habilitation_individu').val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, habilitation_individu)) ) ) ) );
	}

	function delete_habilitation(dispositif_id)
	{
		var habilitation_dispositifs = {}
		if($('#habilitation_dispositifs').val() != '')
		{
            habilitation_dispositifs = JSON.parse(decodeURIComponent(escape(atob( $('#habilitation_dispositifs').val() ))));
        }

        var dispositif = {};
        if(dispositif_id in habilitation_dispositifs)
        {
        	delete habilitation_dispositifs[dispositif_id];
        }

        $('#habilitation_dispositifs').val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, habilitation_dispositifs)) ) ) ) );
	}

	function delete_habilitation_partielle(dispositif_id, habilitation)
	{
		var habilitation_partielle = {}
		if($('#habilitation_partielle').val() != '')
		{
            habilitation_partielle = JSON.parse(decodeURIComponent(escape(atob( $('#habilitation_partielle').val() ))));
        }

        var dispositif = {};
        if(dispositif_id in habilitation_partielle)
        {
        	delete habilitation_partielle[dispositif_id][habilitation];
        }

        $('#habilitation_partielle').val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, habilitation_partielle)) ) ) ) );
	}
});