<?php
/*
 * Suppression des Documents Éditique récents antérieurs à la veille encore en brouillon.
 * (Mise à jour à chaud possible via le fichier du planificateur assemblé : /custom/modules/Schedulers/Ext/ScheduledTasks/scheduledtasks.ext.php)
 */


$job_strings[] = 'supprimer_editiques_brouillons';

function supprimer_editiques_brouillons()
{
    global $db, $sugar_config;

    require_once('modules/Configurator/Configurator.php');

    $configuratorObj = new Configurator();
    $configuratorObj->loadConfig();

    # Default params...
    if( intval( $configuratorObj->config['module_editique']['scheduler_delay'] ) == 0 ){
        $configuratorObj->config['module_editique']['scheduler_delay'] = 1; 
        $configuratorObj->saveConfig();
    }
    if( intval( $configuratorObj->config['module_editique']['scheduler_purge_limit'] ) == 0 ){
        $configuratorObj->config['module_editique']['scheduler_purge_limit'] = 50; 
        $configuratorObj->saveConfig();
    }
    $scheduler_delay       = -1 * intval($configuratorObj->config['module_editique']['scheduler_delay']);
    $scheduler_purge_limit = $configuratorObj->config['module_editique']['scheduler_purge_limit'];

    $query_delete = "
        SELECT * FROM `documents` 
        WHERE documents.deleted = 0 
          AND documents.origine = 'editique' 
          AND documents.status_id = 'brouillon' 
          AND documents.date_entered <= DATE_ADD(UTC_TIMESTAMP(), INTERVAL ".$scheduler_delay." day)
        LIMIT ".$scheduler_purge_limit;

    $requete = $db->query( trim($query_delete) );

    while ($row = $db->fetchRow($requete)) {

        $document_id = $row['id'];

        $obj_document = BeanFactory::getBean( 'Documents' , $document_id );
        # $obj_document->ops_dossier_id
        # $obj_document->ops_type_document_documents_name
        # $obj_document->ops_type_document_id

        # Permet de récupérer les potentiels Bean via les relations.
        # Cela offre aussi la possibilité de savoir dans quel module le Document Éditique est généré / exporté !
        $loaded_relationships = [];
        $related_beans_name = [];
        try {
            // $loaded_relationships = $obj_document->loaded_relationships; // Cron process can not access to protected.

            // Bypass to access to related link properties from bean source over cronned task (protecte mode is disalloed).
            $fetched_rel_row = $obj_document->fetched_rel_row;
            foreach ($fetched_rel_row as $key_name => $v) {
                preg_match('/^(ops)([_]([a-z]*))*(documents_name)$/', $key_name, $output_array);
                # Integrité du match et de cohérence.
                if( is_array($output_array) && sizeof($output_array) >= 3 && strlen($output_array[0]) == strlen($key_name) ){
                    $relationship = str_replace('_documents_name', '_id', $key_name);
                    //  $obj_document->{strtolower($relationship)}
                    if( isset( $obj_document->rel_fields_before_value[$relationship] ) ){
                        $loaded_relationships[] = $relationship;
                    }
                }
            }


        } catch (Exception $e) {}

        # Store in related_beans_name the linked BeanName.
        foreach ($loaded_relationships as $key => $relationship) {
            if( strtolower($relationship) != "ops_type_document_id" ){
                $related_beans_name[] = preg_replace('/^(ops_)/', 'OPS_', str_replace('_id', '', $relationship ));
            }
        }
        
        # Module Bean courant... recherche par itération sur un petit nombre d'éléments.
        foreach ($related_beans_name as $key => $bean_name) {

            $query_fetch = "SELECT * FROM `".strtolower($bean_name)."_documents` WHERE `document_id` LIKE '".$document_id."'";
            $fetch_requete = $db->query( trim($query_fetch) );

            $document_solo = true;

            while ($line = $db->fetchRow($fetch_requete)) {

                $module_origin = $bean_name;
                $record_origin = $line[strtolower($bean_name).'_id'];

                if( !empty($record_origin) ){
                    
                    preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $record_origin, $output_array);

                    if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

                        // Bean module référence (relationship)
                        $obj_bean_ref = BeanFactory::getBean( $module_origin , $record_origin );

                        $obj_document->load_relationship( strtolower( $module_origin ).'_documents' );
                        $obj_document->{strtolower( $module_origin ).'_documents'}->delete( $obj_bean_ref );

                        // Suppression du document.
                        $obj_document->mark_deleted($document_id);

                        // Compatibilité versions SuiteCRM.
                        try { $obj_document->save(); } catch (Exception $e) {}

                        $document_solo = false;
                    }
                }
            }
        }

        # Si document solo / related non trouvés... possible casse, donc finalment on marque ce Bean Document supprimé.
        if( $document_solo ){
            $obj_document->mark_deleted($document_id);
        }

    }
    return true;
} 