<?php
/*
 * Gestion des rappels des rendez-vous 
 *
 */

$job_strings[] = 'supprimer_brouillon';

function supprimer_brouillon()
{
    global $db, $sugar_config, $beanFiles;

    $requete = $db->query(
        "SELECT ops_dossier.id
        FROM ops_dossier, ops_dispositif_ops_dossier, ops_dispositif
        WHERE ops_dossier.id = ops_dispositif_ops_dossier.ops_dossier_id 
        AND ops_dispositif_ops_dossier.ops_dispositif_id = ops_dispositif.id
        AND ops_dossier.brouillon = 'oui'
        AND ops_dossier.name != 'TEMP'
        AND ops_dossier.deleted = 0
        AND ops_dossier.flag_suppression = 0
        AND ops_dispositif.supression_brouillon = 1
        AND ops_dossier.date_modified < DATE_ADD(UTC_TIMESTAMP(), INTERVAL -ops_dispositif.delai_notification_suppression day)
        LIMIT 30"
    );

    while ($row = $db->fetchRow($requete)) {
        $objDossier = BeanFactory::getBean('OPS_dossier',$row['id']);
        $bean_source_name = 'OPS_dossier';
        # Récupération du demandeur : 
        $obj_individu = BeanFactory::getBean('OPS_individu',$objDossier->ops_individu_id);
        $email = $obj_individu->email1;
        $type_historique = 'OPS_individu';
        $id_historique = $objDossier->ops_individu_id;
        if( !empty( $email ) && !empty($sugar_config['opensocle']['notif_usager_dossier_avant_suppression']) ){

            # On initialise le mailer 
            $mailer = new OdeMailer();

            # On initialise l'email 
            $ode_email = new OdeEmail([
                'bean_source_id' => $objDossier->id,
                'bean_source_name' => $bean_source_name,
                'bean_historisation_id' => $id_historique,
                'bean_historisation_name' => $type_historique,
                'email_template_id' => $sugar_config['opensocle']['notif_usager_dossier_avant_suppression'],
                'dest_to' => $email,
            ]);

            # On déclenche l'envoie
            $mailer->send($ode_email);
        }

        $query = 'UPDATE ops_dossier SET flag_suppression = 1 WHERE ops_dossier.id = "' . $objDossier->id . '"';

        $db->query($query);
    }
    
    $requete2 = $db->query(
        "SELECT ops_dossier.id
        FROM ops_dossier, ops_dispositif_ops_dossier, ops_dispositif
        WHERE ops_dossier.id = ops_dispositif_ops_dossier.ops_dossier_id 
        AND ops_dispositif_ops_dossier.ops_dispositif_id = ops_dispositif.id
        AND ops_dossier.brouillon = 'oui'
        AND ops_dossier.name != 'TEMP'
        AND ops_dossier.deleted  = 0
        AND ops_dossier.flag_suppression = 1
        AND ops_dispositif.supression_brouillon = 1
        AND ops_dossier.date_modified < DATE_ADD(UTC_TIMESTAMP(), INTERVAL -ops_dispositif.delai_suppression day)"
    );

    while ($row = $db->fetchRow($requete2)) {
        $objDossier = BeanFactory::getBean('OPS_dossier',$row['id']);
        $objDossier->mark_deleted($row['id']);
        $objDossier->save();
    }

    return true;
} 