<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();
$errors        = array();

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    $dir = 1;
    if((isset($configuratorObj->config['ops_justificatif']['chemin']) && $configuratorObj->config['ops_justificatif']['chemin'] != $_REQUEST['chemin']) || empty($configuratorObj->config['ops_justificatif']['chemin'])){
        $dir = mkdir($_REQUEST['chemin'], 0755);
    }

    if($dir || file_exists($_REQUEST['chemin'])){
        # Initialisation des paramètres des justificatifs
        $configuratorObj->config['ops_justificatif']['chemin'] = $_REQUEST['chemin'];

        $configuratorObj->saveConfig();

        header('Location:index.php?module=Administration&action=index');
    }else{
        $errors['main'] = "Le chemin de stockage n'a pas pu être créé";
    }   
    
}

$sugar_smarty->assign('CHEMIN', $configuratorObj->config['ops_justificatif']['chemin']);

$sugar_smarty->assign('PARAMS_PDF', $array_champs);
$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("JAVASCRIPT", get_set_focus_js());
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clearCache('custom/modules/Administration/ops_justificatif.tpl');
$sugar_smarty->display('custom/modules/Administration/ops_justificatif.tpl');