<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();
$errors        = array();
$array_categories = array('titre', 'onglet', 'label', 'champ');
$target_dir = "themes/default/images/";
$target_file = $target_dir . "pdf_logo.png";

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    $check = getimagesize($_FILES["pdf_logo"]["tmp_name"]);
    if ($check !== false) {
        $uploadOk = 1;
    } else {
        $uploadOk = 0;
    }

    $filesize = filesize($_FILES["pdf_logo"]["tmp_name"]);
    if ($filesize <= 5242880) {
        move_uploaded_file($_FILES["pdf_logo"]["tmp_name"], $target_file);
        $uploadOk = 1;
    } else {
        $uploadOk = 0;
    }

    # Initialisation des paramètres généraux du PDF        
    $configuratorObj->config['ops_config_champs_dynamique']['general']['createur'] = $_REQUEST['createur'];
    $configuratorObj->config['ops_config_champs_dynamique']['general']['logo_chemin'] = $target_file;
    $configuratorObj->config['ops_config_champs_dynamique']['general']['police_pdf'] = $_REQUEST['police_pdf'];
    $configuratorObj->config['ops_config_champs_dynamique']['general']['in_colonnes'] = (isset($_REQUEST["in_colonnes"])) ? 1 : 0;
    $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['top'] = $_REQUEST['marge_haut_pdf'];
    $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['bottom'] = $_REQUEST['marge_bas_pdf'];
    $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['left'] = $_REQUEST['marge_gauche_pdf'];
    $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['right'] = $_REQUEST['marge_droite_pdf'];



    #Initilisation des paramètres spécifiques du PDF
    foreach ($array_categories as $categorie) {
        $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['couleur_pdf'] = $_REQUEST['couleur_' . $categorie . '_pdf'];
        $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['taille_pdf'] = $_REQUEST['taille_' . $categorie . '_pdf'];
        if (isset($_REQUEST[$categorie . '_pdf_gras'])) {
            $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_gras'] = 1;
        } else {
            $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_gras'] = 0;
        }
        if (isset($_REQUEST[$categorie . '_pdf_italique'])) {
            $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_italique'] = 1;
        } else {
            $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_italique'] = 0;
        }
        if (isset($_REQUEST[$categorie . '_pdf_souligner'])) {
            $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_souligner'] = 1;
        } else {
            $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_souligner'] = 0;
        }
    }

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index');
}

$sugar_smarty->assign('ARRAY_CATEGORIES', $array_categories);
$sugar_smarty->assign('CREATEUR', $configuratorObj->config['ops_config_champs_dynamique']['general']['createur']);
if (file_exists($target_file)) {
    $sugar_smarty->assign('pdf_logo', $configuratorObj->config['ops_config_champs_dynamique']['general']['logo_chemin']);
}

# Récupération des paramètres généraux du PDF
$sugar_smarty->assign("POLICE_PDF", get_select_options_with_id($app_list_strings['ops_config_champs_police_list'], isset($configuratorObj->config['ops_config_champs_dynamique']['general']['police_pdf']) ? $configuratorObj->config['ops_config_champs_dynamique']['general']['police_pdf'] : "arial"));
$sugar_smarty->assign('MARGE_HAUT_PDF', $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['top']);
$sugar_smarty->assign('MARGE_BAS_PDF', $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['bottom']);
$sugar_smarty->assign('MARGE_GAUCHE_PDF', $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['left']);
$sugar_smarty->assign('MARGE_DROITE_PDF', $configuratorObj->config['ops_config_champs_dynamique']['general']['margin']['right']);
$sugar_smarty->assign('IN_COLONNES', $configuratorObj->config['ops_config_champs_dynamique']['general']['in_colonnes']);

# Récupération des paramètres spécifiques du PDF
foreach ($array_categories as $categorie) {
    $array_champs[$categorie] = array(
        'couleur_pdf' => $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['couleur_pdf'],
        'taille_pdf' => get_select_options_with_id($app_list_strings['ops_config_champs_police_tailles'], isset($configuratorObj->config['ops_config_champs_dynamique'][$categorie]['taille_pdf']) ? $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['taille_pdf'] : "2 px"),
        'pdf_gras' => $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_gras'],
        'pdf_italique' => $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_italique'],
        'pdf_souligner' => $configuratorObj->config['ops_config_champs_dynamique'][$categorie]['pdf_souligner']
    );
}

$sugar_smarty->assign('PARAMS_PDF', $array_champs);
$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("JAVASCRIPT", get_set_focus_js());
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clearCache('custom/modules/Administration/ops_config_champs.tpl');
$sugar_smarty->display('custom/modules/Administration/ops_config_champs.tpl');
