<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();
$errors        = array();


$target_dir = "themes/default/images/";
$target_file = $target_dir . "pdf_logo.png";

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    # Initialisation des paramètres généraux du PDF
    $configuratorObj->config['module_editique']['scheduler_delay']       = $_REQUEST['scheduler_delay'];
    $configuratorObj->config['module_editique']['scheduler_purge_limit'] = $_REQUEST['scheduler_purge_limit'];

    $configuratorObj->config['module_editique']['replacement_enabled'] = $_REQUEST['replacement_enabled'];

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index');
    
}

// Default params...
if( intval( $configuratorObj->config['module_editique']['scheduler_delay'] ) == 0 ){
    $configuratorObj->config['module_editique']['scheduler_delay'] = 1; 
    $configuratorObj->saveConfig();
}
if( intval( $configuratorObj->config['module_editique']['scheduler_purge_limit'] ) == 0 ){
    $configuratorObj->config['module_editique']['scheduler_purge_limit'] = 50; 
    $configuratorObj->saveConfig();
}

if( intval( $configuratorObj->config['module_editique']['replacement_enabled'] ) == 0 ){
    $configuratorObj->config['module_editique']['replacement_enabled'] = 0; 
    $configuratorObj->saveConfig();
}

$sugar_smarty->assign('SCHEDULER_DELAY', $configuratorObj->config['module_editique']['scheduler_delay']);
$sugar_smarty->assign('SCHEDULER_PURGE_LIMIT', $configuratorObj->config['module_editique']['scheduler_purge_limit']);

$sugar_smarty->assign('SCHEDULER_REPLACEMENT_ENABLED', (intval($configuratorObj->config['module_editique']['replacement_enabled']) == 1)? ' checked="checked" ':'' );


$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("STYLESHEET", "");
$sugar_smarty->assign("JAVASCRIPT", get_set_focus_js());
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clearCache('custom/modules/Administration/module_editique.tpl');
$sugar_smarty->display('custom/modules/Administration/module_editique.tpl');