<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();
$errors        = array();
$array_categories = array('titre', 'onglet', 'label', 'champ');
$target_dir = "themes/default/images/";
$target_file = $target_dir . "pdf_logo.png";

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    $configuratorObj->config['geoloc_leaflet']['longitude'] = $_REQUEST['longitude'];
    $configuratorObj->config['geoloc_leaflet']['latitude'] = $_REQUEST['latitude'];
    $configuratorObj->config['geoloc_leaflet']['hauteur'] = $_REQUEST['hauteur'];
    $configuratorObj->config['geoloc_leaflet']['zoom'] = $_REQUEST['zoom'];

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index');
    
}

$hauteur = (!empty($configuratorObj->config['geoloc_leaflet']['hauteur']))?$configuratorObj->config['geoloc_leaflet']['hauteur']:'400';
$zoom = (!empty($configuratorObj->config['geoloc_leaflet']['zoom']))?$configuratorObj->config['geoloc_leaflet']['zoom']:'7';

$sugar_smarty->assign('ARRAY_CATEGORIES', $array_categories);
$sugar_smarty->assign('LONGITUDE', $configuratorObj->config['geoloc_leaflet']['longitude']);
$sugar_smarty->assign('LATITUDE', $configuratorObj->config['geoloc_leaflet']['latitude']);
$sugar_smarty->assign('HAUTEUR', $hauteur);
$sugar_smarty->assign('ZOOM', $zoom);

$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("JAVASCRIPT", get_set_focus_js());
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clearCache('custom/modules/Administration/geoloc_leaflet.tpl');
$sugar_smarty->display('custom/modules/Administration/geoloc_leaflet.tpl');