<?php

require_once('include/generic/SugarWidgets/SugarWidgetSubPanelEditButton.php');

class SugarWidgetSubPanelEditButtonMultiActionsDocuments extends SugarWidgetSubPanelEditButton
{
    function displayList(&$layout_def)
    {
        global $app_strings;

        $MultiActionDocuments = new \stdClass();

        // On stocke temporairemant les attributs des boutons souhaités...
        $multi_buttons   = array();

        $return_module       = $_REQUEST['module'];  // Origine Bean Module name (parent emitter)
        $return_id           = $_REQUEST['record'];  // Origine Bean Record ID (parent emitter)
        $return_action       = 'SubPanelViewer';
        $return_relationship = strtolower($return_module) .'_'. strtolower( $layout_def['module'] );

        $record        = $layout_def['fields']['ID']; // Active Bean Record ID
        $subpanel      = $layout_def['subpanel_id'];  // Referer SubpanelID

        $obj_document = BeanFactory::getBean( $layout_def['module'] , $record );

        // Quelques verroux et contraintes d'état...
        $diffusion_state =  (bool)intval( trim( $obj_document->importable ) );
        $editable_state  =  ( trim( $obj_document->origine ) == 'editique' )? true : false;

        # Link Button « ÉDITER »
        $return_url = "";
        $multi_buttons['compose'] = array(
            'visible'    => true,
            'return_url' => $return_url,
            'action_url' => "javascript:return false;",
            'on_click'   => "location.href='index.php?module=".$layout_def['module']."&action=create&name_module=".$return_module."&id_bean=".$return_id."&record=$record'",
            'link_label' => "Éditer",
            'tooltip'    => "Édite le contenu de ce document Éditique",
        );

        // Retire le bouton « ÉDITER » dans le cas où l'origine du document n'est pas Éditique.
        if( !$editable_state ){ $multi_buttons['compose'][ 'visible' ] = false; }

        // Retire (si présent) le bouton « ÉDITER » dans le cas où le document est déjà diffusé à l'usager.
        if( $diffusion_state ){ $multi_buttons['compose'][ 'visible' ] = false; }

        // Mise en forme des liens boutons... dans l'ordre souhaité.
        $MultiActionDocuments->buttons = $this->get_multi_buttons( array(
            $multi_buttons['compose'],
        ) );
        return $this->generate_html( $MultiActionDocuments );
    }

    function get_multi_buttons($multi_buttons){
        // SuiteCRM accepte en mode custom des lien a href, plutôt que des input/buttons...
        $buttons = array();
        foreach ($multi_buttons as $key => $attributes) {
            if( (bool)$attributes['visible'] ){
                $buttons[] = '<ul class="SugarActionMenu clickMenu"><li class="single"><a href="'.$attributes['action_url'].'" class="button-group" id="action_editique" title="'.$attributes['tooltip'].'" onclick="'.$attributes['on_click'].'"/>'.$attributes['link_label'].'</a></li></ul>';
            }
        }
        return implode( '', $buttons);
    }

    function generate_html( $Subpanel_MultiButtons ){
        $html = $Subpanel_MultiButtons->buttons;
        return $html;
    }
}