<?php

namespace ODE\Model;

use ODE\Model\AppairageModel;

if (!defined('sugarEntry')) define('sugarEntry', true);

class PersonneMoraleModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe PersonneMoraleModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données de la personne morale en tableau
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getBean()
    {

        global $db;
        $personne_morales = array();

        $sql = "SELECT * FROM `ops_personne_morale` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $personne_morales[] = $row;
        }

        return (is_array($personne_morales) && count($personne_morales) === 1) ? $personne_morales[0] : array();
    }

    /**
     * @access public
     * @name  getAppairageId()
     * Fonction qui retourne la raison sociale de la personne morale sur Coriolis
     *
     *  @return array               - $raison_sociale : raison sociale du tiers sur Coriolis
     */
    public function  getAppairageId()
    {

        global $db;
        $appairages = array();

        $sql = "SELECT `id` FROM `ops_appairage` WHERE `parent_type` = 'OPS_personne_morale' AND `parent_id` = '" . $this->id . "' AND `logiciel` = 'gestionfin' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $appairages[] = $row;
        }

        return (is_array($appairages) && count($appairages) === 1) ? $appairages[0]['id'] : "";
    }

    /**
     * @access public
     * @name getAppairage()
     * Fonction qui retourne l'appairage de la personne morale
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getAppairage()
    {

        $appairage_id = $this->getAppairageId();
        $appairageModel = new AppairageModel($appairage_id);
        $appairage = $appairageModel->getBean();
        return (is_array($appairage) && count($appairage) > 0) ? $appairage : array();
    }

    /**
     * @access public
     * @name getAppairageName()
     * Fonction qui retourne le nom de l'appairage de la personne morale
     *
     *  @return array               - $appairage_name : retourne le nom de l'appairage de la personne morale
     */
    public function getAppairageName()
    {

        $appairage_name = "";
        $appairage = $this->getAppairage();
        if (is_array($appairage) && count($appairage) > 0) {
            if (!empty($appairage['name']) && !empty($appairage['statut']) && $appairage['statut'] === "ok") {
                $appairage_name = $appairage['name'];
            }
        }
        return $appairage_name;
    }

    /**
     * @access public
     * @name getMandataireId()
     * Fonction qui retourne le nom de l'appairage de la personne morale
     *
     *  @return array               - $mandataire_id : retourne l'id du mandataire si il existe
     */
    public function getMandataireId()
    {
        $personne_morale = $this->getBean();
        return (is_array($personne_morale) && count($personne_morale) > 0 && !empty($personne_morale['ops_individu1_id'])) ? $personne_morale['ops_individu1_id'] : "";
    }

    /**
     * @access public
     * @name getRaisonSociale()
     * Fonction qui retourne la raison sociale de la personne morale sur Coriolis
     *
     *  @return array               - $raison_sociale : raison sociale du tiers sur Coriolis
     */
    public function getRaisonSociale()
    {

        $raison_sociale = "";
        $appairage_id = $this->getAppairageId();
        $personne_morale = $this->getBean();
        if (!empty($appairage_id)) {
            $appairageModel = new AppairageModel($appairage_id);
            $appairage_journal = $appairageModel->getJournal();
            if (is_array($appairage_journal) && count($appairage_journal) > 0 && !empty($appairage_journal['details'])) {
                if (is_array($appairage_journal['details']) && count($appairage_journal['details']) > 0) {
                    foreach ($appairage_journal['details'] as $detail) {
                        if (str_replace(' ', '', "Concordance raison sociale") == str_replace(' ', '', $detail['name'])) {
                            if (false !== strpos($detail['reponse'], "Oui")) {
                                $raison_sociale = $personne_morale['name'];
                            }
                            if (false !== strpos($detail['reponse'], "Non")) {
                                $raison_sociale = explode(":", $detail['reponse'])[1];
                            }
                        }
                    }
                }
            }
        }
        return $raison_sociale;
    }

    /**
     * @access public
     * @name getDomiciliationIds()
     * Fonction qui retourne les domiciliations de la personne morale 
     *
     *  @return array               - $domiciliations: les domiciliations de la personne morale 
     */
    public function getDomiciliationIds()
    {

        global $db;
        $domiciliations = array();
        $sql = " SELECT `ops_domiciliation_id` FROM `ops_personne_morale_ops_domiciliation` WHERE `ops_personne_morale_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $domiciliations[] = $row['ops_domiciliation_id'];
        }
        return (!empty($domiciliations) && count($domiciliations) > 0) ? $domiciliations : array();
    }

    /**
     * @access public
     * @name getDossierIds()
     * Fonction qui retourne les dossiers de la personne morale 
     *
     *  @return array               - $dossiers: les domiciliations de la personne morale 
     */
    public function getDossierIds()
    {

        global $db;
        $dossiers = array();
        $sql = " SELECT `ops_personne_morale` FROM `ops_dossier` WHERE `ops_personne_morale` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dossiers[] = $row['ops_dossier_id'];
        }
        return (!empty($dossiers) && count($dossiers) > 0) ? $dossiers : array();
    }

    /**
     * @access public
     * @name getTypePersonneMoraleId()
     * Fonction qui retourne les dossiers de la personne morale 
     *
     *  @return array               - $dossiers: les domiciliations de la personne morale 
     */
    public function getTypePersonneMoraleId()
    {

        global $db;
        $type_personne = array();
        $sql = " SELECT `ops_type_personne_id` FROM `ops_type_personne_ops_personne_morale` WHERE `ops_personne_morale_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $type_personne[] = $row['ops_type_personne_id'];
        }
        return (!empty($type_personne) && count($type_personne) > 0) ? $type_personne[0] : "";
    }

    /**
     * @access public
     * @name getTypePersonneMorale()
     * Fonction qui retourne les données de la personne morale en tableau
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getTypePersonneMorale()
    {

        global $db;
        $types = array();
        $type_id = $this->getTypePersonneMoraleId();
        $sql = "SELECT * FROM `ops_type_personne` WHERE `id` = '" . $type_id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $types[] = $row;
        }

        return (is_array($types) && count($types) === 1) ? $types[0] : array();
    }
}
