<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);
use ODE\Generateur\Factory\OdeFieldFactory;

class GenerateurReferentielModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe GenerateurReferentielModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id = "")
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du generateur_referentiel en tableau
     *
     *  @return array               - $generateur_referentiel: generateur_referentiel
     */
    public function getBean()
    {

        global $db;
        $generateur_referentiels = array();

        $sql = "SELECT * FROM `ops_generateur_referentiel` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $generateur_referentiels[] = $row;
        }
        return (!empty($generateur_referentiels) && count($generateur_referentiels) === 1) ? $generateur_referentiels[0] : array();
    }

    /**
     * @access public
     * @name getFullListe()
     * Fonction qui retourne le type de demandeur du dossier
     *
     *  @return array               - $demandeur_type : le type de demandeur "Individu" ou "Personne Morale"
     */
    public function getFullListe()
    {

        global $db;
        $champs_referentiel = array();
        $sql = "SELECT * FROM `ops_generateur_referentiel` WHERE `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            if (!empty($row['name'])) {
                $champs_referentiel[$row['name']] = $row;
            }
        }
        return (!empty($champs_referentiel) && count($champs_referentiel) > 0) ? $champs_referentiel : array();
    }

    /**
     * @access public
     * @name getFullListe()
     * Fonction qui retourne le type de demandeur du dossier
     *
     *  @return array               - $demandeur_type : le type de demandeur "Individu" ou "Personne Morale"
     */
    public static function getListeGenerateur()
    {
        global $db;
        $champs_referentiel = array();
        $sql = "SELECT * FROM `ops_generateur_referentiel` WHERE `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $id = self::getUniqueId();
            if (!empty($row['name'])) {
                $champs_referentiel[$id] = [
                    "nom" => $row['name'],
                    "libelle" => $row['libelle'],
                    "type" => $row['type'],
                    "ineditable" => $row['ineditable'],
                    "obligatoire" => $row['obligatoire'],
                    "aide" => $row['aide'],
                    "defaut" => $row['defaut'],
                    "description" => $row['description'],
                    "params" => $row['params'],
                    "conditions" => $row['conditions'],
                    "modifiable" => $row['modifiable'],
                    "libelle_type" => self::getLibelleType($row['type']),
                ];
            }
        }

        if (!empty($champs_referentiel) && count($champs_referentiel) > 0) {

            $nom  = array_column($champs_referentiel, 'nom');
            $libelle = array_column($champs_referentiel, 'libelle');

            array_multisort($libelle, SORT_ASC, $nom, SORT_ASC, $champs_referentiel);
        }

        return $champs_referentiel;
    }


    public static function getByName($name)
    {
        global $db;
        $champ = array();
        $sql = "SELECT * FROM `ops_generateur_referentiel` WHERE `name` = '" . $name . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $champ = $row;
        }
        return (!empty($champ) && count($champ) > 0) ? $champ : array();
    }

    private static function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    private static function getLibelleType($type)
    {
        $types = OdeFieldFactory::getFieldLanguage();
        return array_key_exists($type, $types) ? $types[$type] : "";
    }

    public static function getCustomFieldListe(){
        global $db;
        $fields = [];
        $sql = "SELECT * FROM `ops_generateur_referentiel` WHERE `description` = 'custom' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            if ( !empty($row['name']) ){
                $fields[$row['name']] = !empty($row['libelle']) ? $row['libelle']  . " (".  $row['name'] . ")"  : $row['name'];
            }
        }
        return !empty($fields) && count($fields) > 0 ? $fields : [];
    }

    public static function getCustomFieldFullListe(){
        global $db;
        $fields = [];
        $sql = "SELECT * FROM `ops_generateur_referentiel` WHERE `description` = 'custom' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            if ( !empty($row['name']) ){
                $fields[$row['name']] = $row;
            }
        }
        return !empty($fields) && count($fields) > 0 ? $fields : [];
    }
}
