<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class GenerateurFormulaireModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe GenerateurFormulaireModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du elu en tableau
     *
     *  @return array               - $elu: elu
     */
    public function getBean()
    {

        global $db;
        $formulaires = array();

        $sql = "SELECT * FROM `ops_generateur_formulaire` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $formulaires[] = $row;
        }
        return (!empty($formulaires) && count($formulaires) === 1) ? $formulaires[0] : array();
    }

    /**
     * @access public
     * @name getVueAgentChamps()
     * Fonction qui retourne les données du elu en tableau
     *
     *  @return array               - $elu: elu
     */
    public function getVueAgentChamps()
    {

        $champs = [];
        $agent_vue_id = $this->getVueAgentId();
        if (!empty($agent_vue_id)) {
            // On récupere les champs associés à cette vue
            $GenerateurVueModel = new GenerateurVueModel($agent_vue_id);
            $champs = $GenerateurVueModel->getChamps(true);
        }

        if (count($champs) > 0) {
            // Si on a bien récupérer la liste des champs, on ajoute le type_tiers
            $champs['type_tiers'] = [
                'name' => 'type_tiers',
                'libelle' => 'Type de profil',
                'obligatoire' => 1,
                'type' => 'text',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
            $champs['brouillon'] = [
                'name' => 'brouillon',
                'libelle' => 'Brouillon',
                'obligatoire' => 0,
                'type' => 'text',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
            $champs['ordre_onglet'] = [
                'name' => 'ordre_onglet',
                'libelle' => 'Ordre onglet',
                'obligatoire' => 0,
                'type' => 'number',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
        }
        return $champs;
    }

    /**
     * @access public
     * @name getVueUsagerChamps()
     * Fonction qui retourne les champs du modèle de dossier pour les usagers
     *
     *  @return array               - $elu: elu
     */
    public function getVueUsagerChamps()
    {

        $champs = [];
        $agent_vue_id = $this->getVueUsagerId();
        if (!empty($agent_vue_id)) {
            // On récupere les champs associés à cette vue
            $GenerateurVueModel = new GenerateurVueModel($agent_vue_id);
            $champs = $GenerateurVueModel->getChamps(true);
        }

        if (count($champs) > 0) {
            // Si on a bien récupérer la liste des champs, on ajoute le type_tiers
            $champs['type_tiers'] = [
                'name' => 'type_tiers',
                'libelle' => 'Type de profil',
                'obligatoire' => 1,
                'type' => 'text',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
            $champs['brouillon'] = [
                'name' => 'brouillon',
                'libelle' => 'Brouillon',
                'obligatoire' => 0,
                'type' => 'text',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
            $champs['ordre_onglet'] = [
                'name' => 'ordre_onglet',
                'libelle' => 'Ordre onglet',
                'obligatoire' => 0,
                'type' => 'number',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
        }
        return $champs;
    }

    /**
     * @access public
     * @name getVueUsagerChampsByEtape()
     * Fonction qui retourne les données du elu en tableau
     *
     *  @return array               - $elu: elu
     */
    public function getVueUsagerEtapes()
    {
        $etapes = [];
        $usager_vue_id = $this->getVueUsagerId();
        if (!empty($usager_vue_id)) {
            // On récupere les champs associés à cette vue
            $GenerateurVueModel = new GenerateurVueModel($usager_vue_id);
            $onglets = $GenerateurVueModel->getOnglets();
            foreach ($onglets as $onglet) {
                $etapes[$onglet["ordre"]] = ["name" => $onglet["libelle"], "conditions" => $onglet["conditions"]];
            }
        }
        return $etapes;
    }

    /**
     * @access public
     * @name getVueUsagerChampsByEtape()
     * Fonction qui retourne les données du elu en tableau
     *
     *  @return array               - $elu: elu
     */
    public function getVueUsagerChampsByEtape($ordre)
    {

        $champs = [];
        $usager_vue_id = $this->getVueUsagerId();
        if (!empty($usager_vue_id)) {
            // On récupere les champs associés à cette vue
            $GenerateurVueModel = new GenerateurVueModel($usager_vue_id);
            $champs = $GenerateurVueModel->getChampsByOnglet($ordre);
        }

        if (count($champs) > 0) {
            // Si on a bien récupérer la liste des champs, on ajoute le type_tiers
            $champs['type_tiers'] = [
                'name' => 'type_tiers',
                'libelle' => 'Type de profil',
                'obligatoire' => 1,
                'type' => 'text',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
            $champs['brouillon'] = [
                'name' => 'brouillon',
                'libelle' => 'Brouillon',
                'obligatoire' => 0,
                'type' => 'text',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
            $champs['ordre_onglet'] = [
                'name' => 'ordre_onglet',
                'libelle' => 'Ordre onglet',
                'obligatoire' => 0,
                'type' => 'number',
                'cle' => '',
                'ineditable' => 0,
                'aide' => '',
                'defaut' => '',
                'propriete_1' => '',
                'propriete_2' => '',
                'propriete_3' => '',
                'propriete_4' => '',
                'description' => 'basic',
                'params' => '',
            ];
        }
        return $champs;
    }


    /**
     * @access public
     * @name getVueAgentChamps()
     * Fonction qui retourne les données du elu en tableau
     *
     *  @return array               - $elu: elu
     */
    public function getVueAgentId()
    {
        $formulaire = $this->getBean();
        return (is_array($formulaire) && count($formulaire) > 0 && !empty($formulaire["agent_vue_id"])) ? $formulaire["agent_vue_id"] : "";
    }

    /**
     * @access public
     * @name getVueUsagerId()
     * Fonction qui retourne les données du elu en tableau
     *
     *  @return array               - $elu: elu
     */
    public function getVueUsagerId()
    {
        $formulaire = $this->getBean();
        return (is_array($formulaire) && count($formulaire) > 0 && !empty($formulaire["usager_vue_id"])) ? $formulaire["usager_vue_id"] : "";
    }
}
