<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class EngagementModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe EngagementModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du engagement en tableau
     *
     *  @return array               - $engagement: engagement
     */
    public function getBean()
    {

        global $db;
        $engagements = array();

        $sql = "SELECT * FROM `ops_engagement` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $engagements[] = $row;
        }

        if (!empty($engagements) && count($engagements) === 1 && !empty($engagements[0]['id'])) {
            $engagements[0]['liquidations'] = $this->getLiquidations($engagements[0]['id']);
        }

        return (!empty($engagements) && count($engagements) === 1) ? $engagements[0] : array();
    }


    /**
     * @access private
     * @name getJournalDetail()
     * Fonction qui retourne le nom de l'appairage de la personne morale
     *
     *  @return array               - $appairage_name : retourne le nom de l'appairage de la personne morale
     */
    private function getLiquidations($engagement_id)
    {

        global $db;
        $liquidations = array();

        $sql = "SELECT * FROM `ops_liquidation` WHERE `id` IN (SELECT `ops_liquidation_id` FROM `ops_engagement_ops_liquidation` WHERE `ops_engagement_id` = '" . $engagement_id . "' AND `deleted` = '0' )";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $liquidations[] = $row;
        }

        return (!empty($liquidations) && count($liquidations) > 0) ? $liquidations : array();
    }
}
