<?php

namespace ODE\Model;

use ODE\Helper\OdeDateHelper;
use ODE\Helper\OdeStringHelper;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ContratModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe ContratModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {
        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du contrat en tableau
     *
     *  @return array               - $contrat: contrat
     */
    public function getBean()
    {

        global $db;
        $contrats = array();

        $sql = "SELECT * FROM `ops_contrat` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $contrats[] = $row;
        }
        return (!empty($contrats) && count($contrats) === 1) ? $contrats[0] : array();
    }

    /**
     * @access public
     * @name getName()
     * Fonction qui retourne le nom de la contrat
     *
     *  @return array               - $contrat_name: le nom de la contrat
     */
    public function getName()
    {
        $contrat = $this->getBean();
        return (is_array($contrat) && count($contrat) > 0 && !empty($contrat["name"])) ? $contrat["name"] : "";
    }

    /**
     * @access public
     * @name addRelationDossier()
     * Fonction qui retourne les données du contrat en tableau
     *
     *  @return array               - $contrat: contrat
     */
    public static function addRelationDossier($dossier_id, $contrat_id)
    {
        global $db;
        if (!empty($dossier_id) && !empty($contrat_id)) {
            $date_modified = OdeDateHelper::getDateTimeNow();
            $relation_id = OdeStringHelper::getUuid();
            $sql = "INSERT INTO `ops_contrat_ops_dossier` (`id`, `date_modified`, `deleted`, `ops_contrat_id`, `ops_dossier_id`)";
            $sql .= "VALUES ('" . $relation_id . "', '" . $date_modified . "', '0', '" . $contrat_id . "', '" . $dossier_id . "')";
            $db->query($sql);
        }
    }

    /**
     * @access public
     * @name addRelationDossier()
     * Fonction qui retourne les données du contrat en tableau
     *
     *  @return array               - $contrat: contrat
     */
    public static function deleteRelations($dossier_id)
    {
        global $db;
        if (!empty($dossier_id)) {
            $date_modified = OdeDateHelper::getDateTimeNow();
            $sql = "UPDATE `ops_contrat_ops_dossier` SET `deleted`='1',`date_modified`= '" . $date_modified . "' WHERE `ops_dossier_id`='" . $dossier_id . "'";
            $db->query($sql);
        }
    }
}
