<?php

namespace ODE\Helper;

 
class OdeStringHelper
{

    public static function getUuid() {
        return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            // 32 bits for "time_low"
            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),

            // 16 bits for "time_mid"
            mt_rand( 0, 0xffff ),
    
            // 16 bits for "time_hi_and_version",
            // four most significant bits holds version number 4
            mt_rand( 0, 0x0fff ) | 0x4000,
    
            // 16 bits, 8 bits for "clk_seq_hi_res",
            // 8 bits for "clk_seq_low",
            // two most significant bits holds zero and one for variant DCE1.1
            mt_rand( 0, 0x3fff ) | 0x8000,
    
            // 48 bits for "node"
            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
        );
    }

    public static function parseSQL($sql) {
        $result = array(
            "select" => "",
            "from" => "",
            "where" => ""
        );
    
        $selectPos = stripos($sql, "SELECT");
        $fromPos = stripos($sql, "FROM");
        $wherePos = stripos($sql, "WHERE");
    
        if ($selectPos !== false && $fromPos !== false) {
            $result['select'] = substr($sql, $selectPos, $fromPos - $selectPos );
        }
    
        if ($fromPos !== false) {
            $endFromPos = $wherePos !== false ? $wherePos : strlen($sql);
            $result['from'] = substr($sql, $fromPos, $endFromPos - $fromPos );
        }
    
        if ($wherePos !== false) {
            $result['where'] = substr($sql, $wherePos);
        }
    
        return $result;
    }

}
