var OdeText = {};

OdeText.initialisation = function(){
    $('input[data-field-mask]').each(function(){

        var custom_mask = ['(email)'];

        if( !custom_mask.includes($(this).attr('data-field-mask')) ) {
            Inputmask({
                        mask: $(this).attr('data-field-mask'), 
                        "clearIncomplete": true,
                        definitions: {
                            'a': {
                                validator: "[a-zA-ZÂÊÎÔÛÄËÏÖÜÀÈÙÉÇßŒÆÃÑÕâêîôûäëïöüàèùéçœæãñõ]",
                                casing: "lower"
                            },
                            'A': {
                                validator: "[A-Za-zÂÊÎÔÛÄËÏÖÜÀÈÙÉÇßŒÆÃÑÕâêîôûäëïöüàèùéçœæãñõ]",
                                casing: "upper"
                            },
                            '*': {
                                validator: "[(°)#@:._\\\'\\\-\\\s0-9A-Za-zÂÊÎÔÛÄËÏÖÜÀÈÙÉÇßŒÆÃÑÕâêîôûäëïöüàèùéçœæãñõ]"
                            },
                            '%': {
                                validator: "[\\\-,.0-9]"
                            },
                        },
                        onBeforePaste: function (pastedValue, opts) { 
                            plainValue = String(pastedValue).trim();
                            return plainValue;
                        }
                    }).mask( $(this) );
        }
    });
}

OdeText.isValid = function( field ){ return true;}

OdeText.getValue = function( field ){
    if( typeof $(field).val() === 'string' ) 
    {
        value = String($(field).val());
        value = OdeDossier.escapeHTML(value);
        
        let output = '';
        for (let i = 0; i < value.length; i++) {
            let charCode = value.charCodeAt(i);
            if (charCode > 127) {
                output += '\\u' + charCode.toString(16).padStart(4, '0');
            } else {
                output += value[i];
            }
        }

        value = output.replaceAll("\n",'&#13;');

        return value.trim();
    }
    return '';
} 

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['text'] = OdeText;
    }
});
