var OdeIban = {};

OdeIban.initialisation = function(){
    $("[data-domi=iban]").each(function() {
        $(this).inputmask();
    });
}

OdeIban.isValid = function( field ){ 
    
    var isCorrect = true;
    if(field.attr('data-domi') !== undefined && field.attr('data-domi') == 'iban' && field.val() != ''){
        var iban = field.val().replaceAll('_','');
        iban = iban.replaceAll(' ', '');
        var validateIBAN = OdeIban.validateIBAN(iban);
        if(!validateIBAN){
            isCorrect = false;
        }
    }

    if(isCorrect){
        OdeValidator.hideErreur(field);
        return true;
    }else{
        OdeValidator.showErreur(field , 'Le format IBAN est incorrect');  
    }
    return false;
}

OdeIban.getValue = function( field ){
    if($(field).attr('data-domi') == 'iban'){
        var val = $(field).val().replaceAll('_', '');
        return val.toUpperCase();
    }
    return '';
}

OdeIban.validateIBAN = function(iban){
    var newIban = iban.toUpperCase();

    if (newIban.search(/^[A-Z]{2}/gi) < 0) {
        return false;
    }
    newIban = newIban.substring(4) + newIban.substring(0, 4);
    newIban = newIban.trim();

    var numeric   = Array.from(newIban).map(c =>(isNaN(parseInt(c)) ? (c.charCodeAt(0)-55).toString() : c)).join('');
    var remainder = Array.from(numeric).map(c => parseInt(c)).reduce((remainder, value) => (remainder * 10 + value) % 97,0);

    if( remainder === 1 ){
        return true;
    }
    else{
        return false;
    }
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['iban'] = OdeIban;
    }
});
