var OdeDate = {};

OdeDate.initialisation = function(){
    $.datepicker.regional['fr'] = {
        clearText: 'Effacer', clearStatus: '',
        closeText: 'Fermer', closeStatus: 'Fermer sans modifier',
        prevText: '<Préc', prevStatus: 'Voir le mois précédent',
        nextText: 'Suiv>', nextStatus: 'Voir le mois suivant',
        currentText: 'Courant', currentStatus: 'Voir le mois courant',
        monthNames: ['Janvier','Février','Mars','Avril','Mai','Juin',
        'Juillet','Août','Septembre','Octobre','Novembre','Décembre'],
        monthNamesShort: ['Jan','Fév','Mar','Avr','Mai','Jun',
        'Jul','Aoû','Sep','Oct','Nov','Déc'],
        monthStatus: 'Voir un autre mois', yearStatus: 'Voir un autre année',
        weekHeader: 'Sm', weekStatus: '',
        dayNames: ['Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi'],
        dayNamesShort: ['Dim','Lun','Mar','Mer','Jeu','Ven','Sam'],
        dayNamesMin: ['Di','Lu','Ma','Me','Je','Ve','Sa'],
        dayStatus: 'Utiliser DD comme premier jour de la semaine', dateStatus: 'Choisir le DD, MM d',
        dateFormat: 'dd/mm/yy', firstDay: 0, 
        initStatus: 'Choisir la date', isRTL: false
    };
    $.datepicker.setDefaults($.datepicker.regional['fr']);
    $("[rel=datepicker]").each(function() {
        $(this).datepicker({
            altField: "#datepicker",
            closeText: "Fermer",
            firstDay: 1 ,
            dateFormat: "dd/mm/yy"
        });
    });
}

OdeDate.isValid = function( field ){ 
    var isCorrect = true;
    if ( field.hasClass("hasDatepicker") ) {
        var field_value = this.getValue(field);
        isCorrect = ( !field_value.isEmpty() ) ? OdeDate.isFormatDate( field_value ) : true;
    }
    if ( isCorrect ){
        OdeValidator.hideErreur( field );
        return true;
    } else {
        OdeValidator.showErreur( field , "Le format est incorrect");
        return false;
    }
}

OdeDate.getValue = function( field ){
    if ( typeof $(field).val() === 'string' &&  $(field).val() !== "" ) {
       return $(field).val().trim();
    }
    return '';
} 

OdeDate.isFormatDate = function( field_value ) {

    if( field_value.length == 0 ){return true;}
    if( field_value.length < 10 ){return false;}

    var jour = field_value.charAt(0) + field_value.charAt(1);
    if(jour <1 || jour >31){return false;}
    if(!$.isNumeric(jour)){return false;}
    
    var mois = field_value.charAt(3) + field_value.charAt(4);
    if(!$.isNumeric(mois)){return false;}
    if(mois <1 || mois >12){return false;}
    
    var annee = field_value.charAt(6) + field_value.charAt(7) + field_value.charAt(8) + field_value.charAt(9);
    if(!$.isNumeric(annee)){return false;}
    
    return true;
  },

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['date'] = OdeDate;
    }
});
