var OdeCalcul = {};

OdeCalcul.initialisation = function(){
    $("[data-type-field=calcul]").each(function() {
        const regex = /\$([a-zA-Z0-9_]+)[ +\-*/()]*([a-zA-Z0-9_]+)?/g;
        var formule = $(this).attr('data-formule-calcul');
        const matches = [...formule.matchAll(regex)].map(match => match[1]);
        matches.forEach(function(element) {
            var indice = 0;
            if($("[data-name="+element+"]").length > 0){
                $("[data-name="+element+"]").each(function(ind) {
                    //Permet de récupérer celui qui n'est pas disabled si ce n'est pas le premier.
                    if($(this).is(":not([disabled])")){
                        indice = ind;
                        return false;
                    }
                });
            }

            if($("[data-name="+element+"]").attr('data-type-field') == 'radio'){
                $($("[data-name="+element+"]")).change(function(){
                    OdeCalcul.calcul(element);
                });
            }else if($("[data-name="+element+"]").attr('data-type-field') == 'checkboxmulti'){
                var checkBox = $("[data-name="+element+"]").siblings().find("[type=checkbox]");
                $(checkBox).change(function(){
                    OdeCalcul.calcul(element);
                });
            }else{
                $($("[data-name="+element+"]")[indice]).change(function(){
                    OdeCalcul.calcul(element);
                });
            }
        });
    });
}

OdeCalcul.isValid = function( field ){
    var isCorrect = true;
    if( field.attr("rel") == 'calcul' && field.attr("data-visible") !== 'masque'){
        if(field.val() == "" && field.attr("required") == "required"){
            isCorrect = false;
        }
    }
    if(isCorrect){
        OdeValidator.hideErreur(field);
        return true;
    }else{
        OdeValidator.showErreur(field , 'Le champ ne doit pas être vide');
    }
    return false;
}

OdeCalcul.getValue = function( field ){
    if ( typeof $(field).val() === 'string' &&  $(field).val() !== "" ) {
       return $(field).val().trim();
    }
    return '';
}

OdeCalcul.calcul = function(name){
    $("[data-type-field=calcul]").each(function() {
        var index = $(this).attr('data-formule-calcul').indexOf(name);
        if(index !== -1){
            const regex = /\$([a-zA-Z0-9_]+)[ +\-*/()]*([a-zA-Z0-9_]+)?/g;
            var formule = $(this).attr('data-formule-calcul');
            formule = formule.replaceAll(/ /g,"");
            const matches = [...formule.matchAll(regex)].map(match => match[1]);
            matches.forEach(function(element) {
                if($("[data-name="+element+"]").attr('data-type-field') == 'radio'){
                    var num = ($("[data-name="+element+"]:checked").val() != undefined && $("[data-name="+element+"]:checked").val() != '' )?$("[data-name="+element+"]:checked").val():0;
                }else if($("[data-name="+element+"]").attr('data-type-field') == 'checkboxmulti'){
                    var val = $("[data-name="+element+"]").val();
                    if(val != undefined && val != ''){
                        val = val.replaceAll("^", "");
                        val = val.split(",").map(Number); // Convertir la chaîne en tableau de nombres
                        var num = val.reduce((total, nb) => total + nb, 0); // Calculer la somme
                    }else{
                        var num = 0;
                    }
                }else{
                    var indice = 0;
                    if($("[data-name="+element+"]").length > 0){
                        $("[data-name="+element+"]").each(function(ind) {
                            if($(this).is(":not([disabled])")){
                                indice = ind;
                                return false;
                            }
                        });
                    }
                    var num = ($($('[data-name='+element+']')[indice]).val() != undefined && $($('[data-name='+element+']')[indice]).val() != '' )?$($('[data-name='+element+']')[indice]).val():0;
                }

                if($('[data-name='+element+']').attr('data-type-field') == "pourcentage" ) num = num+'%'; 

                var regex = new RegExp("\\$(" + element + ")(?![a-zA-Z0-9_])", "g");

                formule = formule.replace(regex, num);
            });
            //Calcul si on a un champ de type pourcentage
            const regexPorucentage = /[\+\-]\s*[0-9]*[\.,]?[0-9]+\s*%/;
            const matchesPourcentage = formule.match(regexPorucentage);
            if(matchesPourcentage){
                matchesPourcentage.forEach(function(match) {
                    calcul = match.replaceAll(/%/g, "");
                    calcul = ' * (1+('+calcul+'/100))';
                    formule = formule.replaceAll(match,calcul);
                });
            }
            formule = formule.replaceAll(/ /g,"");
            formule = formule.replaceAll('x','*');
            formule = formule.replaceAll(',','.');

            
            var resultat = eval(math.evaluate(formule));
            resultat = ($(this).attr('data-decimal') == 1)?resultat.toFixed(2):resultat.toFixed(0);

            // On trigger l'event "change" afin d'actualiser les autres champs se basant sur le résultat du calcul
            $(this).val(eval(resultat)).change();
        }
    });
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['calcul'] = OdeCalcul;
    }
});
