var OdeApiR2p = {};

OdeApiR2p.initialisation = function(){
    $("[data-type=api_r2p]").each(function(){
        var id = $(this).attr('id');
        var apiR2pNom = "#"+id+" [data-name=name_api_r2p_nom]";
        var apiR2pPrenom = "#"+id+" [data-name=name_api_r2p_prenom]";
        var apiR2pDateNaissance = "#"+id+" [data-name=name_api_r2p_date_naissance]";

        $(apiR2pNom).change(function(){
            if( $(apiR2pNom).val().length >= '2' && $(apiR2pPrenom).val().length >= '2' && $(apiR2pDateNaissance).val().length == '10' ){
                OdeApiR2p.getPersonnePhysique(id);
            }
        });
        $(apiR2pPrenom).change(function(){
            if( $(apiR2pNom).val().length >= '2' && $(apiR2pPrenom).val().length >= '2' && $(apiR2pDateNaissance).val().length == '10' ){
                OdeApiR2p.getPersonnePhysique(id);
            }
        });
        $(apiR2pDateNaissance).change(function(){
            if( $(apiR2pNom).val().length >= '2' && $(apiR2pPrenom).val().length >= '2' && $(apiR2pDateNaissance).val().length == '10' ){
                OdeApiR2p.getPersonnePhysique(id);
            }
        });
    });
}

OdeApiR2p.isValid = function( field ){ return true;}

OdeApiR2p.getValue = function( field ){
    if( typeof $(field).val() === 'string' ) {
        value = String($(field).val()).replaceAll("\n",'&#13;')
        value = OdeDossier.escapeHTML(value);
        return value.trim();
    }
    return '';
} 

OdeApiR2p.getPersonnePhysique = function(id){

    var data = 'nom='+ $("#"+id+" [data-name=name_api_r2p_nom]").val()+'&prenom='+$("#"+id+" [data-name=name_api_r2p_prenom]").val()+'&date_naissance='+$("#"+id+" [data-name=name_api_r2p_date_naissance]").val();
    
    $.ajax({
        url: "index.php?entryPoint=api_r2p",
        type: 'POST',
        data: data,
        success: function(data){
            var result = JSON.parse(data);
            if(result.error){
                $("#"+id+" [role=erreur]").show();
                $("#"+id+" [role=erreur]").text(result.message);
            }else{
                $("#"+id+" [role=erreur]").hide();
                var api_r2p = new Array();
                api_r2p['value_api_r2p_nom'] = result.personnePhysique.lbNomUsage;
                api_r2p['value_api_r2p_prenom'] = result.personnePhysique.lbPrenomUsage;
                api_r2p['value_api_r2p_date_naissance'] = result.personnePhysique.jourNaissance+'/'+result.personnePhysique.moisNaissance+'/'+result.personnePhysique.anneeNaissance;
                api_r2p["resultat"] = new Array();
                $("#"+id+" [role=resultat]").each(function(){
                    var name = $(this).attr('data-name');
                    api_r2p["resultat"][name] = result.personnePhysique[name];
                    $("#"+id+" [data-name="+name+"]").val(result.personnePhysique[name]);
                });
                api_r2p["resultat"] = btoa(JSON.stringify(Object.assign({}, api_r2p["resultat"])));
                var api_r2p = btoa(JSON.stringify(Object.assign({}, api_r2p)));
                $("#"+id+"_value").val(api_r2p);
            }
        }
    });
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['api_r2p'] = OdeApiR2p;
    }
});