var OdeAdresse = {};

OdeAdresse.initialisation = function(){
    $("[data-type=adresse]").each(function(){
        var id = $(this).attr('id');
        
        var disableApiBan = document.getElementById(id).dataset.disableApiBan;
        // Si l'API BAN n'est pas désactivée dans les paramètres généraux d'Open CRM, appel à la BAN, sinon, saisie manuelle
        $("#"+id+" [data-name=name_rue]").change(function(){
            disableApiBan == false ? OdeAdresse.getAdresse(id) : OdeAdresse.setAdresse(id);;
        });
        $("#"+id+" [data-name=name_code_postal]").change(function(){
            disableApiBan == false ? OdeAdresse.getAdresse(id) : OdeAdresse.setAdresse(id);;
        });
        $("#"+id+" [data-name=name_ville]").change(function(){
            disableApiBan == false ? OdeAdresse.getAdresse(id) : OdeAdresse.setAdresse(id);;
        });

        $("#"+id+" [data-name=name_numero]").change(function(){
            if($("#"+id+"_value").val() != ''){
                var adresse = JSON.parse(decodeURIComponent(escape(atob( $("#"+id+"_value").val() ))));
                adresse.numero =  $("#"+id+" [data-name=name_numero]").val();
                $("#"+id+"_value").val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) ) );
            }
        });

        $("#"+id+" [data-name=name_complement_batiment]").change(function(){
            if($("#"+id+"_value").val() != ''){
                var adresse = JSON.parse(decodeURIComponent(escape(atob( $("#"+id+"_value").val() ))));
                adresse.complement_batiment =  $("#"+id+" [data-name=name_complement_batiment]").val();
                $("#"+id+"_value").val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) ) );
            }
        });

        $("#"+id+" [data-name=name_complement_lieu]").change(function(){
            if($("#"+id+"_value").val() != ''){
                var adresse = JSON.parse(decodeURIComponent(escape(atob( $("#"+id+"_value").val() ))));
                adresse.complement_lieu =  $("#"+id+" [data-name=name_complement_lieu]").val();
                $("#"+id+"_value").val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) ) );
            }
        });
    });
}

OdeAdresse.isValid = function( field ){ return true;}

OdeAdresse.getValue = function( field ){
    if( typeof $(field).val() === 'string' ) {
        value = String($(field).val()).replaceAll("\n",'&#13;')
        value = OdeDossier.escapeHTML(value);
        return value.trim();
    }
    return '';
} 

OdeAdresse.getAdresse = function(id){
    if($("#"+id+" [data-name=name_rue]").val() != '' && $("#"+id+" [data-name=name_rue]").val().length >= 4
    && (($("#"+id+" [data-name=name_code_postal]").val() != '' && $("#"+id+" [data-name=name_code_postal]").val().length >= 4)
        || $("#"+id+" [data-name=name_ville]").val() != '' && $("#"+id+" [data-name=name_ville]").val().length >= 4) ){
        var adresse = $("#"+id+" [data-name=name_numero]").val() + " " + $("#"+id+" [data-name=name_rue]").val() + " " + $("#"+id+" [data-name=name_code_postal]").val() + " " + $("#"+id+" [data-name=name_ville]").val();
        $.ajax({
            url: "https://api-adresse.data.gouv.fr/search/?q="+adresse,
            dataType:"json",
            success: function(data){
                if(data.features.length == 1){
                    var rue = (data.features[0].properties.type == 'street')?data.features[0].properties.name:data.features[0].properties.street;
                    var numero = (data.features[0].properties.housenumber != undefined)?data.features[0].properties.housenumber:$("#"+id+" [data-name=name_numero]").val();
                    $("#"+id+" [data-name=name_numero]").val(numero);
                    $("#"+id+" [data-name=name_rue]").val(rue);
                    $("#"+id+" [data-name=name_code_postal]").val(data.features[0].properties.postcode);
                    $("#"+id+" [data-name=name_ville]").val(data.features[0].properties.city);
                    $("#"+id+" [data-name=name_latitude]").val(data.features[0].geometry.coordinates[1]);
                    $("#"+id+" [data-name=name_longitude]").val(data.features[0].geometry.coordinates[0]);
                    var adresse = new Array();
                    adresse['id'] = data.features[0].properties.id;
                    adresse['numero'] = numero;
                    adresse['rue'] = rue;
                    adresse['city'] = data.features[0].properties.city;
                    adresse['postcode'] = data.features[0].properties.postcode;
                    adresse['citycode'] = data.features[0].properties.citycode;
                    adresse['coordonnees_x'] = data.features[0].geometry.coordinates[1];
                    adresse['coordonnees_y'] = data.features[0].geometry.coordinates[0];
                    adresse['complement_batiment'] = $("#"+id+" [data-name=name_complement_batiment]").val();
                    adresse['complement_lieu'] = $("#"+id+" [data-name=name_complement_lieu]").val();
                    var adresse = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) );
                    $("#"+id+"_value").val(adresse);
                }else if(data.features.length > 1){
                    $('#'+id+'-modal-adresse-body').empty();
                    $.each(data.features, function( index, value ) {
                        var rue = (value.properties.type == 'street')?value.properties.name:value.properties.street;
                        var numero = (value.properties.housenumber != undefined)?value.properties.housenumber:$("#"+id+" [data-name=name_numero]").val();
                        var radioBtn = $('<div onclick="OdeAdresse.setAdresse(\''+ id + '\',\'' +value.properties.id+'\')"><input type="radio" id="'+value.properties.id+'" name="adresse_trouve" /><label for="'+value.properties.id+'">'+value.properties.label+'</label></div>');
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'housenumber" value="'+numero+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_name" value="'+rue+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_city" value="'+value.properties.city+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_postcode" value="'+value.properties.postcode+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_citycode" value="'+value.properties.citycode+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_coordonnees_x" value="'+value.geometry.coordinates[1]+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_coordonnees_y" value="'+value.geometry.coordinates[0]+'">'));
                        radioBtn.appendTo('#'+id+'-modal-adresse-body');
                    });
                    $('#'+id+'-titre_modal_trouve').empty();
                    $('#'+id+'-titre_modal_trouve').append(data.features.length + ' adresses trouvées');
                    $('#'+id+'-modal-adresse').modal();
                }
            }
        });
    }
 }

 OdeAdresse.setAdresse = function(id, id_adresse){
    var adresse = new Array();
    adresse['id'] = id_adresse;
    if(document.getElementById(id).dataset.disableApiBan == false) { // Si l'API BAN est activée, on récupère l'adresse cochée au retour de l'API
        $("#"+id+" [data-name=name_rue]").val($("#"+id_adresse+"_name").val());
        $("#"+id+" [data-name=name_code_postal]").val($("#"+id_adresse+"_postcode").val());
        $("#"+id+" [data-name=name_ville]").val($("#"+id_adresse+"_city").val());
        adresse['numero'] = $("#"+id_adresse+"housenumber").val();
        adresse['rue'] = $("#"+id_adresse+"_name").val();
        adresse['city'] = $("#"+id_adresse+"_city").val();
        adresse['postcode'] = $("#"+id_adresse+"_postcode").val();
        adresse['citycode'] = $("#"+id_adresse+"_citycode").val();
        adresse['coordonnees_x'] = $("#"+id_adresse+"_coordonnees_x").val();
        adresse['coordonnees_y'] = $("#"+id_adresse+"_coordonnees_y").val();
    } else { // Si l'API BAN est désactivée, on effectue une saisie manuelle
        adresse['numero'] = $("#"+id+" [data-name=name_numero]").val();
        adresse['rue'] = $("#"+id+" [data-name=name_rue]").val();
        adresse['city'] = $("#"+id+" [data-name=name_ville]").val();
        adresse['postcode'] = $("#"+id+" [data-name=name_code_postal]").val();
        adresse['citycode'] = $("#"+id_adresse+"_citycode").val();
    }
    adresse['complement_batiment'] = $("#"+id+" [data-name=name_complement_batiment]").val();
    adresse['complement_lieu'] = $("#"+id+" [data-name=name_complement_lieu]").val();
    var adresse = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) );
    $("#"+id+"_value").val(adresse);
    $('#'+id+'-modal-adresse').modal('hide');
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['adresse'] = OdeAdresse;
    }
});
