<?php

namespace ODE\Generateur\Field;

use ODE\Helper\OdeArrayHelper;
/*
        $GLOBALS['log']->fatal(" OdeListeChoixMulti :: getEditableField() =>  " . $champ['name'] . print_r(array(
            "liste" => $liste,
            "value" => $value,
        ), true));
        */

class OdeRadio extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean			    $bean: Bean du module OPS_dossier
     * @param boolean			$editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {

        // On récupere la valeur à afficher
        $values = $this->getFieldValue($value_bdd);
        $liste = $this->getFieldListe(base64_decode($champ["params"]));
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";

        $field_html = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $value_libelle =  (!empty($liste[$values[0]])) ? $liste[$values[0]] : "";
        $data_value =  (!empty($liste[$values[0]])) ? $values[0] : "";
        
        $field_html .= '<div class="col-md-8">';
        $field_html .=     '<input type="text" data-name="'.$name.'" role="champ-formulaire" data-conditions="' . $champ['conditions'] . '" data-value="' . $data_value . '" value="' . $value_libelle . '" disabled />';
        $field_html .= '</div>';

        return $field_html;
    }


    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $values = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $values = $this->getFieldValue($value_bdd);
        }

        $liste = $this->getFieldListe(base64_decode($champ["params"]));
        $required = (isset($champ['obligatoire']) && $champ['obligatoire'] == 1) ? ' required="true" ' : '';
        $disabled = ($champ['ineditable'] == 0) ? "" : " disabled ";

        $field_html = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);

        $field_html .= '<div class="col-md-8">';
        foreach ($liste as $index => $valeur) {

            $checked = (in_array($index, $values)) ? " checked" : "";
            $checked = ($isFirstRadio && count($values) === 0) ? " checked" : $checked;

            $data = ' role="champ-formulaire" data-type-field="radio" data-name="' . $champ["name"] . '" data-conditions="' . $champ["conditions"] . '" ' . $isDefaut ;

            $field_html .=      '<div class="field-radio-label">';
            $field_html .=          '<input id="' . $champ["name"] . '_'. $index.'" ' . $data . ' type="radio" name="' . $champ["name"] . '" value="' . $index . '"  ' . $checked . ' ' . $required . ' ' . $disabled . '>';
            $field_html .=          '<label for="' . $champ["name"] . '_'. $index.'" >' . $valeur . '</label> ';
            $field_html .=      '</div>';

        }
        $field_html .= '</div>';
        if($this->donnees["vue"]["type"] == 'agent'){
            $field_html .= '<script type="text/javascript" charset="UTF-8" src="custom/include/Ode/Generateur/Field/js/OdeRadio.js?='.time().'"></script>';
        }

        return $field_html;
    }

    public function getFieldValue($value_bdd)
    {
        return (!empty($value_bdd)) ? [html_entity_decode($value_bdd)] : [];
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $defautTab = json_decode( base64_decode($value_defaut),true);
        
        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value'];
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab);
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        return (!empty($value_defaut)) ? [html_entity_decode($value_defaut)] : [];
    }

    public function getFieldListe($params)
    {
        global $app_list_strings;
        $liste = [];
        $params_formated = OdeArrayHelper::jsonToArray($params);
        if ($params_formated['statut'] == "ok") {
            $params = $params_formated['data'];
            if (!empty($params['liste_name'])) {
                $liste_name = $params['liste_name'];
                if (array_key_exists($liste_name, $app_list_strings)) {
                    $liste = $app_list_strings[$liste_name];
                }
            } else if (!empty($params['liste'])) {
                $liste = $params['liste'];
            }
        }
        return $liste;
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        $values = [];
        $value_display = "";
        $liste = $this->getFieldListe(base64_decode($champ["params"]));
        if (strpos($value, "^,^") === false) {
            $values[] = $value;
        } else {
        }
        foreach ($liste as $index => $valeur) {
            if (in_array($index, $values)) {
                $value_display .= $valeur;
            }
        }
        return (!empty($value_display)) ? html_entity_decode($value_display) : "";
    }

    public static function getLibelle()
    {
        return "Bouton radio";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeRadio::getLibelle(),
            'icon' => 'far fa-dot-circle',
            'route' => '/champs/?type=radio',
            'attributes' => '',
        ];
    }
}