<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;

class OdeCheckbox extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdeCheckbox
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
    */
    public function getIneditableField($champ, $value_bdd)
    {

        // On récupere la valeur à afficher
        $checked = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("checked", $checked);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_checkbox.tpl");

        return $field_label . $field_html;

    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $checked = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $checked = $this->getFieldValue($value_bdd);
        }

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("checked", $checked);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("isDefaut", $isDefaut);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_checkbox.tpl");

        return $field_label . $field_html;
    }

    public function getFieldValue($value_bdd)
    {
        return ($value_bdd == "1") ? ' checked="checked" ' : '';
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $defautTab = json_decode( base64_decode($value_defaut), true);
        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value']; 
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab);
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        return ($value_defaut == "1") ? ' checked="checked" ' : '';
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        return ($value == "1") ? "Oui" : "Non";
    }

    public static function getLibelle()
    {
        return "Case à cocher";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeCheckbox::getLibelle(),
            'icon' => 'far fa-check-square',
            'route' => '/champs/?type=checkbox',
            'attributes' => '',
        ];
    }
}
