var Champ = (function ($) { 

    const fields = [ "nom", "libelle", "type", "obligatoire", "ineditable", "aide", "defaut", "description", "params","conditions", "modifiable" ];
     
      return { 
    
        setDraggable: function() {
    
            const self = this;
            $("[role=list-champ]").each(function() {
                $(this).draggable({
                    helper: "clone",
                    appendTo: "body",
                    revert: true,
                    revertDuration: 0,
                    start: function(event, ui) { 
                        $(this).draggable("option", "cursorAt", {
                            left: Math.floor(ui.helper.width() / 2),
                            top: Math.floor(ui.helper.height() / 2)
                        }); 
                        var champ = $(this);
                        $("[role=champ-container]").each(function() {
                            if( ( self.getTypeDouble().includes($(champ).attr("data-type")) 
                                && $(this).children().length === 0 
                                && $(this).siblings('[role=champ-container]').children().length !== 0 )
                                || ( self.getTypeDouble().includes($(this).siblings('[role=champ-container]').children().attr("data-type"))
                                    && $(this).children().length === 0 ) ){
                                $(this).removeClass('champ-container-full').addClass('champ-container-blocked');
                            }else if($(this).children().length === 0){
                                $(this).removeClass('champ-container-full').addClass('champ-container-empty');
                            }else{
                                $(this).removeClass( "champ-container-empty champ-container-blocked" ).addClass('champ-container-full');
                            }
                        });
    
                        if ($(this).hasClass("list-champ-dropped") ) {
                            $("#trash-page").show();
                        }
                        
                    },
                    stop: function( event, ui ) {
                        $("[role=champ-container]").each(function() {
                            $(this).removeClass( "champ-container-empty champ-container-blocked" ).addClass('champ-container-full');
                        });
                        if ($(this).hasClass("list-champ-dropped") ) {
                            $("#trash-page").hide();
                        }
                    },
                });
            });
        },
    
        setDroppableContainers: function() {
            const self = this;
            $("[role=champ-container]").each(function() {
                const champ_container = this;
                $(this).droppable({
                    activeClass: "active",
                    hoverClass: "hover",
                    accept: function (draggable) {
                        if( ( self.getTypeDouble().includes($(draggable).attr("data-type")) 
                            && $(champ_container).children().length === 0 
                            && $(champ_container).siblings('[role=champ-container]').children().length !== 0 )
                            || ( self.getTypeDouble().includes($(champ_container).siblings('[role=champ-container]').children().attr("data-type"))
                                && $(champ_container).children().length === 0 )
                            || $(champ_container).children().length !== 0 ){
                            return false;
                        }else if($(champ_container).children().length === 0 && $(draggable).attr("role") === "list-champ"){
                            return true;
                        }else{
                            return true;
                        }
                    },
                    drop: function(event, ui) {
    
                        if ( !ui.draggable.hasClass("list-champ-dropped") ){
    
                            let id = self.getUniqueId();
                            var element = $(ui.draggable.clone());
                            element.attr("id", id);
                            element.find("i").attr("data-route", `/champs/?type=${element.attr("data-type")}&id=${id}`);
                        
                        }else{
                            var element = ui.draggable;
                        }
                 
                        element.draggable({
                            helper: "clone",
                            appendTo: "body",
                            revert: true, 
                            revertDuration: 0,
                            appendTo: 'body',
                            start: function(event, ui) { 
                                $(this).draggable("option", "cursorAt", {
                                    left: Math.floor(ui.helper.width() / 2),
                                    top: Math.floor(ui.helper.height() / 2)
                                }); 
                                var champ = $(this);
                                $("[role=champ-container]").each(function() {
                                    if( ( self.getTypeDouble().includes($(champ).attr("data-type")) 
                                        && $(this).children().length === 0 
                                        && $(this).siblings('[role=champ-container]').children().length !== 0 )
                                        || ( self.getTypeDouble().includes($(this).siblings('[role=champ-container]').children().attr("data-type"))
                                            && $(this).children().length === 0 ) ){
                                        $(this).removeClass('champ-container-full').addClass('champ-container-blocked');
                                    }else if($(this).children().length === 0){
                                        $(this).removeClass('champ-container-full').addClass('champ-container-empty');
                                    }else{
                                        $(this).removeClass( "champ-container-empty champ-container-blocked" ).addClass('champ-container-full');
                                    }
                                });
                                if ($(this).hasClass("list-champ-dropped") ) {
                                    $("#trash-page").show();
                                }
                            },
                            stop: function( event, ui ) {
                                $("[role=champ-container]").each(function() {
                                    $(this).removeClass( "champ-container-empty champ-container-blocked" ).addClass('champ-container-full');
                                });
                                if ($(this).hasClass("list-champ-dropped") ) {
                                    $("#trash-page").hide();
                                }
                            }
                        });
                     
                        $(champ_container).append(element.removeClass('list-champ-draggable').addClass('list-champ-dropped'));
                        //Flag modification
                        Champ.flagModification($(this).children(':first').attr('id'));
                        self.setIconeConditions( element );
                        Router.setClickRoutes();
                    }
                });
            });
            
        },
    
        setIconeConditions: function ( champ ){
            
            if ( !$(champ).attr("data-conditions").isEmpty() ) {
                var data_conditions = JSON.parse($(champ).attr("data-conditions").b64ToUtf8());  
                if ( data_conditions.hasOwnProperty("conditions") ){
                    var nb = Object.getLength(data_conditions.conditions);
                     $(champ).find('[role="display-conditions"]').empty();
                     if ( typeof nb === "number" && nb > 0 ) {
                         var icone_html = `<i style="margin-left: 8px;color: #f08377;cursor: help;" title="${nb} condition(s)" class="fas fa-filter"></i>`;
                         icone_html +=`<span style="top: 1px;position: relative;margin-left: -1px;color: #f08377;font-size: 11px;font-weight: bold;">${nb}</span>`;
                         $(champ).find('[role="display-conditions"]').append( icone_html );
                     }
                }
            }
        },
    
        getUniqueId: function() {
            return (Date.now().toString(36) + Math.random().toString(36).substr(2, 5)).toUpperCase();
        },
    
        getLibelleType: function(type) { 
            return typeof OdeFieldLanguage === 'object' && OdeFieldLanguage.hasOwnProperty(type) ? OdeFieldLanguage[type] : "" ; 
        },
        
        getEmptyData: function( type ){
            return {    
                aide: "",
                conditions: "",
                defaut: "",
                description: "custom",
                ineditable: "0",
                libelle: "",
                modifiable: "1",
                nom: "",
                obligatoire: "0",
                params: "",
                type: type,
            };
        },
    
        getData: function( id ){
            var data = {};
            const element = $(`#${id}`);
            if ( element.length === 1 ) {
                fields.forEach( champ_name => {
                    const regex = /^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$/;
                    data[champ_name] = (![undefined, null,""].includes(element.attr(`data-${champ_name}`))) ? element.attr(`data-${champ_name}`) : "";
                    if(champ_name == 'aide' && data[champ_name] != "" && data[champ_name].match(regex)){
                        data[champ_name] = decodeURIComponent(escape(window.atob( data[champ_name] )));
                    }
                });
            }
            return data;
    
        },
    
        setData: function( id, data ){
            const element = $(`#${id}`);
            if ( element.length === 0 || this.isDataValid(data) === false ) return false;
            fields.forEach( champ_name => {
                element.attr(`data-${champ_name}`, data[champ_name]);
            });
            return true;
        },
    
        create: function( data , loading , callBack ){
            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_generateur_referentiel');
            query.setAction("createChamp");
            query.setPostData(data);
            OdeAjax.getByAction( query, loading, callBack );
        },
    
        update: function( id, data ){
            this.setData( id, data );
            this.setTitleChamp( id, data.libelle );
            this.setObligatoireIcon( id, data.obligatoire );
            setTimeout(function(){ 
                OdeLoadingHelper.removeSpinnerMenu();
                $("[role=champ-formulaire]").each(function() {
                    Champ.hideVerification( $(this) );
                });
                OdeAlertHelper.set( $(`#g-champ-form-message`) , "success",`Modifications sauvegardées`);
                Router.navigate("/");
            }, 1000);
            
        },
    
        setTitleChamp: function(id, title){
            $(`#${id}`).find("div.list-champ-title").text(title);
        },

        setObligatoireIcon: function(id, obligatoire){
            if(obligatoire == 1){
                if($(`#${id}`).find("div.list-champ-title i").length == 0){
                    $(`#${id}`).find("div.list-champ-title").append('<i class="fas fa-star-of-life" style="color:#f08377; float:right; margin-top: 2px;"></i>');
                }
            }
        },
    
        isDataValid: function( data ){
            if ( typeof data !== 'object' || data === null || Object.getLength(data) === 0 ) return false;
            if ( data["nom"] === undefined || data["nom"] === "" ) return false;
            if ( data["libelle"] === undefined || data["libelle"] === "" ) return false;
            if ( data["obligatoire"] === undefined || !["0","1"].includes(data["obligatoire"]) ) return false;
            if ( data["ineditable"] === undefined || !["0","1"].includes(data["ineditable"]) ) return false;
            if ( data["aide"] === undefined ) return false;
            if ( data["defaut"] === undefined ) return false;
            if ( data["description"] === undefined ) return false;
            if ( data["params"] === undefined ) return false;
            if ( data["conditions"] === undefined ) return false;
            if ( data["modifiable"] === undefined || !["0","1"].includes(data["modifiable"]) ) return false;
            return true; 
        },
    
        displayVerification: function ( element, statut, message ){
    
            if ( element.length > 0 && element.attr("role") === "champ-formulaire" ){
                const id = element.attr("id");
                const parent = element.parent();
                if ( ["success","warning","error"].includes(statut) ){
                    switch (statut) {
                        case 'success':
                            parent.removeClass().addClass("col-md-8 has-success has-feedback");
                            $(`#${id}-span`).removeClass().addClass("glyphicon glyphicon-ok form-control-feedback");
                            $(`#${id}-span`).show();
                            break;
                        case 'warning':
                            parent.removeClass().addClass("col-md-8 has-warning has-feedback");
                            $(`#${id}-span`).removeClass().addClass("glyphicon glyphicon-warning-sign form-control-feedback");
                            $(`#${id}-span`).show();
                            break;
                        case 'error':
                            parent.removeClass().addClass("col-md-8 has-error has-feedback");
                            $(`#${id}-span`).removeClass().addClass("glyphicon glyphicon-remove form-control-feedback");
                            $(`#${id}-span`).show();
                            break;
                    }
                    if ( !message.isEmpty() ){
                        $(`#${id}-message`).text(message);
                        $(`#${id}-message`).show();
                    } else {
                        $(`#${id}-message`).hide();  
                    }
                }
            }
        },
    
        hideVerification: function ( element ){
            if ( element.length > 0 && element.attr("role") === "champ-formulaire" ){
                const id = element.attr("id");
                const parent = element.parent();
                parent.removeClass().addClass("col-md-8");
                $(`#${id}-span`).hide();
                $(`#${id}-message`).hide();  
            }
        },
    
        isChampExist: function ( champ_name ){
            var existe = false;
            if ( champ_name !== undefined && !champ_name.isEmpty() ){
                $("[role=list-champ]").each(function() {
                    if( $(this).attr("data-nom") === champ_name ){
                        existe = true;
                    }
                });
            }
            return existe;
        },
    
        getHtml: function ( data ){
    
            var html = "";
            var id = this.getUniqueId();
            html += `<div id="${id}" `;
            html +=     `class="row list-champ-draggable noselect only-in-champ-container"`;
            html +=     `role="list-champ" `;
            html +=     `title="${data.libelle}" `;
            html +=     `data-nom="${data.nom}"`;
            html +=     `data-libelle="${data.libelle}"`;
            html +=     `data-type="${data.type}"`;
            html +=     `data-obligatoire="${data.obligatoire}"`;
            html +=     `data-ineditable="${data.ineditable}"`;
            html +=     `data-aide="${data.aide}"`;
            html +=     `data-defaut="${data.defaut}"`;
            html +=     `data-description="${data.description}"`;
            html +=     `data-params="${data.params}"`;
            html +=     `data-conditions="${data.conditions}"`;
            html +=     `data-modifiable="${data.modifiable}"`;
            html +=    `>`;
            html +=     `<div class="col-md-8 list-champ-title">`;
            html +=         `${data.libelle}`;
            html +=          (data.obligatoire == 1)?'<i class="fas fa-star-of-life" style="color:#f08377; float:right; margin-top: 2px;"></i>':'';
            html +=     `</div>`;
            html +=     `<div role="display-conditions" class="col-md-1">`
            html +=     `</div>`
            html +=     `<div class="col-md-2 list-champ-type">${this.getLibelleType(data.type)}</div>`;
            html +=     `<div class="col-md-1 ">`;
            html +=         ` <i class="far fa-edit list-champ-edit-btn" role="navigation" data-route="/champs/?type=${data.type}&id=${id}"></i>`;
            html +=     `</div>`;
            html += `</div>`;
    
            return html;
        },
    
        // On ajoute une condition au champ
        addCondition: function ( id, condition){
            var conditions = this.getConditions( id );
            if ( !this.isConditionExist( condition, conditions) ) {
                conditions.push(condition);
                $(`#${id}`).attr("data-conditions", JSON.stringify(conditions).utf8ToB64() );
                return true;
            }
            return false;
        },
    
        // Retourne un array des conditions du champ
        getConditions: function ( id ){
            var conditions = [];
            var data = this.getData(id);
            if (  data.conditions !== undefined && !data.conditions.isEmpty() ){
                conditions = JSON.parse( data.conditions.b64ToUtf8() ); 
            }
            return conditions;
        },
    
        // Vérifie si une condition exist deja sur le champ
        isConditionExist: function ( condition, conditions){
            var exist = false;
            if ( Object.getLength(conditions) > 0 ) {
                conditions.forEach(function(element) {
                    if ( condition.champ === element.champ && condition.champ === element.champ && condition.value === element.value ){
                        exist = true;
                    }
                }); 
            }
            return exist;
        },

        //Retourne les champs qui prennent toute la ligne
        getTypeDouble: function(){
            return ['wysiwyg','note','adresse','api_particulier','adresse_geoloc','tableau','api_r2p'];
        },

        flagModification: function(id){

            var vue = $('#'+id).closest('[role=vue]');

            if($(vue).attr('data-modified') != 'true'){
                $(vue).attr('data-modified','true');
                var element = $($('#app-container').find('[aria-controls=' + $(vue).attr('id') + ']'));
                var existingStyle = element.attr('style');
                var newStyle = existingStyle + ' color: #f20000 !important';

                element.attr('style', newStyle);
            }
        },    
      }
    
    })(jQuery);
    