var jquery = jQuery.noConflict();

jquery(document).ready(function () {

	jquery('#calendar').fullCalendar({
		locale: 'fr',
		defaultView: 'agendaWeek',
		slotDuration: '00:30:00',
		slotLabelInterval: "01:00",
		slotLabelFormat: 'HH:mm',
		height: 700,
		aspectRatio: 15,
		timeFormat: 'HH:mm',
		allDaySlot: false,
		weekends: true, 
		views: {
			month: {
				buttonText: "Mois",
				eventLimit: 5,
			},
			calendarWeek: {
				buttonText: "Semaine",
				eventLimit: 6,
			},
			agendaDay: {
				buttonText: "Jour",
			},
		},

		// Affichage des boutons au dessus du calendrier
		header: {
			left: 'prev,next',
			center: 'title',
			right: 'month,agendaWeek,agendaDay',
		},

		buttonIcons: true, // Utilisation des icones prec/suiv
		weekNumbers: false,// Afficher les numéros de semaines
		navLinks: true,
		businessHours: false, // display business hours
		editable: false,
		eventLimit: true, // allow "more" link when too many events

		events: {
			url: '/index.php?module=' + jQuery('input[name="relate_to"]').val() + '&action=getEventCalendar',
			type: 'POST',
			data: {
				id: jQuery('input[name="record"]').val(),
			},
		},

		// Affiche un message le temps de récupérer les events
		loading: function (bool) {
			document.getElementById('loading').innerText = "Veuillez patienter pendant le chargement ...";
			$('#loading').toggle(bool);
		},

		// Affiche une l'event dans le calendrier (Titre et date)
		eventRender: function (event, element, view) {
			element.find(".fc-title").html("<span class='event_" + event.presence + "'>" + event.title + "</span>");
		},

		eventClick: function (calEvent, jsEvent, view) {},

		// Affiche une popup sur l'event s'il y a une description
		eventMouseover: function (data, event, view) {

			if('description' in data && data.description !== undefined && data.description !== '')
			{
				var tooltip ='<div class="calendar-tooltip" data-container="body" data-toggle="popover" data-placement="top">' + data.description + '</div>';

				$("body").append(tooltip);
				$(this).mouseover(function (e) {
					$(this).css('z-index', 10000);
					$('.calendar-tooltip').fadeIn('500');
					$('.calendar-tooltip').fadeTo('10', 1.9);
				}).mousemove(function (e) {
					$('.calendar-tooltip').css('top', e.pageY - 80);
					$('.calendar-tooltip').css('left', e.pageX + 20);
				});
			}
		},

		// Masque la popup après 
		eventMouseout: function (data, event, view) {
			$(this).css('z-index', 8);
			$('.calendar-tooltip').remove();
		}
	});
});
