<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierInformationsFiscalesAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Modifier informations fiscales "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'profil';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Modifier informations fiscales "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier informations fiscales";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Modifier informations fiscales "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier informations fiscales";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) 
        {
            if(!empty($ref->name))
            {
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text) && !empty($this->dossier->ops_personne_morale))
        {
            $objPersonneMorale = BeanFactory::getBean('OPS_personne_morale',$this->dossier->ops_personne_morale);
            $listeChamps = explode('|',$this->action->ext_valeur_text);
            $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );
            $objInformationFiscale = BeanFactory::newBean('OPS_information_fiscale');

            foreach ($listeChamps as $champs) 
            {
                $champ = explode(';',$champs);
                $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champ[1]);

                $historique = $champ[0];

                if($champ[0] == 'date_application')
                {
                    $historique = 'date_debut_validite';
                }
                else if ($champ[0] == 'qf_ville_actuel')
                {
                    $historique = 'qf_ville';
                }
                else if($champ[0] == 'qf_caf_actuel')
                {
                     $historique = 'qf_caf';
                }

                $objInformationFiscale->{$historique} = $objPersonneMorale->{$champ[0]};
                if(!empty($this->dossier->{$objReferentiel->name}))
                {
                    $value = $this->dossier->{$objReferentiel->name};
                }
                else
                {
                    $value = $customChamp->{$objReferentiel->name};
                }

                if($objReferentiel->type == 'liste')
                {
                    $value = str_replace('^', '', $value);
                }

                $objPersonneMorale->{$champ[0]} = $value;
            }

            if(empty($objPersonneMorale->date_application))
            {
                $objPersonneMorale->date_application = date("Y-m-d");
            }
            $objPersonneMorale->save();
            
            $objInformationFiscale->date_fin_validite = date('Y-m-d', strtotime('-1 day', strtotime($objPersonneMorale->date_application)));
            $objInformationFiscale->ops_personne_morale_id = $this->dossier->ops_personne_morale;
            $objInformationFiscale->save();
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ModifierInformationsFiscalesAction";
    }

    private function getChamps(){
        return array(
            'numero_fiscale' => 'NIF',
            'regime_allocataire' => 'Régime Allocataire',
            'numero_allocataire' => 'Numéro d\'allocataire',
            'qf_caf_actuel' => 'Quotient familial allocataire',
            'qf_ville_actuel' => 'Quotient familial ville',
            'date_application' => 'Date d\'application',
        );
    }
}