<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierEnfantAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Modifier un enfant "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'individu';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Modifier un enfant "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier un enfant";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Modifier un enfant "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier un enfant";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) 
        {
            if(!empty($ref->name))
            {
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text) && !empty($this->dossier->beneficiaire_id))
        {
            $objIndividu = BeanFactory::getBean('OPS_individu', $this->dossier->beneficiaire_id);

            $personne_morale_individu_field = [
                'role',
                'autorite_parentale',
                'mode_garde',
                'referent_tarifaire',
                'presence',
                'payeur',
                'assurance_compagnie',
                'assurance_numero',
                'date_debut_validite',
                'date_fin_validite',
                'responsable',
                'acces_usager'
            ];

            $phone_fields = [
                'phone_mobile',
                'phone_work',
                'phone_home',
                'phone_other',
            ];

            if( !empty($objIndividu->type_individu) && $objIndividu->type_individu == 'enfant' )
            {
                $linkedBeans = $objIndividu->get_linked_beans('ops_individu_ops_personne_morale_individu', 'OPS_personne_morale_individu');

                foreach ($linkedBeans as $linkedBeanPersonneMoraleIndividu) 
                {
                    if ($linkedBeanPersonneMoraleIndividu->ops_personne_morale_id == $this->dossier->ops_personne_morale) 
                    {
                        $objPersonneMoraleIndividu = $linkedBeanPersonneMoraleIndividu;
                        break;
                    }
                }

                $listeChamps = explode('|', $this->action->ext_valeur_text);
                $customChamp = json_decode( base64_decode( $this->dossier->champs_custom ) );

                foreach ($listeChamps as $champs) 
                {
                    $champ = explode(';', $champs);
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);

                    // Récupération valeur du champ dans le dossier
                    if(!empty($this->dossier->{$objReferentiel->name}))
                    {
                        $value = $this->dossier->{$objReferentiel->name};
                    }
                    else
                    {
                        $value = $customChamp->{$objReferentiel->name};
                    }

                    if($objReferentiel->type == 'liste')
                    {
                        $value = str_replace('^', '', $value);
                    }

                    // Adresse domiciliation
                    if($champ[0] == 'adresse_domiciliation')
                    {
                        $value = html_entity_decode($value,ENT_NOQUOTES);

                        // Vérifie si la valeur est encodé en base 64
                        if (!empty($value) && base64_encode(base64_decode($value, true)) === $value)
                        {
                            $value = json_decode(base64_decode($value));
                            
                            $objIndividu->primary_address_number              = $value->numero;
                            $objIndividu->primary_address_street              = $value->rue;
                            $objIndividu->primary_address_complement_batiment = $value->complement_batiment;
                            $objIndividu->primary_address_complement_lieu     = $value->complement_lieu;
                            $objIndividu->primary_address_postalcode          = $value->postcode;
                            $objIndividu->primary_address_city                = $value->city;
                        }
                        else if(in_array($champ[0], $phone_fields))
                        {
                            $objIndividu->{$champ[0]} = preg_replace("/[^0-9]/", " ", html_entity_decode($value));
                        }
                        else if (empty($value))
                        {
                            $objIndividu->primary_address_number              = '';
                            $objIndividu->primary_address_street              = '';
                            $objIndividu->primary_address_complement_batiment = '';
                            $objIndividu->primary_address_complement_lieu     = '';
                            $objIndividu->primary_address_postalcode          = '';
                            $objIndividu->primary_address_city                = '';
                        }
                    }
                    // Pour alimenter la relation du profil avec l'individu
                    else if (in_array($champ[0], $personne_morale_individu_field) && !empty($objPersonneMoraleIndividu))
                    {
                        $objPersonneMoraleIndividu->{$champ[0]} = $value; 
                    }
                    // Autre champs
                    else
                    {
                        $objIndividu->{$champ[0]} = $value;
                    }
                }

                $objIndividu->save();
                
                if (!empty($objPersonneMoraleIndividu)) {
                    $objPersonneMoraleIndividu->save();
                }

                if ($objIndividu->load_relationship('email_addresses')) 
                {
                    $relatedBeans = $objIndividu->get_linked_beans('email_addresses');
                    if(count($relatedBeans) > 0)
                    {
                        $relatedBeans[0]->email_address = $objIndividu->email1;
                        $relatedBeans[0]->save();
                    }
                }
            }
            else
            {
                $GLOBALS['log']->fatal('ModifierEnfantAction::execute() => L\'individu n\'est pas un enfant');
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ModifierEnfantAction";
    }

    private function getChamps(){
        return array(
            'sexe' => 'Sexe',
            'last_name' => 'Nom de famille',
            'nom_usage' => 'Nom d\'usage',
            'first_name' => 'Prénom',
            'etat' => 'Etat',
            'nationalite' => 'Nationalité',
            'date_naissance' => 'Date de naissance',
            'lieu_naissance' => 'Ville de naissance',
            'pays_naissance' => 'Pays de naissance',
            'production_diffusion_image' => 'Production et diffusion publique de l’image de l’enfant',
            'diffusion_caf' => 'Diffusion des données à l’organisme d’allocation familiale',
            'attestation_assurance' => 'Attestation de souscription d’une assurance responsabilité civile en cours de validité',
            'handicap' => 'En situation de handicap',
            'aide_handicap' => 'Bénéficiaire de l\'AEEH',
            'vaccin_a_jour' => 'Vaccination à jour',
            'medecin_traitant' => 'Médecin traitant',
            'presence_trouble_consigne' => 'Présence de troubles de la santé ou de consignes particulières',
            'email1' => 'E-mail',
            'phone_mobile' => 'Tél. portable',
            'phone_home' => 'Tél. fixe',
            'phone_work' => 'Tél. professionnel',
            'phone_other' => 'Autre tél.',
            'accepte_mail' => 'Accepte mails',
            'accepte_sms' => 'Accepte SMS',
            'adresse_domiciliation' => 'Adresse de domiciliation',
            'menu_autorise' => 'Type de menu autorisé',
            'fai' => 'PAI',
            'role' => 'Fonction',
            'autorite_parentale' => 'Autorité parentale',
            'mode_garde' => 'Mode de garde',
            'referent_tarifaire' => 'Référent tarifaire',
            'presence' => 'Présence',
            'payeur' => 'Payeur',
            'assurance_compagnie' => 'Compagnie d\'assurance',
            'assurance_numero' => 'N° assurance',
            'date_debut_validite' => 'Date début de validité',
            'date_fin_validite' => 'Date fin de validité',
            'responsable' => 'Responsable',
            'acces_usager' => 'Accès internet',
        );
    }
}