<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierChampDossierAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Modifier agréments et relations "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'dossier';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Modifier un champ "
     * 
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier un champ";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Modifier un champ "
     * 
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier un champ du dossier";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        // Construction du tableau de referentiel  'id' => 'name'  
        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list(
                                'libelle'
                                );

        $referentiel_array = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) {

            if( !empty($ref->name) ){
                $referentiel_array[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }


        }
        // Construction des options 
        $referentiel_liste = get_select_options_with_id($referentiel_array, $this->action->ext_valeur_1);

        $data['ext_valeur_1']['type']  = 'enum';
        $data['ext_valeur_1']['label'] = 'Nom du champ';
        $data['ext_valeur_1']['form']  = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">' . $referentiel_liste . '</select>';

        $data['ext_valeur_2']['type'] = 'text';
        $data['ext_valeur_2']['label'] = 'Valeur';
        $data['ext_valeur_2']['form'] = '<input type="text" name="ext_valeur_2" id="ext_valeur_2" value="'.$this->action->ext_valeur_2.'">';

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     * 
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $objReferentiel = (!empty($this->action->ext_valeur_1)) ? BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_1) : null;
        $referentiel_name = ($objReferentiel !== null && !empty($objReferentiel->libelle)) ? $objReferentiel->libelle : "";

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Nom du champ';
        $data['ext_valeur_1']['valeur']  = $referentiel_name;

        $data['ext_valeur_2']['type'] = 'text';
        $data['ext_valeur_2']['label'] = 'Valeur';
        $data['ext_valeur_2']['valeur'] = $this->action->ext_valeur_2;

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     * 
     *  @return void    
     */
    public function execute()
    {
        if(!empty($this->dossier)){
            if(!empty($this->action->ext_valeur_1)){
                $objReferentiel =  BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_1);

                $referentielName = $objReferentiel->name;

                if($objReferentiel->description == 'basic'){
                    $this->dossier->$referentielName = $this->action->ext_valeur_2;
                    $this->dossier->save();
                }else if($objReferentiel->description == 'custom'){
                    $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );
                    $customChamp->{$referentielName} = $this->action->ext_valeur_2;
                    $this->dossier->champs_custom = base64_encode( json_encode( $customChamp ) );
                    $this->dossier->save();
                }
                else{
                    $GLOBALS['log']->fatal('ModifierChampDossierAction => le champ '.$referentielName.' n\'existe pas') ;
                }
            }else{
                $GLOBALS['log']->fatal('ModifierChampDossierAction => Nom du champ vide') ;
            }
        }
    }

     /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }
}
