<?php

namespace ODE\ActionLot\Action;

if (!defined('sugarEntry')) define('sugarEntry', true);

use ODE\Modal\OdeModal;

class ModifierStatutAction
{

    /**
     * @access public
     * @name getAction()
     * Fonction qui retourne l'action " Modifier Statut "
     * 
     *  @return array       - $action
     */
    public function getAction()
    {

        return array(
            'module_name' => 'OPS_dossier',
            'action_content' => $this->getActionContent(),
            'action_link' => $this->getActionLink(),
        );
    }

    /**
     * @access public
     * @name getActionOrdre()
     * Fonction qui retourne l'ordre de l'action
     * 
     *  @return array       - $action_ordre
     */
    public function getActionOrdre()
    {
        return 1;
    }

    /**
     * @access private
     * @name getActionContent()
     * Fonction qui retourne le content de l'action
     * 
     *  @return array       - $action_content
     */
    private function getActionContent()
    {
        return $this->getActionLink() . $this->getActionHTML();
    }

    /**
     * @access private
     * @name getActionLink()
     * Fonction qui retourne le link de l'action
     * 
     *  @return array       - $action_link
     */
    private function getActionLink()
    {
        return '<a role="ode-modal-statut-btn" >Modifier le statut</a> ';
    }

    /**
     * @access private
     * @name getActionHTML()
     * Fonction qui retourne l'html de l'action
     * 
     *  @return array       - $action_html
     */
    private function getActionHTML()
    {
        $modal = new OdeModal('ode_modal_statut');
        $modal->setTitle('MODIFIER LE STATUT');
        $modal->setCss(['modules/OPS_statut/css/modifier_statut.css']);
        $modal->setJS(['modules/OPS_statut/js/modifier_statut.js']);
        $modal->setPages(['modules/OPS_statut/tpls/modifier_statut.tpl']);
        return $modal->getHtml();
    }
}
