<?php 

namespace ODE\ActionLot\Action;

if (!defined('sugarEntry')) define('sugarEntry', true);

use ODE\Modal\OdeModal;

Class ModifierCommissionAction {

    /**
     * @access public
     * @name getAction()
     * Fonction qui retourne l'action " Modifier commission "
     * 
     *  @return array       - $action
    */
    public function getAction() {

        return array(
            'module_name' => 'OPS_dossier',
            'action_content' => $this->getActionContent(),
            'action_link' => $this->getActionLink(),
        );

    }

    /**
     * @access public
     * @name getActionOrdre()
     * Fonction qui retourne l'ordre de l'action
     * 
     *  @return array       - $action_ordre
    */
    public function getActionOrdre() {
        return 3;
    }

    /**
     * @access private
     * @name getActionContent()
     * Fonction qui retourne le content de l'action
     * 
     *  @return array       - $action_content
    */
    private function getActionContent() {
        return $this->getActionLink() . $this->getActionHTML();
    }

    /**
     * @access private
     * @name getActionLink()
     * Fonction qui retourne le link de l'action
     * 
     *  @return array       - $action_link
    */
    private function getActionLink() {
        return '<a role="ode-modal-commission-btn" >Modifier la commission</a>';
    }
   
    /**
     * @access private
     * @name getActionHTML()
     * Fonction qui retourne l'html de l'action
     * 
     *  @return array       - $action_html
    */
    private function getActionHTML() {
        $modal = new OdeModal('ode_modal_commission');
        $modal->setTitle('MODIFIER LA COMMISSION');
        $modal->setCss(['modules/OPS_commission/css/modifier_commission.css']);
        $modal->setJS(['modules/OPS_commission/js/modifier_commission.js']);
        $modal->setPages(['modules/OPS_commission/tpls/modifier_commission.tpl']);
        return $modal->getHtml();
    }

}