<?php

namespace ODE\ActionLot\Action;

if (!defined('sugarEntry')) define('sugarEntry', true);

use ODE\Modal\OdeModal;

Class ExporterFormulaireAction
{

    /**
     * @access public
     * @name getAction()
     * Fonction qui retourne l'action " Exporter formulaire en format Json "
     * 
     *  @return array       - $action
     */
    public function getAction()
    {

        return array(
            'module_name' => 'OPS_generateur_formulaire',
            'action_content' => $this->getActionContent(),
            'action_link' => $this->getActionLink()
        );
    }

    /**
     * @access public
     * @name getActionOrdre()
     * Fonction qui retourne l'ordre de l'action
     * 
     *  @return array       - $action_ordre
    */
    public function getActionOrdre() {
        return 1;
    }
    
    /**
     * @access private
     * @name getActionContent()
     * Fonction qui retourne le content de l'action
     * 
     *  @return array       - $action_content
    */
    private function getActionContent() {
        return $this->getActionLink() . $this->getActionHTML();
    }

    /**
     * @access private
     * @name getActionLink()
     * Fonction qui retourne le link de l'action
     * 
     *  @return array       - $action_link
     */
    private function getActionLink()
    {
        return '<a role="ode-modal-formulaire-btn" > Exporter modèles de dossiers</a>';
    }

    /**
     * @access private
     * @name getActionHTML()
     * Fonction qui retourne l'html de l'action
     * 
     *  @return array       - $action_html
     */
    private function getActionHTML()
    {
        $modal = new OdeModal('ode_modal_export_formulaire');
        $modal->setTitle('Exporter les modèles de dossiers');
        $modal->setCss(['modules/OPS_generateur_formulaire/css/exporter.css']);
        $modal->setJS(['modules/OPS_generateur_formulaire/js/exporter.js']);
        $modal->setPages(['modules/OPS_generateur_formulaire/tpls/exporter.tpl']);
        return $modal->getHtml();
    }
}
